/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.draw.flames;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.draw.Rasterizer2D;
import com.hazy.draw.flames.FlameColours;
import com.hazy.draw.flames.FlameImages;
import java.util.Arrays;

public class FlameManager {
    private final int[] flameOffsets = new int[256];
    private int flameFrameCounter = 0;
    private int random1 = 0;
    private int random2 = 0;
    private int[] flameStrengths;
    private int[] tempFlameStrengths;
    private int[] titleFlames;
    private int[] titleFlamesTemp;
    private int animationFrame = 0;
    private int animationOffset = 0;
    private int currentCycle = 0;
    private FlameColours flameColours;

    public FlameManager() {
        this.initColors();
    }

    void initColors() {
        this.flameColours = new FlameColours();
        this.animationFrame = 0;
        this.titleFlames = new int[32768];
        this.titleFlamesTemp = new int[32768];
        this.updateFlameShape(null);
        this.flameStrengths = new int[32768];
        this.tempFlameStrengths = new int[32768];
    }

    public void reset() {
        this.flameColours.redFlameColours = null;
        this.flameColours.greenFlameColours = null;
        this.flameColours.blueFlameColours = null;
        this.flameColours.currentFlameColours = null;
        this.titleFlames = null;
        this.titleFlamesTemp = null;
        this.flameStrengths = null;
        this.tempFlameStrengths = null;
        this.animationFrame = 0;
        this.animationOffset = 0;
    }

    public void draw(int xPosition, int yPosition, int cycle, int alpha) {
        int lastCycle;
        if (this.flameStrengths == null) {
            this.initColors();
        }
        if (this.currentCycle == 0) {
            this.currentCycle = cycle;
        }
        if ((lastCycle = cycle - this.currentCycle) >= 256) {
            lastCycle = 0;
        }
        this.currentCycle = cycle;
        if (lastCycle > 0) {
            this.updateFlameAnimation(lastCycle);
        }
        this.initializeFlames(xPosition, yPosition, alpha);
    }

    final void updateFlameAnimation(int timeElapsed) {
        int offset;
        int rand;
        this.animationFrame += timeElapsed * 128;
        if (this.animationFrame > this.titleFlames.length) {
            this.animationFrame -= this.titleFlames.length;
            this.updateFlameShape(Client.spriteCache.get(FlameImages.getRandomImage()));
        }
        int index = 0;
        int originalIndex = timeElapsed * 128;
        int currentTime = (256 - timeElapsed) * 128;
        for (int strengthIndex = 0; strengthIndex < currentTime; ++strengthIndex) {
            int remainingIndex = this.flameStrengths[originalIndex + index] - this.titleFlames[index + this.animationFrame & this.titleFlames.length - 1] * timeElapsed / 6;
            if (remainingIndex < 0) {
                remainingIndex = 0;
            }
            this.flameStrengths[index++] = remainingIndex;
        }
        int threshold = 10;
        int variance = 128 - threshold;
        for (rand = 256 - timeElapsed; rand < 256; ++rand) {
            int baseOffset = rand * 128;
            for (int currentOffset = 0; currentOffset < 128; ++currentOffset) {
                offset = (int)(Math.random() * 100.0);
                if (offset < 50 && currentOffset > threshold && currentOffset < variance) {
                    this.flameStrengths[currentOffset + baseOffset] = 255;
                    continue;
                }
                this.flameStrengths[baseOffset + currentOffset] = 0;
            }
        }
        if (this.random1 > 0) {
            this.random1 -= timeElapsed * 4;
        }
        if (this.random2 > 0) {
            this.random2 -= timeElapsed * 4;
        }
        if (this.random1 == 0 && this.random2 == 0) {
            rand = (int)(Math.random() * (double)(2000 / timeElapsed));
            if (rand == 0) {
                this.random1 = 1024;
            }
            if (rand == 1) {
                this.random2 = 1024;
            }
        }
        for (rand = 0; rand < 256 - timeElapsed; ++rand) {
            this.flameOffsets[rand] = this.flameOffsets[rand + timeElapsed];
        }
        for (rand = 256 - timeElapsed; rand < 256; ++rand) {
            this.flameOffsets[rand] = (int)(Math.sin((double)this.flameFrameCounter / 14.0) * 16.0 + Math.sin((double)this.flameFrameCounter / 15.0) * 14.0 + Math.sin((double)this.flameFrameCounter / 16.0) * 12.0);
            ++this.flameFrameCounter;
        }
        this.animationOffset += timeElapsed;
        rand = ((Client.tick & 1) + timeElapsed) / 2;
        if (rand > 0) {
            int xIndex;
            int z;
            int y;
            int x;
            int amplitude = 128;
            int yOffset = 2;
            offset = 128 - yOffset - yOffset;
            for (x = 0; x < this.animationOffset * 100; ++x) {
                y = (int)(Math.random() * (double)offset) + yOffset;
                z = (int)(Math.random() * (double)amplitude) + amplitude;
                this.flameStrengths[y + (z << 7)] = 192;
            }
            this.animationOffset = 0;
            for (x = 0; x < 256; ++x) {
                int accumulator = 0;
                int zIndex = x * 128;
                for (xIndex = -rand; xIndex < 128; ++xIndex) {
                    if (xIndex + rand < 128) {
                        accumulator += this.flameStrengths[rand + zIndex + xIndex];
                    }
                    if (xIndex - (rand + 1) >= 0) {
                        accumulator -= this.flameStrengths[zIndex + xIndex - (rand + 1)];
                    }
                    if (xIndex < 0) continue;
                    this.tempFlameStrengths[zIndex + xIndex] = accumulator / (rand * 2 + 1);
                }
            }
            for (x = 0; x < 128; ++x) {
                y = 0;
                for (z = -rand; z < 256; ++z) {
                    xIndex = z * 128;
                    if (rand + z < 256) {
                        y += this.tempFlameStrengths[x + xIndex + rand * 128];
                    }
                    if (z - (rand + 1) >= 0) {
                        y -= this.tempFlameStrengths[xIndex + x - (rand + 1) * 128];
                    }
                    if (z < 0) continue;
                    this.flameStrengths[xIndex + x] = y / (rand * 2 + 1);
                }
            }
        }
    }

    final int rotateFlameColour(int r, int g2, int b) {
        int alpha = 256 - b;
        return ((r & 0xFF00FF) * alpha + (g2 & 0xFF00FF) * b & 0xFF00FF00) + ((r & 0xFF00) * alpha + (g2 & 0xFF00) * b & 0xFF0000) >> 8;
    }

    final void initializeFlames(int xPosition, int yPosition, int alpha) {
        int length = this.flameColours.currentFlameColours.length;
        if (this.random1 > 0) {
            this.changeColours(this.random1, this.flameColours.greenFlameColours);
        } else if (this.random2 > 0) {
            this.changeColours(this.random2, this.flameColours.blueFlameColours);
        } else {
            System.arraycopy(this.flameColours.redFlameColours, 0, this.flameColours.currentFlameColours, 0, length);
        }
        this.drawFlames(xPosition, yPosition, alpha);
    }

    final void changeColours(int random1, int[] colors) {
        int currentColorSize = this.flameColours.currentFlameColours.length;
        for (int strength = 0; strength < currentColorSize; ++strength) {
            this.flameColours.currentFlameColours[strength] = random1 > 768 ? this.rotateFlameColour(this.flameColours.redFlameColours[strength], colors[strength], 1024 - random1) : (random1 > 256 ? colors[strength] : this.rotateFlameColour(colors[strength], this.flameColours.redFlameColours[strength], 256 - random1));
        }
    }

    final void drawFlames(int xPosition, int yPosition, int alpha) {
        int pixelIndex = 0;
        for (int offset = 1; offset < 255; ++offset) {
            int strength = (256 - offset) * this.flameOffsets[offset] / 256;
            int xPos = strength + xPosition;
            int clippingStart = Math.max(0, -xPos);
            int clippingEnd = Math.min(128, Client.rasterProvider.width - xPos);
            if (xPos + clippingEnd >= Client.rasterProvider.width) {
                clippingEnd = Client.rasterProvider.width - xPos;
            }
            int rowStart = xPos + (offset + 8 + yPosition) * Client.rasterProvider.width;
            pixelIndex += clippingStart;
            for (int xPixel = clippingStart; xPixel < clippingEnd; ++xPixel) {
                int currentStrength = this.flameStrengths[pixelIndex++];
                int currentColumn = rowStart % Rasterizer2D.width;
                if (currentStrength != 0 && currentColumn >= Rasterizer2D.leftX && currentColumn < Rasterizer2D.bottomX) {
                    int inverseStrength = 256 - currentStrength;
                    int currentColor = this.flameColours.getCurrentColour(currentStrength);
                    if (rowStart < 0) {
                        return;
                    }
                    int background = Client.rasterProvider.pixels[rowStart];
                    int blendedColor = 0xFF000000 | (currentStrength * (currentColor & 0xFF00) + inverseStrength * (background & 0xFF00) & 0xFF0000) + ((currentColor & 0xFF00FF) * currentStrength + (background & 0xFF00FF) * inverseStrength & 0xFF00FF00) >> 8;
                    Rasterizer2D.drawAlpha(Client.rasterProvider.pixels, rowStart++, blendedColor, alpha);
                    continue;
                }
                ++rowStart;
            }
            pixelIndex += 128 - clippingEnd;
        }
    }

    final void updateFlameShape(SimpleImage runeImage) {
        int i;
        int alpha = 256;
        Arrays.fill(this.titleFlames, 0);
        for (i = 0; i < 5000; ++i) {
            int pos = (int)(Math.random() * 128.0 * 256.0);
            this.titleFlames[pos] = (int)(Math.random() * 256.0);
        }
        for (i = 0; i < 20; ++i) {
            for (int x = 1; x < 255; ++x) {
                for (int y = 1; y < 127; ++y) {
                    int pos = y + (x << 7);
                    this.titleFlamesTemp[pos] = (this.titleFlames[pos - 1] + this.titleFlames[pos + 1] + this.titleFlames[pos - 128] + this.titleFlames[pos + 128]) / 4;
                }
            }
            int[] temp = this.titleFlames;
            this.titleFlames = this.titleFlamesTemp;
            this.titleFlamesTemp = temp;
        }
        if (runeImage != null) {
            int imagePos = 0;
            for (int y = 0; y < runeImage.height; ++y) {
                for (int x = 0; x < runeImage.width; ++x) {
                    if (runeImage.myPixels[imagePos++] == 0) continue;
                    int xOffset = x + runeImage.x_offset + 16;
                    int yOffset = y + runeImage.y_offset + 16;
                    int pixelIndex = xOffset + (yOffset << 7);
                    this.titleFlames[pixelIndex] = 0;
                }
            }
        }
    }
}

