/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.engine.impl;

import com.hazy.Client;
import com.hazy.engine.GameEngine;
import com.hazy.model.content.Keybinding;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;

public final class KeyHandler
implements KeyListener,
FocusListener {
    public static KeyHandler instance = new KeyHandler();
    public final int[] keyArray = new int[128];
    private final int[] charQueue = new int[128];
    private int readIndex;
    private int writeIndex;
    int keyPressed = 0;
    public static volatile int idleCycles = 0;

    @Override
    public void focusGained(FocusEvent e) {
    }

    @Override
    public final void focusLost(FocusEvent e) {
        for (int i = 0; i < 128; ++i) {
            this.keyArray[i] = 0;
        }
        Client.isShiftPressed = false;
        Client.isCtrlPressed = false;
    }

    @Override
    public void keyTyped(KeyEvent e) {
        Client.instance.getCallbacks().keyTyped(e);
    }

    @Override
    public void keyPressed(KeyEvent event) {
        Client.instance.getCallbacks().keyPressed(event);
        idleCycles = 0;
        int i = event.getKeyCode();
        int keyChar = event.getKeyChar();
        int keycode = event.getKeyCode();
        if (Keybinding.isBound(keycode)) {
            return;
        }
        if (keycode == 27 && Client.instance.settings[594] == 1) {
            if (Client.loggedIn && Client.widget_overlay_id != -1) {
                if (Client.widget_overlay_id == 48700) {
                    Client.tabInterfaceIDs[3] = 3213;
                }
                if (Client.widget_overlay_id == 16200) {
                    GameEngine.addSyncTask(() -> Client.instance.packetSender.sendButtonClick(16202));
                }
                Client.instance.clearTopInterfaces();
                return;
            }
            if (Client.loggedIn && Client.tabInterfaceIDs[Client.sidebarId] == 50290) {
                GameEngine.addSyncTask(() -> Client.instance.packetSender.sendButtonClick(50293));
                return;
            }
        }
        if (keycode == 16) {
            Client.isShiftPressed = true;
        }
        if (keycode == 17) {
            Client.isCtrlPressed = true;
        }
        if (keycode == 66 && Client.isCtrlPressed) {
            Client.instance.packetSender.sendCommand("bank");
        }
        if (keycode == 84 && Client.isCtrlPressed) {
            Client.instance.packetSender.sendCommand("ctrlt");
        }
        if (keyChar < 30) {
            keyChar = 0;
        }
        if (i == 37) {
            keyChar = 1;
        }
        if (i == 39) {
            keyChar = 2;
        }
        if (i == 38) {
            keyChar = 3;
        }
        if (i == 40) {
            keyChar = 4;
        }
        if (i == 17) {
            keyChar = 5;
        }
        if (i == 8) {
            keyChar = 8;
        }
        if (i == 127) {
            keyChar = 8;
        }
        if (i == 9) {
            keyChar = 9;
        }
        if (i == 10) {
            keyChar = 10;
        }
        if (i >= 112 && i <= 123) {
            keyChar = 1008 + i - 112;
        }
        if (i == 36) {
            keyChar = 1000;
        }
        if (i == 35) {
            keyChar = 1001;
        }
        if (i == 33) {
            keyChar = 1002;
        }
        if (i == 34) {
            keyChar = 1003;
        }
        if (keyChar > 0 && keyChar < 128) {
            this.keyArray[keyChar] = 1;
        }
        if (keyChar > 4) {
            this.charQueue[this.writeIndex] = keyChar;
            this.writeIndex = this.writeIndex + 1 & 0x7F;
        }
    }

    public int readChar() {
        int k = -1;
        if (this.writeIndex != this.readIndex) {
            k = this.charQueue[this.readIndex];
            this.readIndex = this.readIndex + 1 & 0x7F;
        }
        return k;
    }

    @Override
    public void keyReleased(KeyEvent event) {
        Client.instance.getCallbacks().keyReleased(event);
        idleCycles = 0;
        int i = event.getKeyCode();
        int c = event.getKeyChar();
        if (i == 16) {
            Client.isShiftPressed = false;
        }
        if (i == 17) {
            Client.isCtrlPressed = false;
            Client.instance.prayerGrabbed = null;
        }
        if (c < 30) {
            c = 0;
        }
        if (i == 37) {
            c = 1;
        }
        if (i == 39) {
            c = 2;
        }
        if (i == 38) {
            c = 3;
        }
        if (i == 40) {
            c = 4;
        }
        if (i == 17) {
            c = 5;
        }
        if (i == 8) {
            c = 8;
        }
        if (i == 127) {
            c = 8;
        }
        if (i == 9) {
            c = 9;
        }
        if (i == 10) {
            c = 10;
        }
        if (c > 0 && c < 128) {
            this.keyArray[c] = 0;
        }
    }
}

