/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.engine.task.impl;

import com.hazy.Client;
import com.hazy.engine.task.Clock;
import com.hazy.engine.task.TaskUtils;
import net.runelite.rs.api.RSNanoClock;

public class NanoClock
extends Clock
implements RSNanoClock {
    long lastTimeNano = System.nanoTime();
    private long tmpNanoTime;

    @Override
    public void mark() {
        this.lastTimeNano = System.nanoTime();
    }

    @Override
    public int wait(int var1, int var2) {
        if (Client.instance.isUnlockedFps() && Client.instance.getRSGameState() >= 25) {
            long nanoTime = System.nanoTime();
            if (nanoTime >= this.getLastTimeNano() && nanoTime >= this.tmpNanoTime) {
                long diff;
                long cycleDuration;
                if (Client.instance.getUnlockedFpsTarget() > 0L) {
                    cycleDuration = nanoTime - this.tmpNanoTime;
                    diff = Client.instance.getUnlockedFpsTarget() - cycleDuration;
                    if ((diff /= 1000000L) > 0L) {
                        try {
                            if (diff % 10L == 0L) {
                                Thread.sleep(diff - 1L);
                                Thread.sleep(1L);
                            } else {
                                Thread.sleep(diff);
                            }
                        }
                        catch (InterruptedException exception) {
                            exception.printStackTrace();
                        }
                        nanoTime = System.nanoTime();
                    }
                }
                this.tmpNanoTime = nanoTime;
                cycleDuration = (long)var1 * 1000000L;
                diff = nanoTime - this.getLastTimeNano();
                int cycles = (int)(diff / cycleDuration);
                this.setLastTimeNano(this.getLastTimeNano() + (long)cycles * cycleDuration);
                if (cycles > 10) {
                    cycles = 10;
                }
                return cycles;
            }
            this.tmpNanoTime = nanoTime;
            this.setLastTimeNano(this.tmpNanoTime);
            return 1;
        }
        long var3 = (long)var2 * 1000000L;
        long var5 = this.lastTimeNano - System.nanoTime();
        if (var5 < var3) {
            var5 = var3;
        }
        TaskUtils.sleep(var5 / 1000000L);
        long var7 = System.nanoTime();
        int var9 = 0;
        while (var9 < 10 && (var9 < 1 || this.lastTimeNano < var7)) {
            ++var9;
            this.lastTimeNano += (long)var1 * 1000000L;
        }
        if (this.lastTimeNano < var7) {
            this.lastTimeNano = var7;
        }
        return var9;
    }

    @Override
    public long getLastTimeNano() {
        return this.lastTimeNano;
    }

    @Override
    public void setLastTimeNano(long lastNanoTime) {
        this.lastTimeNano = lastNanoTime;
    }
}

