/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity;

import com.hazy.Client;
import com.hazy.cache.def.ObjectDefinition;
import com.hazy.entity.Renderable;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.coords.Angle;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.client.util.ObjectKeyUtil;
import net.runelite.rs.api.RSGameObject;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSRenderable;

public final class InteractiveObject
implements RSGameObject {
    public int zLoc;
    public int tileHeight;
    public int xPos;
    public int yPos;
    public Renderable renderable;
    public int turnValue;
    public int xLocLow;
    public int xLocHigh;
    public int yLocHigh;
    public int yLocLow;
    public int camera_distance;
    public int rendered;
    public long uid;
    public int anInt527;
    public int anInt528;
    public byte mask;

    public RSModel getModel() {
        RSRenderable renderable = this.getRenderable();
        if (renderable == null) {
            return null;
        }
        if (renderable instanceof RSModel) {
            return (RSModel)renderable;
        }
        return renderable.getModel();
    }

    @Override
    public int sizeX() {
        return this.xLocHigh - this.xLocLow;
    }

    @Override
    public int sizeY() {
        return this.yLocHigh - this.yLocLow;
    }

    @Override
    public Point getSceneMinLocation() {
        return new Point(this.getStartX(), this.getStartY());
    }

    @Override
    public Point getSceneMaxLocation() {
        return new Point(this.getEndX(), this.getEndY());
    }

    @Override
    public Shape getConvexHull() {
        RSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int tileHeight = Perspective.getTileHeight(Client.instance, new LocalPoint(this.getX(), this.getY()), Client.instance.getPlane());
        return model.getConvexHull(this.getX(), this.getY(), this.getModelOrientation(), tileHeight);
    }

    @Override
    public Angle getOrientation() {
        int orientation = this.getModelOrientation();
        int face = this.getFlags() >> 6 & 3;
        return new Angle(orientation + face * 512);
    }

    @Override
    public int getId() {
        return ObjectKeyUtil.getObjectId(this.uid);
    }

    @Override
    public Point getCanvasLocation() {
        return Perspective.localToCanvas((net.runelite.api.Client)Client.instance, this.getLocalLocation(), this.getPlane(), 0);
    }

    @Override
    public Point getCanvasLocation(int zOffset) {
        return Perspective.localToCanvas((net.runelite.api.Client)Client.instance, this.getLocalLocation(), this.getPlane(), zOffset);
    }

    @Override
    public Polygon getCanvasTilePoly() {
        return Perspective.getCanvasTilePoly(Client.instance, this.getLocalLocation());
    }

    @Override
    public Point getCanvasTextLocation(Graphics2D graphics, String text, int zOffset) {
        return Perspective.getCanvasTextLocation(Client.instance, graphics, this.getLocalLocation(), text, zOffset);
    }

    @Override
    public Point getMinimapLocation() {
        return Perspective.localToMinimap(Client.instance, this.getLocalLocation());
    }

    @Override
    public Shape getClickbox() {
        return Perspective.getClickbox(Client.instance, this.getModel(), this.getModelOrientation(), this.getLocalLocation());
    }

    @Override
    public String getName() {
        return ObjectDefinition.get((int)this.getId()).name;
    }

    @Override
    public String[] getActions() {
        return ObjectDefinition.get((int)this.getId()).scene_actions;
    }

    @Override
    public int getConfig() {
        return this.mask;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromLocal(Client.instance, this.getX(), this.getY(), this.getPlane());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return new LocalPoint(this.getX(), this.getY());
    }

    @Override
    public RSRenderable getRenderable() {
        return this.renderable;
    }

    @Override
    public int getStartX() {
        return this.xLocLow;
    }

    @Override
    public int getStartY() {
        return this.yLocLow;
    }

    @Override
    public int getEndX() {
        return this.xLocHigh;
    }

    @Override
    public int getEndY() {
        return this.yLocHigh;
    }

    @Override
    public int getX() {
        return this.xPos;
    }

    @Override
    public int getY() {
        return this.yPos;
    }

    @Override
    public int getHeight() {
        return this.tileHeight;
    }

    @Override
    public int getModelOrientation() {
        return this.turnValue;
    }

    @Override
    public long getHash() {
        return this.uid;
    }

    @Override
    public int getFlags() {
        return this.mask;
    }

    @Override
    public int getPlane() {
        return this.zLoc;
    }

    @Override
    public void setPlane(int plane) {
        this.zLoc = plane;
    }
}

