/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity;

import com.hazy.Client;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.anim.SpotAnimation;
import com.hazy.cache.def.NpcDefinition;
import com.hazy.entity.Entity;
import com.hazy.entity.Player;
import com.hazy.entity.model.Model;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import net.runelite.api.Actor;
import net.runelite.api.NPC;
import net.runelite.api.NPCComposition;
import net.runelite.api.Perspective;
import net.runelite.api.Point;
import net.runelite.api.RSActorSpotAnim;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.NpcChanged;
import net.runelite.api.events.NpcDespawned;
import net.runelite.rs.api.RSIterableNodeDeque;
import net.runelite.rs.api.RSIterableNodeHashTable;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSNPC;
import net.runelite.rs.api.RSNPCComposition;

public final class Npc
extends Entity
implements RSNPC {
    public NpcDefinition desc;
    public int headIcon = -1;
    public int ownerIndex = -1;
    public int ownedNpcIndex = -1;
    public int overriddenId = -1;

    public boolean showActions() {
        if (this.ownerIndex == -1) {
            return true;
        }
        return Client.instance.localPlayerIndex == this.ownerIndex;
    }

    public int getHeadIcon() {
        if (this.headIcon == -1) {
            if (this.desc != null && this.desc.headIconSpriteIndex != null) {
                return this.desc.headIconSpriteIndex[0];
            }
            if (this.desc != null) {
                return this.desc.defaultHeadIconArchive;
            }
        }
        return this.headIcon;
    }

    private Model get_animated_model() {
        SeqDefinition primarySeq = null;
        SeqDefinition secondarySeq = null;
        if (this.sequence >= 0 && this.sequenceDelay == 0) {
            primarySeq = SeqDefinition.get(this.sequence);
            boolean primarySeqIsSkeletal = primarySeq.isSkeletalAnimation();
            int primaryTransformID = primarySeqIsSkeletal ? -1 : primarySeq.getPrimaryFrameIds()[this.sequenceFrame];
            int secondaryTransformID = -1;
            if (this.secondarySeqID >= 0 && this.secondarySeqID != this.seqStandID) {
                secondarySeq = SeqDefinition.get(this.secondarySeqID);
                boolean secondarySeqIsSkeletal = primarySeq.isSkeletalAnimation();
                int n = secondaryTransformID = secondarySeqIsSkeletal ? -1 : secondarySeq.getPrimaryFrameIds()[this.secondarySeqFrame];
            }
            if (primarySeq.isSkeletalAnimation() || secondarySeq != null && secondarySeq.isSkeletalAnimation()) {
                return this.desc.getAnimatedModelSkeletal(primarySeq, secondarySeq, this.sequenceFrame, this.secondarySeqFrame);
            }
            return this.desc.get_animated_model(secondaryTransformID, primaryTransformID, SeqDefinition.get(this.sequence).getInterleaveOrder());
        }
        int transformID = -1;
        if (this.secondarySeqID >= 0) {
            secondarySeq = SeqDefinition.get(this.secondarySeqID);
            int n = transformID = secondarySeq.isSkeletalAnimation() ? -1 : secondarySeq.getPrimaryFrameIds()[this.secondarySeqFrame];
        }
        if (secondarySeq != null && secondarySeq.isSkeletalAnimation()) {
            return this.desc.getAnimatedModelSkeletal(primarySeq, secondarySeq, this.sequenceFrame, this.secondarySeqFrame);
        }
        return this.desc.get_animated_model(-1, transformID, null);
    }

    @Override
    public Model get_rotated_model() {
        SpotAnimation anim;
        Model model;
        if (this.desc == null) {
            return null;
        }
        Model animated = this.get_animated_model();
        if (animated == null) {
            return null;
        }
        this.height = animated.modelBaseY;
        if (this.currentGfxId != -1 && this.spotanimFrame != -1 && (model = (anim = SpotAnimation.spotAnims[this.currentGfxId]).get_model()) != null) {
            Model graphic = new Model(true, SeqFrame.noAnimationInProgress(this.spotanimFrame), false, model);
            graphic.translate(0, -this.spotanimY, 0);
            if (anim.seq != null && anim.seq.isSkeletalAnimation()) {
                graphic.playSkeletal(anim.seq, this.spotanimFrame);
            } else {
                graphic.generateBones();
                graphic.interpolate(anim.seq.primaryFrameIds[this.spotanimFrame]);
            }
            graphic.faceGroups = null;
            graphic.groupedTriangleLabels = null;
            if (anim.model_scale_x != 128 || anim.model_scale_y != 128) {
                graphic.scale(anim.model_scale_x, anim.model_scale_x, anim.model_scale_y);
            }
            graphic.light(64 + anim.ambient, 850 + anim.contrast, -30, -50, -30, true);
            Model[] build = new Model[]{animated, graphic};
            animated = new Model(build);
        }
        if (this.desc.occupied_tiles == 1) {
            animated.singleTile = true;
        }
        if (this.recolourAmount != 0 && Client.tick >= this.recolourStartCycle && Client.tick < this.recolourEndCycle) {
            animated.overrideHue = this.recolorHue;
            animated.overrideSaturation = this.recolourSaturation;
            animated.overrideLuminance = this.recolourLuminance;
            animated.overrideAmount = this.recolourAmount;
        } else {
            animated.overrideAmount = 0;
        }
        return animated;
    }

    @Override
    public boolean visible() {
        return this.desc != null;
    }

    @Override
    public int getRSInteracting() {
        return this.index;
    }

    @Override
    public String getOverheadText() {
        return "";
    }

    @Override
    public void setOverheadText(String overheadText) {
    }

    @Override
    public int getX() {
        return this.world_x;
    }

    @Override
    public int getY() {
        return this.world_y;
    }

    @Override
    public int[] getPathX() {
        return this.waypoint_x;
    }

    @Override
    public int[] getPathY() {
        return this.waypoint_y;
    }

    @Override
    public int getRSAnimation() {
        return 0;
    }

    @Override
    public int getAnimation() {
        return 0;
    }

    @Override
    public void setAnimation(int animation) {
    }

    @Override
    public int getAnimationFrame() {
        return 0;
    }

    @Override
    public int getActionFrame() {
        return 0;
    }

    @Override
    public void setAnimationFrame(int frame) {
    }

    @Override
    public boolean hasSpotAnim(int spotAnimId) {
        return false;
    }

    @Override
    public void createSpotAnim(int id, int spotAnimId, int height, int delay) {
    }

    @Override
    public void removeSpotAnim(int id) {
    }

    @Override
    public void clearSpotAnims() {
    }

    @Override
    public void setActionFrame(int frame) {
    }

    @Override
    public int getActionFrameCycle() {
        return 0;
    }

    @Override
    public RSIterableNodeHashTable getSpotAnims() {
        return null;
    }

    @Override
    public RSActorSpotAnim newActorSpotAnim(int id, int height, int delay, int frame) {
        return null;
    }

    @Override
    public int getGraphicsCount() {
        return 0;
    }

    @Override
    public void setGraphicsCount(int count) {
    }

    @Override
    public int getGraphic() {
        return 0;
    }

    @Override
    public void setGraphic(int id) {
    }

    @Override
    public int getGraphicHeight() {
        return 0;
    }

    @Override
    public void setGraphicHeight(int height) {
    }

    @Override
    public int getSpotAnimFrame() {
        return 0;
    }

    @Override
    public void setSpotAnimFrame(int id) {
    }

    @Override
    public int getSpotAnimationFrameCycle() {
        return 0;
    }

    @Override
    public int getIdlePoseAnimation() {
        return 0;
    }

    @Override
    public void setIdlePoseAnimation(int animation) {
    }

    @Override
    public int getPoseAnimation() {
        return 0;
    }

    @Override
    public void setPoseAnimation(int animation) {
    }

    @Override
    public int getPoseFrame() {
        return 0;
    }

    @Override
    public void setPoseFrame(int frame) {
    }

    @Override
    public int getPoseFrameCycle() {
        return 0;
    }

    @Override
    public int getLogicalHeight() {
        return this.height;
    }

    @Override
    public int getOrientation() {
        return this.current_rotation;
    }

    @Override
    public int getCurrentOrientation() {
        return this.current_rotation;
    }

    @Override
    public RSIterableNodeDeque getHealthBars() {
        return null;
    }

    @Override
    public int[] getHitsplatValues() {
        return null;
    }

    @Override
    public int[] getHitsplatTypes() {
        return null;
    }

    @Override
    public int[] getHitsplatCycles() {
        return null;
    }

    @Override
    public int getIdleRotateLeft() {
        return 0;
    }

    @Override
    public int getIdleRotateRight() {
        return 0;
    }

    @Override
    public int getWalkAnimation() {
        return 0;
    }

    @Override
    public int getWalkRotate180() {
        return 0;
    }

    @Override
    public int getWalkRotateLeft() {
        return 0;
    }

    @Override
    public int getWalkRotateRight() {
        return 0;
    }

    @Override
    public int getRunAnimation() {
        return 0;
    }

    @Override
    public void setDead(boolean dead) {
    }

    @Override
    public int getPathLength() {
        return 0;
    }

    @Override
    public int getOverheadCycle() {
        return 0;
    }

    @Override
    public void setOverheadCycle(int cycle) {
    }

    @Override
    public int getPoseAnimationFrame() {
        return 0;
    }

    @Override
    public void setPoseAnimationFrame(int frame) {
    }

    @Override
    public RSModel getModel() {
        return this.get_rotated_model();
    }

    @Override
    public int getCombatLevel() {
        return this.desc.combatLevel;
    }

    @Override
    public String getName() {
        return this.desc.getName();
    }

    @Override
    public boolean isInteracting() {
        return false;
    }

    @Override
    public Actor getInteracting() {
        int index = this.getRSInteracting();
        if (index == -1 || index == 65535) {
            return null;
        }
        Client client = Client.instance;
        if (index < 32768) {
            RSNPC[] npcs = client.getCachedNPCs();
            return npcs[index];
        }
        Player[] players = client.players;
        return players[index -= 32768];
    }

    @Override
    public int getHealthRatio() {
        return 0;
    }

    @Override
    public int getHealthScale() {
        return 0;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromLocal(Client.instance, this.getLocalLocation());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return new LocalPoint(this.world_x, this.world_y);
    }

    @Override
    public void setIdleRotateLeft(int animationID) {
    }

    @Override
    public void setIdleRotateRight(int animationID) {
    }

    @Override
    public void setWalkAnimation(int animationID) {
    }

    @Override
    public void setWalkRotateLeft(int animationID) {
    }

    @Override
    public void setWalkRotateRight(int animationID) {
    }

    @Override
    public void setWalkRotate180(int animationID) {
    }

    @Override
    public void setRunAnimation(int animationID) {
    }

    @Override
    public Polygon getCanvasTilePoly() {
        return Perspective.getCanvasTilePoly(Client.instance, this.getLocalLocation());
    }

    @Override
    public Point getCanvasTextLocation(Graphics2D graphics, String text, int zOffset) {
        return Perspective.getCanvasTextLocation(Client.instance, graphics, this.getLocalLocation(), text, zOffset);
    }

    @Override
    public Point getCanvasImageLocation(BufferedImage image, int zOffset) {
        return Perspective.getCanvasImageLocation(Client.instance, this.getLocalLocation(), image, zOffset);
    }

    @Override
    public Point getCanvasSpriteLocation(SpritePixels sprite, int zOffset) {
        return null;
    }

    @Override
    public Point getMinimapLocation() {
        return Perspective.localToMinimap(Client.instance, this.getLocalLocation());
    }

    @Override
    public Shape getConvexHull() {
        RSModel model = this.getModel();
        if (model == null) {
            return null;
        }
        int size = this.getComposition().getSize();
        LocalPoint tileHeightPoint = new LocalPoint(size * 64 - 64 + this.getX(), size * 64 - 64 + this.getY());
        int tileHeight = Perspective.getTileHeight(Client.instance, tileHeightPoint, Client.instance.getPlane());
        return model.getConvexHull(this.getX(), this.getY(), this.getOrientation(), tileHeight);
    }

    @Override
    public WorldArea getWorldArea() {
        int size = 1;
        if (this instanceof NPC) {
            NPCComposition composition = this.getComposition();
            if (composition != null && composition.getConfigs() != null) {
                composition = composition.transform();
            }
            if (composition != null) {
                size = composition.getSize();
            }
        }
        return new WorldArea(this.getWorldLocation(), size, size);
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public int getId() {
        if (this.overriddenId != -1) {
            return this.overriddenId;
        }
        return this.desc != null ? this.desc.id : -1;
    }

    @Override
    public NPCComposition getTransformedComposition() {
        RSNPCComposition composition = this.getComposition();
        if (composition != null && composition.getConfigs() != null) {
            composition = composition.transform();
        }
        return composition;
    }

    @Override
    public void onDefinitionChanged(NPCComposition composition) {
        if (composition == null) {
            Client.instance.getCallbacks().post(new NpcDespawned(this));
        } else if (this.getId() != -1) {
            RSNPCComposition oldComposition = this.getComposition();
            if (oldComposition == null) {
                return;
            }
            if (composition.getId() == oldComposition.getId()) {
                return;
            }
            Client.instance.getCallbacks().postDeferred(new NpcChanged(this, oldComposition));
        }
    }

    @Override
    public RSNPCComposition getComposition() {
        if (this.overriddenId != -1) {
            return NpcDefinition.get(this.overriddenId);
        }
        return this.desc;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    public void setIndex(int id) {
        this.index = id;
    }
}

