/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity;

import com.hazy.Client;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.anim.SpotAnimation;
import com.hazy.cache.def.ItemDefinition;
import com.hazy.cache.def.NpcDefinition;
import com.hazy.cache.graphics.font.AdvancedFont;
import com.hazy.collection.TempCache;
import com.hazy.entity.Entity;
import com.hazy.entity.model.IdentityKit;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.Shape;
import java.awt.image.BufferedImage;
import javax.annotation.Nullable;
import net.runelite.api.Actor;
import net.runelite.api.HeadIcon;
import net.runelite.api.Point;
import net.runelite.api.RSActorSpotAnim;
import net.runelite.api.SkullIcon;
import net.runelite.api.SpritePixels;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldArea;
import net.runelite.api.coords.WorldPoint;
import net.runelite.rs.api.RSIterableNodeDeque;
import net.runelite.rs.api.RSIterableNodeHashTable;
import net.runelite.rs.api.RSModel;
import net.runelite.rs.api.RSPlayer;
import net.runelite.rs.api.RSPlayerComposition;
import net.runelite.rs.api.RSUsername;

public final class Player
extends Entity
implements RSPlayer {
    public boolean rainbowName;
    public int rights;
    public int donatorRights;
    private long key = -1L;
    public NpcDefinition desc;
    public boolean reference_pose = false;
    public final int[] appearance_colors = new int[5];
    public int team_id;
    private int gender;
    public String username;
    public static TempCache model_cache = new TempCache(260);
    public int combat_level;
    public int overhead_icon;
    public int skull_icon;
    public int hint_arrow_icon;
    public int transform_delay;
    public int transform_duration;
    public int height;
    public boolean visible = false;
    public int x_offset;
    public int z_offset;
    public int y_offset;
    public Model transformed_model;
    public final int[] player_appearance = new int[12];
    private long appearance_offset;
    public int transform_width;
    public int transform_height;
    public int transform_width_offset;
    public int transform_height_offset;
    public int skill_level;
    public String title = "";
    public String titleColor = "";

    public boolean hasRainbowName() {
        return this.username != null && this.username.equalsIgnoreCase("Vanity");
    }

    public int getRainbowColorForChar(int index) {
        long t2 = System.currentTimeMillis();
        float baseHue = (float)(t2 % 5000L) / 5000.0f;
        float hue = (baseHue + (float)index * 0.05f) % 1.0f;
        Color color = Color.getHSBColor(hue, 1.0f, 1.0f);
        return color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
    }

    public void drawRainbowName(AdvancedFont font, String text, int x, int y, boolean shadow) {
        long t2 = System.currentTimeMillis();
        float baseHue = (float)(t2 % 5000L) / 5000.0f;
        int xOffset = x;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            float letterHue = (baseHue + (float)i * 0.05f) % 1.0f;
            Color color = Color.getHSBColor(letterHue, 1.0f, 1.0f);
            int rgb = color.getRed() << 16 | color.getGreen() << 8 | color.getBlue();
            font.draw(String.valueOf(c), xOffset + 1, y + 1, 0, 0);
            font.draw(String.valueOf(c), xOffset, y, rgb, shadow ? 1 : 0);
            xOffset += font.get_width(String.valueOf(c));
        }
    }

    @Override
    public Model get_rotated_model() {
        if (!this.visible) {
            return null;
        }
        Model player = this.get_animated_model();
        if (player == null) {
            return null;
        }
        ((Entity)this).height = player.modelBaseY;
        player.singleTile = true;
        if (this.reference_pose) {
            return player;
        }
        if (this.currentGfxId != -1 && this.spotanimFrame != -1) {
            SpotAnimation anim = SpotAnimation.spotAnims[this.currentGfxId];
            Model model = anim.get_model();
            if (model != null) {
                SeqDefinition seq = anim.seq;
                Model graphic = new Model(false, SeqFrame.noAnimationInProgress(this.spotanimFrame), false, model);
                graphic.translate(0, -this.spotanimY, 0);
                if (seq != null && seq.isSkeletalAnimation()) {
                    graphic.playSkeletal(seq, this.spotanimFrame);
                } else {
                    graphic.generateBones();
                    graphic.interpolate(anim.seq.primaryFrameIds[this.spotanimFrame]);
                }
                graphic.faceGroups = null;
                graphic.groupedTriangleLabels = null;
                if (anim.model_scale_x != 128 || anim.model_scale_y != 128) {
                    graphic.scale(anim.model_scale_x, anim.model_scale_x, anim.model_scale_y);
                }
                if (anim.textureToFind != null) {
                    for (int index = 0; index < anim.textureToFind.length; ++index) {
                        graphic.retexture(anim.textureToFind[index], anim.textureToReplace[index]);
                    }
                }
                graphic.light(64 + anim.ambient, 850 + anim.contrast, -30, -50, -30, true);
                Model[] merged = new Model[]{player, graphic};
                player = new Model(merged);
            } else {
                return null;
            }
        }
        if (this.transformed_model != null) {
            if (Client.tick >= this.transform_duration) {
                this.transformed_model = null;
            }
            if (Client.tick >= this.transform_delay && Client.tick < this.transform_duration) {
                Model model = this.transformed_model;
                model.translate(this.x_offset - this.world_x, this.z_offset - this.height, this.y_offset - this.world_y);
                if (this.turn_direction == 512) {
                    model.rotate_90();
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1024) {
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1536) {
                    model.rotate_90();
                }
                Model[] merged = new Model[]{player, model};
                player = new Model(merged);
                if (this.turn_direction == 512) {
                    model.rotate_90();
                } else if (this.turn_direction == 1024) {
                    model.rotate_90();
                    model.rotate_90();
                } else if (this.turn_direction == 1536) {
                    model.rotate_90();
                    model.rotate_90();
                    model.rotate_90();
                }
                model.translate(this.world_x - this.x_offset, this.height - this.z_offset, this.world_y - this.y_offset);
            }
        }
        player.singleTile = true;
        if (this.recolourAmount != 0 && Client.tick >= this.recolourStartCycle && Client.tick < this.recolourEndCycle) {
            player.overrideHue = this.recolorHue;
            player.overrideSaturation = this.recolourSaturation;
            player.overrideLuminance = this.recolourLuminance;
            player.overrideAmount = this.recolourAmount;
        } else {
            player.overrideAmount = 0;
        }
        return player;
    }

    public void update(Buffer buffer) {
        int index;
        buffer.pos = 0;
        this.title = buffer.readString();
        this.titleColor = buffer.readString();
        this.gender = buffer.readUnsignedByte();
        this.overhead_icon = buffer.readUnsignedByte();
        this.skull_icon = buffer.readUnsignedByte();
        this.hint_arrow_icon = buffer.readUnsignedByte();
        this.desc = null;
        this.team_id = 0;
        for (int bodyPart = 0; bodyPart < 12; ++bodyPart) {
            int team_cape;
            int reset = buffer.readUnsignedByte();
            if (reset == 0) {
                this.player_appearance[bodyPart] = 0;
                continue;
            }
            int id = buffer.readUnsignedByte();
            this.player_appearance[bodyPart] = (reset << 8) + id;
            if (bodyPart == 0 && this.player_appearance[0] == 65535) {
                this.desc = NpcDefinition.get(buffer.readUnsignedShort());
                break;
            }
            if (this.player_appearance[bodyPart] < 512 || this.player_appearance[bodyPart] - 512 >= ItemDefinition.length || (team_cape = ItemDefinition.get((int)(this.player_appearance[bodyPart] - 512)).team) == 0) continue;
            this.team_id = team_cape;
        }
        for (index = 0; index < 5; ++index) {
            int color = buffer.readUnsignedByte();
            if (color < 0 || color >= Client.APPEARANCE_COLORS[index].length) {
                color = 0;
            }
            this.appearance_colors[index] = color;
        }
        this.seqStandID = buffer.readUnsignedShort();
        if (this.seqStandID == 65535) {
            this.seqStandID = -1;
        }
        this.standing_turn_animation_id = buffer.readUnsignedShort();
        if (this.standing_turn_animation_id == 65535) {
            this.standing_turn_animation_id = -1;
        }
        this.walk_animation_id = buffer.readUnsignedShort();
        if (this.walk_animation_id == 65535) {
            this.walk_animation_id = -1;
        }
        this.turn_around_animation_id = buffer.readUnsignedShort();
        if (this.turn_around_animation_id == 65535) {
            this.turn_around_animation_id = -1;
        }
        this.pivot_right_animation_id = buffer.readUnsignedShort();
        if (this.pivot_right_animation_id == 65535) {
            this.pivot_right_animation_id = -1;
        }
        this.pivot_left_animation_id = buffer.readUnsignedShort();
        if (this.pivot_left_animation_id == 65535) {
            this.pivot_left_animation_id = -1;
        }
        this.running_animation_id = buffer.readUnsignedShort();
        if (this.running_animation_id == 65535) {
            this.running_animation_id = -1;
        }
        this.username = buffer.readString();
        this.combat_level = buffer.readUnsignedByte();
        this.rights = buffer.readUnsignedByte();
        this.donatorRights = buffer.readUnsignedByte();
        this.visible = true;
        this.appearance_offset = 0L;
        for (index = 0; index < 12; ++index) {
            this.appearance_offset <<= 4;
            if (this.player_appearance[index] < 256) continue;
            this.appearance_offset += (long)(this.player_appearance[index] - 256);
        }
        if (this.player_appearance[0] >= 256) {
            this.appearance_offset += (long)(this.player_appearance[0] - 256 >> 4);
        }
        if (this.player_appearance[1] >= 256) {
            this.appearance_offset += (long)(this.player_appearance[1] - 256 >> 8);
        }
        for (index = 0; index < 5; ++index) {
            this.appearance_offset <<= 3;
            this.appearance_offset += (long)this.appearance_colors[index];
        }
        this.appearance_offset <<= 1;
        this.appearance_offset += (long)this.gender;
    }

    public Model get_animated_model() {
        long offset = this.appearance_offset;
        int next_frame = -1;
        int current_frame = -1;
        int animation = -1;
        int shield_delta = -1;
        int weapon_delta = -1;
        SeqDefinition primarySeq = null;
        if (this.desc != null) {
            if (this.sequence >= 0 && this.sequenceDelay == 0 && !(primarySeq = SeqDefinition.get(this.sequence)).isSkeletalAnimation()) {
                current_frame = primarySeq.getPrimaryFrameIds()[this.sequenceFrame];
            }
            if (primarySeq != null && primarySeq.isSkeletalAnimation()) {
                return this.desc.getAnimatedModelSkeletal(primarySeq, null, this.sequenceFrame, this.secondarySeqFrame);
            }
            return this.desc.get_animated_model(-1, current_frame, null);
        }
        if (this.sequence >= 0 && this.sequenceDelay == 0) {
            SeqDefinition seq = SeqDefinition.get(this.sequence);
            current_frame = seq.primaryFrameIds[this.sequenceFrame];
            if (this.secondarySeqID >= 0 && this.secondarySeqID != this.seqStandID) {
                animation = SeqDefinition.get((int)this.secondarySeqID).primaryFrameIds[this.secondarySeqFrame];
            }
            if (seq.leftHandItem >= 0) {
                shield_delta = seq.leftHandItem;
                offset += (long)(shield_delta - this.player_appearance[5] << 40);
            }
            if (seq.rightHandItem >= 0) {
                weapon_delta = seq.rightHandItem;
                offset += (long)(weapon_delta - this.player_appearance[3] << 48);
            }
        } else if (this.secondarySeqID >= 0) {
            current_frame = SeqDefinition.get((int)this.secondarySeqID).primaryFrameIds[this.secondarySeqFrame];
        }
        Model model = (Model)model_cache.get(offset);
        if (model == null) {
            boolean cached = false;
            for (int index = 0; index < 12; ++index) {
                int appearance = this.player_appearance[index];
                if (weapon_delta >= 0 && index == 3) {
                    appearance = weapon_delta;
                }
                if (shield_delta >= 0 && index == 5) {
                    appearance = shield_delta;
                }
                if (appearance >= 256 && appearance < 512 && !IdentityKit.cache[appearance - 256].body_cached()) {
                    cached = true;
                }
                if (appearance < 512 || ItemDefinition.get(appearance - 512).equipped_model_cached(this.gender)) continue;
                cached = true;
            }
            if (cached) {
                if (this.key != -1L) {
                    model = (Model)model_cache.get(this.key);
                }
                if (model == null) {
                    return null;
                }
            }
        }
        if (model == null) {
            int index;
            Model[] character = new Model[12];
            int equipped = 0;
            for (index = 0; index < 12; ++index) {
                Model items;
                Model idk;
                int appearance = this.player_appearance[index];
                if (weapon_delta >= 0 && index == 3) {
                    appearance = weapon_delta;
                }
                if (shield_delta >= 0 && index == 5) {
                    appearance = shield_delta;
                }
                if (appearance >= 256 && appearance < 512 && (idk = IdentityKit.cache[appearance - 256].get_body()) != null) {
                    character[equipped++] = idk;
                }
                if (appearance < 512 || (items = ItemDefinition.get(appearance - 512).get_equipped_model(this.gender)) == null) continue;
                character[equipped++] = items;
            }
            model = new Model(equipped, character);
            for (index = 0; index < 5; ++index) {
                if (this.appearance_colors[index] == 0) continue;
                model.recolor(Client.APPEARANCE_COLORS[index][0], Client.APPEARANCE_COLORS[index][this.appearance_colors[index]]);
                if (index != 1) continue;
                model.recolor(Client.SHIRT_SECONDARY_COLORS[0], Client.SHIRT_SECONDARY_COLORS[this.appearance_colors[index]]);
            }
            model.generateBones();
            model.light(64, 850, -30, -50, -30, true);
            model_cache.put(model, offset);
            this.key = offset;
        }
        if (this.reference_pose) {
            return model;
        }
        Model animated = Model.EMPTY_MODEL;
        animated.replace(model, SeqFrame.noAnimationInProgress(current_frame) & SeqFrame.noAnimationInProgress(animation));
        if (current_frame != -1 && animation != -1) {
            animated.mix(SeqDefinition.get(this.sequence).getInterleaveOrder(), animation, current_frame);
        } else if (current_frame != -1) {
            animated.interpolate(current_frame);
        }
        animated.calc_diagonals();
        animated.faceGroups = null;
        animated.groupedTriangleLabels = null;
        return animated;
    }

    public Model get_dialogue_model() {
        if (!this.visible) {
            return null;
        }
        if (this.desc != null) {
            return this.desc.get_dialogue_model();
        }
        boolean cached = false;
        for (int index = 0; index < 12; ++index) {
            int appearance = this.player_appearance[index];
            if (appearance >= 256 && appearance < 512 && !IdentityKit.cache[appearance - 256].headLoaded()) {
                cached = true;
            }
            if (appearance < 512 || ItemDefinition.get(appearance - 512).dialogue_model_cached(this.gender)) continue;
            cached = true;
        }
        if (cached) {
            return null;
        }
        Model[] character = new Model[12];
        int equipped = 0;
        for (int index = 0; index < 12; ++index) {
            Model items;
            Model idk;
            int appearance = this.player_appearance[index];
            if (appearance >= 256 && appearance < 512 && (idk = IdentityKit.cache[appearance - 256].get_head()) != null) {
                character[equipped++] = idk;
            }
            if (appearance < 512 || (items = ItemDefinition.get(appearance - 512).get_equipped_dialogue_model(this.gender)) == null) continue;
            character[equipped++] = items;
        }
        Model model = new Model(equipped, character);
        for (int index = 0; index < 5; ++index) {
            if (this.appearance_colors[index] == 0) continue;
            model.recolor(Client.APPEARANCE_COLORS[index][0], Client.APPEARANCE_COLORS[index][this.appearance_colors[index]]);
            if (index != 1) continue;
            model.recolor(Client.SHIRT_SECONDARY_COLORS[0], Client.SHIRT_SECONDARY_COLORS[this.appearance_colors[index]]);
        }
        return model;
    }

    @Override
    public boolean visible() {
        return this.visible;
    }

    public String getTitle(boolean rightClick) {
        if (this.title.length() > 0) {
            if (rightClick) {
                return this.titleColor + this.title + " <col=ffffff>";
            }
            return this.titleColor + this.title + " <col=0>";
        }
        return "";
    }

    @Override
    @Nullable
    public String getName() {
        return this.username;
    }

    @Override
    public boolean isInteracting() {
        return false;
    }

    @Override
    public Actor getInteracting() {
        return null;
    }

    @Override
    public int getHealthRatio() {
        return 0;
    }

    @Override
    public int getHealthScale() {
        return 0;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromLocal(Client.instance, this.getPathX()[0] * 128 + 64, this.getPathY()[0] * 128 + 64, Client.instance.getPlane());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return new LocalPoint(this.getX(), this.getY());
    }

    @Override
    public void setIdleRotateLeft(int animationID) {
    }

    @Override
    public void setIdleRotateRight(int animationID) {
    }

    @Override
    public void setWalkAnimation(int animationID) {
    }

    @Override
    public void setWalkRotateLeft(int animationID) {
    }

    @Override
    public void setWalkRotateRight(int animationID) {
    }

    @Override
    public void setWalkRotate180(int animationID) {
    }

    @Override
    public void setRunAnimation(int animationID) {
    }

    @Override
    public Polygon getCanvasTilePoly() {
        return null;
    }

    @Override
    @Nullable
    public Point getCanvasTextLocation(Graphics2D graphics, String text, int zOffset) {
        return null;
    }

    @Override
    public Point getCanvasImageLocation(BufferedImage image, int zOffset) {
        return null;
    }

    @Override
    public Point getCanvasSpriteLocation(SpritePixels sprite, int zOffset) {
        return null;
    }

    @Override
    public Point getMinimapLocation() {
        return null;
    }

    @Override
    public Shape getConvexHull() {
        return null;
    }

    @Override
    public WorldArea getWorldArea() {
        return null;
    }

    @Override
    public boolean isDead() {
        return false;
    }

    @Override
    public boolean isMoving() {
        return false;
    }

    @Override
    public Polygon[] getPolygons() {
        return new Polygon[0];
    }

    @Override
    @Nullable
    public HeadIcon getOverheadIcon() {
        return null;
    }

    @Override
    @Nullable
    public SkullIcon getSkullIcon() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public int getRSInteracting() {
        return 0;
    }

    @Override
    public String getOverheadText() {
        return null;
    }

    @Override
    public void setOverheadText(String overheadText) {
    }

    @Override
    public int getX() {
        return this.world_x;
    }

    @Override
    public int getY() {
        return this.world_y;
    }

    @Override
    public int[] getPathX() {
        return this.waypoint_x;
    }

    @Override
    public int[] getPathY() {
        return this.waypoint_y;
    }

    @Override
    public int getRSAnimation() {
        return 0;
    }

    @Override
    public int getAnimation() {
        return 0;
    }

    @Override
    public void setAnimation(int animation) {
    }

    @Override
    public int getAnimationFrame() {
        return 0;
    }

    @Override
    public int getActionFrame() {
        return 0;
    }

    @Override
    public void setAnimationFrame(int frame) {
    }

    @Override
    public boolean hasSpotAnim(int spotAnimId) {
        return false;
    }

    @Override
    public void createSpotAnim(int id, int spotAnimId, int height, int delay) {
    }

    @Override
    public void removeSpotAnim(int id) {
    }

    @Override
    public void clearSpotAnims() {
    }

    @Override
    public void setActionFrame(int frame) {
    }

    @Override
    public int getActionFrameCycle() {
        return 0;
    }

    @Override
    public RSIterableNodeHashTable getSpotAnims() {
        return null;
    }

    @Override
    public RSActorSpotAnim newActorSpotAnim(int id, int height, int delay, int frame) {
        return null;
    }

    @Override
    public int getGraphicsCount() {
        return 0;
    }

    @Override
    public void setGraphicsCount(int count) {
    }

    @Override
    public int getGraphic() {
        return 0;
    }

    @Override
    public void setGraphic(int id) {
    }

    @Override
    public int getGraphicHeight() {
        return 0;
    }

    @Override
    public void setGraphicHeight(int height) {
    }

    @Override
    public int getSpotAnimFrame() {
        return 0;
    }

    @Override
    public void setSpotAnimFrame(int id) {
    }

    @Override
    public int getSpotAnimationFrameCycle() {
        return 0;
    }

    @Override
    public int getIdlePoseAnimation() {
        return 0;
    }

    @Override
    public void setIdlePoseAnimation(int animation) {
    }

    @Override
    public int getPoseAnimation() {
        return 0;
    }

    @Override
    public void setPoseAnimation(int animation) {
    }

    @Override
    public int getPoseFrame() {
        return 0;
    }

    @Override
    public void setPoseFrame(int frame) {
    }

    @Override
    public int getPoseFrameCycle() {
        return 0;
    }

    @Override
    public int getLogicalHeight() {
        return 0;
    }

    @Override
    public int getOrientation() {
        return 0;
    }

    @Override
    public int getCurrentOrientation() {
        return 0;
    }

    @Override
    public RSIterableNodeDeque getHealthBars() {
        return null;
    }

    @Override
    public int[] getHitsplatValues() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatTypes() {
        return new int[0];
    }

    @Override
    public int[] getHitsplatCycles() {
        return new int[0];
    }

    @Override
    public int getIdleRotateLeft() {
        return 0;
    }

    @Override
    public int getIdleRotateRight() {
        return 0;
    }

    @Override
    public int getWalkAnimation() {
        return 0;
    }

    @Override
    public int getWalkRotate180() {
        return 0;
    }

    @Override
    public int getWalkRotateLeft() {
        return 0;
    }

    @Override
    public int getWalkRotateRight() {
        return 0;
    }

    @Override
    public int getRunAnimation() {
        return 0;
    }

    @Override
    public void setDead(boolean dead) {
    }

    @Override
    public int getPathLength() {
        return 0;
    }

    @Override
    public int getOverheadCycle() {
        return 0;
    }

    @Override
    public void setOverheadCycle(int cycle) {
    }

    @Override
    public int getPoseAnimationFrame() {
        return 0;
    }

    @Override
    public void setPoseAnimationFrame(int frame) {
    }

    @Override
    public RSUsername getRsName() {
        return null;
    }

    @Override
    public int getId() {
        return 0;
    }

    @Override
    public int getPlayerId() {
        return 0;
    }

    @Override
    public RSPlayerComposition getPlayerComposition() {
        return null;
    }

    @Override
    public int getCombatLevel() {
        return 0;
    }

    @Override
    public int getTotalLevel() {
        return 0;
    }

    @Override
    public int getTeam() {
        return 0;
    }

    @Override
    public boolean isFriendsChatMember() {
        return false;
    }

    @Override
    public boolean isClanMember() {
        return false;
    }

    @Override
    public boolean isFriend() {
        return false;
    }

    @Override
    public boolean isFriended() {
        return false;
    }

    @Override
    public int getRsOverheadIcon() {
        return 0;
    }

    @Override
    public int getRsSkullIcon() {
        return 0;
    }

    @Override
    public int getRSSkillLevel() {
        return 0;
    }

    @Override
    public String[] getActions() {
        return new String[0];
    }

    @Override
    public RSModel getModel() {
        return this.get_rotated_model();
    }
}

