/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity.model;

import com.hazy.cache.Archive;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import java.util.Arrays;

public final class IdentityKit {
    public static int length;
    public static IdentityKit[] cache;
    public int bodyPartId = -1;
    private int[] models;
    private int[] recolorToFind = new int[6];
    private int[] recolorToReplace = new int[6];
    public short[] retextureToFind;
    public short[] retextureToReplace;
    private final int[] chatheadModels = new int[]{-1, -1, -1, -1, -1};
    public boolean nonSelectable;

    private IdentityKit() {
    }

    public static void init(Archive archive) {
        Buffer buffer = new Buffer(archive.get("idk.dat"));
        length = buffer.readUnsignedShort();
        if (cache == null) {
            cache = new IdentityKit[length];
        }
        for (int index = 0; index < length; ++index) {
            if (cache[index] == null) {
                IdentityKit.cache[index] = new IdentityKit();
            }
            IdentityKit kit = cache[index];
            kit.load(buffer);
        }
    }

    public void load(Buffer is) {
        int opcode;
        while ((opcode = is.readUnsignedByte()) != 0) {
            int index;
            int length;
            if (opcode == 1) {
                this.bodyPartId = is.readUnsignedByte();
                continue;
            }
            if (opcode == 2) {
                length = is.readUnsignedByte();
                this.models = new int[length];
                for (index = 0; index < length; ++index) {
                    this.models[index] = is.readUnsignedShort();
                }
                continue;
            }
            if (opcode == 3) {
                this.nonSelectable = true;
                continue;
            }
            if (opcode == 40) {
                length = is.readUnsignedByte();
                this.recolorToFind = new int[length];
                this.recolorToReplace = new int[length];
                for (index = 0; index < length; ++index) {
                    this.recolorToFind[index] = is.readShort();
                    this.recolorToReplace[index] = is.readShort();
                }
                continue;
            }
            if (opcode == 41) {
                length = is.readUnsignedByte();
                this.retextureToFind = new short[length];
                this.retextureToReplace = new short[length];
                for (index = 0; index < length; ++index) {
                    this.retextureToFind[index] = (short)is.readShort();
                    this.retextureToReplace[index] = (short)is.readShort();
                }
                continue;
            }
            if (opcode < 60 || opcode >= 70) continue;
            this.chatheadModels[opcode - 60] = is.readUnsignedShort();
        }
    }

    public boolean body_cached() {
        if (this.models == null) {
            return true;
        }
        boolean ready = true;
        for (int part = 0; part < this.models.length; ++part) {
            if (Model.cached(this.models[part])) continue;
            ready = false;
        }
        return ready;
    }

    public Model get_body() {
        if (this.models == null || this.models.length == 0) {
            return null;
        }
        Model[] modelParts = new Model[this.models.length];
        for (int part = 0; part < this.models.length; ++part) {
            int modelId = this.models[part];
            if (modelId == -1) continue;
            modelParts[part] = Model.get(modelId);
        }
        if ((modelParts = (Model[])Arrays.stream(modelParts).filter(m4 -> m4 != null).toArray(Model[]::new)).length == 0) {
            return null;
        }
        Model model = modelParts.length == 1 ? modelParts[0] : new Model(modelParts.length, modelParts);
        for (int part = 0; part < this.recolorToFind.length && part < this.recolorToReplace.length && this.recolorToFind[part] != 0; ++part) {
            model.recolor(this.recolorToFind[part], this.recolorToReplace[part]);
        }
        model.recolor(55232, 6804);
        return model;
    }

    public boolean headLoaded() {
        boolean ready = true;
        for (int part = 0; part < 5; ++part) {
            if (this.chatheadModels[part] == -1 || Model.cached(this.chatheadModels[part])) continue;
            ready = false;
        }
        return ready;
    }

    public Model get_head() {
        Model[] models = new Model[5];
        int count = 0;
        for (int part = 0; part < 5; ++part) {
            if (this.chatheadModels[part] == -1) continue;
            models[count++] = Model.get(this.chatheadModels[part]);
        }
        Model model = new Model(count, models);
        for (int part = 0; part < 6 && this.recolorToFind[part] != 0; ++part) {
            model.recolor(this.recolorToFind[part], this.recolorToReplace[part]);
        }
        return model;
    }
}

