/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity.model;

import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.cache.anim.FrameBase;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.anim.SpotAnimation;
import com.hazy.cache.config.VariableBits;
import com.hazy.cache.config.VariableParameter;
import com.hazy.cache.def.AreaDefinition;
import com.hazy.cache.def.FloorDefinition;
import com.hazy.cache.def.ItemDefinition;
import com.hazy.cache.def.NpcDefinition;
import com.hazy.cache.def.ObjectDefinition;
import com.hazy.entity.model.IdentityKit;
import com.hazy.entity.model.Model;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.io.File;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;

public class NpcTextureTool
extends JFrame {
    private JTextField npcIdField;
    private JTextField texField;
    private JTextField flowField;
    private JTextField oldParamField;
    private DefaultListModel<String> colorListModel = new DefaultListModel();
    private JList<String> colorList = new JList<String>(this.colorListModel);
    private JButton loadNpcButton;
    private JButton generateButton;
    private int[] npcColors = new int[0];
    private JTextArea previewArea;
    private final DocumentListener simpleUpdate = new DocumentListener(){

        @Override
        public void insertUpdate(DocumentEvent e) {
            NpcTextureTool.this.updatePreview();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            NpcTextureTool.this.updatePreview();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            NpcTextureTool.this.updatePreview();
        }
    };

    public NpcTextureTool() {
        super("NPC Texture Tool");
        this.setSize(600, 700);
        this.setDefaultCloseOperation(3);
        this.setLocationRelativeTo(null);
        this.setLayout(new BorderLayout(8, 8));
        this.initUI();
    }

    private void loadCacheIfNeeded() {
        try {
            File configArchiveFile = new File("./cache/config/config.dat");
            if (!configArchiveFile.exists()) {
                JOptionPane.showMessageDialog(this, "Could not find config archive: " + configArchiveFile.getAbsolutePath(), "Cache Error", 0);
                return;
            }
            byte[] data2 = Files.readAllBytes(configArchiveFile.toPath());
            Archive configArchive = new Archive(data2);
            ObjectDefinition.init(configArchive);
            FloorDefinition.init(configArchive);
            NpcDefinition.init(configArchive);
            FrameBase.loadFrameBases(configArchive);
            AreaDefinition.init(configArchive);
            IdentityKit.init(configArchive);
            SeqDefinition.init(configArchive);
            SpotAnimation.init(configArchive);
            VariableParameter.init(configArchive);
            VariableBits.init(configArchive);
            ItemDefinition.init(configArchive);
            System.out.println("\u2714 Config cache successfully loaded.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Failed to load cache: " + ex.getMessage(), "Cache Error", 0);
        }
    }

    private void initUI() {
        JPanel top = new JPanel(new GridLayout(0, 2, 5, 5));
        top.setBorder(BorderFactory.createTitledBorder("NPC Loader"));
        top.add(new JLabel("NPC ID:"));
        this.npcIdField = new JTextField();
        top.add(this.npcIdField);
        top.add(new JLabel("Texture ID:"));
        this.texField = new JTextField("85");
        top.add(this.texField);
        top.add(new JLabel("Flow Direction:"));
        this.flowField = new JTextField("1");
        top.add(this.flowField);
        top.add(new JLabel("Old Texture Param:"));
        this.oldParamField = new JTextField("73");
        top.add(this.oldParamField);
        this.add((Component)top, "North");
        this.colorList.setSelectionMode(2);
        JScrollPane scroll = new JScrollPane(this.colorList);
        scroll.setBorder(BorderFactory.createTitledBorder("Model Colors"));
        this.add((Component)scroll, "Center");
        JPanel editPanel = new JPanel(new GridLayout(0, 1, 5, 5));
        editPanel.setBorder(BorderFactory.createTitledBorder("Edit Colors"));
        JButton addBtn = new JButton("\u2795 Add Color");
        JButton removeBtn = new JButton("\u2796 Remove Selected");
        addBtn.addActionListener(e -> this.onAddColor());
        removeBtn.addActionListener(e -> this.onRemoveColor());
        editPanel.add(addBtn);
        editPanel.add(removeBtn);
        this.add((Component)editPanel, "West");
        JPanel bottom = new JPanel(new FlowLayout(2));
        this.loadNpcButton = new JButton("Load NPC");
        this.generateButton = new JButton("Generate Code");
        this.loadNpcButton.addActionListener(this::onLoadNpcClicked);
        this.generateButton.addActionListener(this::onGenerateClicked);
        bottom.add(this.loadNpcButton);
        bottom.add(this.generateButton);
        this.add((Component)bottom, "South");
        this.previewArea = new JTextArea(8, 40);
        this.previewArea.setEditable(false);
        this.previewArea.setFont(new Font("Monospaced", 0, 12));
        this.previewArea.setBorder(BorderFactory.createTitledBorder("Live setTexture Preview"));
        this.add((Component)new JScrollPane(this.previewArea), "East");
        this.colorList.addListSelectionListener(e -> this.updatePreview());
        this.texField.getDocument().addDocumentListener(this.simpleUpdate);
        this.flowField.getDocument().addDocumentListener(this.simpleUpdate);
        this.oldParamField.getDocument().addDocumentListener(this.simpleUpdate);
    }

    private void updatePreview() {
        try {
            int i;
            int tex = Integer.parseInt(this.texField.getText().trim());
            int flow = Integer.parseInt(this.flowField.getText().trim());
            int oldParam = Integer.parseInt(this.oldParamField.getText().trim());
            int[] selected = this.colorList.getSelectedIndices();
            if (selected.length == 0) {
                this.previewArea.setText("// No colors selected");
                return;
            }
            ArrayList<Integer> target = new ArrayList<Integer>();
            for (int index : selected) {
                target.add(this.npcColors[index]);
            }
            StringBuilder sb = new StringBuilder();
            sb.append("model.setTexture(").append(tex).append(", ").append(flow).append(", new int[]{");
            for (i = 0; i < target.size(); ++i) {
                sb.append(target.get(i));
                if (i >= target.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("});\n\n");
            sb.append("model.setTextureOld(").append(tex).append(", ").append(flow).append(", new int[]{");
            for (i = 0; i < target.size(); ++i) {
                sb.append(target.get(i));
                if (i >= target.size() - 1) continue;
                sb.append(", ");
            }
            sb.append("}, ").append(oldParam).append(");");
            this.previewArea.setText(sb.toString());
            this.updateModelPreview();
        }
        catch (Exception ignored) {
            this.previewArea.setText("// Error generating preview");
        }
    }

    private void onLoadNpcClicked(ActionEvent e) {
        try {
            int npcId = Integer.parseInt(this.npcIdField.getText().trim());
            NpcDefinition def = NpcDefinition.get(npcId);
            if (def == null || def.models == null) {
                JOptionPane.showMessageDialog(this, "NPC has no models.");
                return;
            }
            TreeSet<Integer> colors = new TreeSet<Integer>();
            if (def == null) {
                JOptionPane.showMessageDialog(this, "NPC definition is null.");
                return;
            }
            if (def.models == null) {
                JOptionPane.showMessageDialog(this, "NPC has no base models.");
                return;
            }
            for (int modelId : def.models) {
                if (modelId <= 0) continue;
                Model m4 = Model.get(modelId);
                if (m4 == null) {
                    System.err.println("Model " + modelId + " failed to load.");
                    continue;
                }
                if (m4.colors == null) {
                    System.err.println("Model " + modelId + " has no color array.");
                    continue;
                }
                for (short c : m4.colors) {
                    colors.add(c & 0xFFFF);
                }
            }
            this.colorListModel.clear();
            this.npcColors = colors.stream().mapToInt(i -> i).toArray();
            this.refreshColorList();
            this.updatePreview();
            this.updateModelPreview();
            JOptionPane.showMessageDialog(this, "Loaded " + this.npcColors.length + " unique colors.");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error loading NPC.\n" + ex.getMessage());
        }
    }

    private void refreshColorList() {
        this.colorListModel.clear();
        for (int c : this.npcColors) {
            String hex = String.format("0x%04X", c);
            this.colorListModel.addElement(c + "  (" + hex + ")");
        }
    }

    private void onRemoveColor() {
        int[] idx = this.colorList.getSelectedIndices();
        if (idx.length == 0) {
            return;
        }
        ArrayList<Integer> newList = new ArrayList<Integer>();
        for (int i2 = 0; i2 < this.npcColors.length; ++i2) {
            boolean remove = false;
            for (int rm2 : idx) {
                if (rm2 != i2) continue;
                remove = true;
            }
            if (remove) continue;
            newList.add(this.npcColors[i2]);
        }
        this.npcColors = newList.stream().mapToInt(i -> i).toArray();
        this.refreshColorList();
        this.updatePreview();
    }

    private void updateModelPreview() {
        int npcId = Integer.parseInt(this.npcIdField.getText());
        Client.instance.setFullRedraw(true);
    }

    private void onAddColor() {
        String input = JOptionPane.showInputDialog(this, (Object)"Enter color (decimal or hex 0xFFFF):");
        if (input == null || input.isEmpty()) {
            return;
        }
        try {
            int color = input.startsWith("0x") || input.startsWith("0X") ? Integer.parseInt(input.substring(2), 16) : Integer.parseInt(input);
            this.npcColors = Arrays.copyOf(this.npcColors, this.npcColors.length + 1);
            this.npcColors[this.npcColors.length - 1] = color;
            this.refreshColorList();
            this.updatePreview();
            this.updateModelPreview();
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Invalid color.");
        }
    }

    private void onGenerateClicked(ActionEvent e) {
        try {
            int i;
            int tex = Integer.parseInt(this.texField.getText().trim());
            int flow = Integer.parseInt(this.flowField.getText().trim());
            int oldParam = Integer.parseInt(this.oldParamField.getText().trim());
            int[] selected = this.colorList.getSelectedIndices();
            if (selected.length == 0) {
                JOptionPane.showMessageDialog(this, "No colors selected.");
                return;
            }
            ArrayList<Integer> target = new ArrayList<Integer>();
            for (int index : selected) {
                target.add(this.npcColors[index]);
            }
            StringBuilder out = new StringBuilder();
            out.append("model.setTexture(").append(tex).append(", ").append(flow).append(", new int[]{");
            for (i = 0; i < target.size(); ++i) {
                out.append(target.get(i));
                if (i >= target.size() - 1) continue;
                out.append(", ");
            }
            out.append("});\n\n");
            out.append("model.setTextureOld(").append(tex).append(", ").append(flow).append(", new int[]{");
            for (i = 0; i < target.size(); ++i) {
                out.append(target.get(i));
                if (i >= target.size() - 1) continue;
                out.append(", ");
            }
            out.append("}, ").append(oldParam).append(");");
            JTextArea area = new JTextArea(out.toString(), 15, 40);
            area.setEditable(false);
            JOptionPane.showMessageDialog(this, new JScrollPane(area), "Generated Code", -1);
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(this, "Error.\n" + ex.getMessage());
        }
    }

    public static void main(String[] args2) {
    }
}

