/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.entity.model;

import com.hazy.entity.model.Model;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;

public class TextureEditorFrame
extends JFrame {
    private final Model model;
    private final Runnable onModelChanged;
    private JList<String> colorList;
    private DefaultListModel<String> colorListModel;
    private JTextField textureIdField;
    private JTextField flowDirectionField;
    private JTextField extraParamField;
    private JComboBox<String> methodCombo;

    public TextureEditorFrame(Model model, Runnable onModelChanged) {
        super("Texture Editor");
        this.model = model;
        this.onModelChanged = onModelChanged;
        this.initComponents();
        this.loadColorsFromModel();
        this.setDefaultCloseOperation(2);
        this.setSize(420, 600);
        this.setLocationRelativeTo(null);
    }

    private void initComponents() {
        this.setLayout(new BorderLayout(8, 8));
        JPanel topPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        gbc.insets = new Insets(4, 4, 4, 4);
        gbc.fill = 2;
        gbc.gridx = 0;
        gbc.gridy = 0;
        this.methodCombo = new JComboBox<String>(new String[]{"setTexture", "setTextureOld"});
        this.addLabeled(topPanel, gbc, "Method:", this.methodCombo);
        this.textureIdField = new JTextField("85");
        this.addLabeled(topPanel, gbc, "Texture ID (tex):", this.textureIdField);
        this.flowDirectionField = new JTextField("1");
        this.addLabeled(topPanel, gbc, "Flow Direction:", this.flowDirectionField);
        this.extraParamField = new JTextField("73");
        this.addLabeled(topPanel, gbc, "setTextureOld extra param:", this.extraParamField);
        this.add((Component)topPanel, "North");
        this.colorListModel = new DefaultListModel();
        this.colorList = new JList<String>(this.colorListModel);
        this.colorList.setSelectionMode(2);
        this.colorList.setVisibleRowCount(20);
        JScrollPane scrollPane = new JScrollPane(this.colorList);
        scrollPane.setBorder(BorderFactory.createTitledBorder("Available Colors (index: value)"));
        this.add((Component)scrollPane, "Center");
        JPanel bottomPanel = new JPanel(new FlowLayout(2));
        JButton applyButton = new JButton("Apply");
        JButton refreshButton = new JButton("Refresh Colors");
        applyButton.addActionListener(this::onApplyClicked);
        refreshButton.addActionListener(e -> this.loadColorsFromModel());
        bottomPanel.add(refreshButton);
        bottomPanel.add(applyButton);
        this.add((Component)bottomPanel, "South");
    }

    private void addLabeled(JPanel panel, GridBagConstraints gbc, String label, JComponent comp) {
        gbc.gridx = 0;
        gbc.weightx = 0.0;
        panel.add((Component)new JLabel(label), gbc);
        gbc.gridx = 1;
        gbc.weightx = 1.0;
        panel.add((Component)comp, gbc);
        ++gbc.gridy;
    }

    private void loadColorsFromModel() {
        this.colorListModel.clear();
        if (this.model == null) {
            this.colorListModel.addElement("No colors available.");
            return;
        }
        short[] cols = this.model.colors;
        for (int i = 0; i < cols.length; ++i) {
            int col = cols[i] & 0xFFFF;
            String hex = String.format("0x%04X", col);
            this.colorListModel.addElement("Face " + i + " -> " + col + " (" + hex + ")");
        }
    }

    private void onApplyClicked(ActionEvent e) {
        try {
            int tex = Integer.parseInt(this.textureIdField.getText().trim());
            int flowDir = Integer.parseInt(this.flowDirectionField.getText().trim());
            ArrayList<Integer> selectedColorIndices = new ArrayList<Integer>();
            for (int idx : this.colorList.getSelectedIndices()) {
                selectedColorIndices.add(idx);
            }
            if (selectedColorIndices.isEmpty()) {
                JOptionPane.showMessageDialog(this, "No faces/colors selected.", "Warning", 2);
                return;
            }
            int[] targetColors = selectedColorIndices.stream().mapToInt(Integer::intValue).toArray();
            String method = (String)this.methodCombo.getSelectedItem();
            if ("setTexture".equals(method)) {
                this.model.setTexture(tex, flowDir, targetColors);
            } else {
                int extraParam = Integer.parseInt(this.extraParamField.getText().trim());
                this.model.setTextureOld(tex, flowDir, targetColors, extraParam);
            }
            if (this.onModelChanged != null) {
                this.onModelChanged.run();
            }
        }
        catch (NumberFormatException ex) {
            JOptionPane.showMessageDialog(this, "Invalid number format: " + ex.getMessage(), "Error", 0);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            JOptionPane.showMessageDialog(this, "Error applying texture: " + ex.getMessage(), "Error", 0);
        }
    }

    public static void openForModel(Model model, Runnable onModelChanged) {
        SwingUtilities.invokeLater(() -> {
            TextureEditorFrame frame = new TextureEditorFrame(model, onModelChanged);
            frame.setVisible(true);
        });
    }
}

