/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.io;

import com.hazy.Client;
import com.hazy.collection.Cacheable;
import com.hazy.net.IsaacCipher;
import java.math.BigInteger;

public final class Buffer
extends Cacheable {
    private static final int[] BIT_MASKS = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF, 0x1FFFFFF, 0x3FFFFFF, 0x7FFFFFF, 0xFFFFFFF, 0x1FFFFFFF, 0x3FFFFFFF, Integer.MAX_VALUE, -1};
    private static final char[] CHARACTERS = new char[]{'\u20ac', '\u0000', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u0000', '\u017d', '\u0000', '\u0000', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u0000', '\u017e', '\u0178'};
    public static final BigInteger RSA_MODULUS = new BigInteger("131409501542646890473421187351592645202876910715283031445708554322032707707649791604685616593680318619733794036379235220188001221437267862925531863675607742394687835827374685954437825783807190283337943749605737918856262761566146702087468587898515768996741636870321689974105378482179138088453912399137944888201");
    public static final BigInteger RSA_EXPONENT = new BigInteger("65537");
    private IsaacCipher cipher;
    public byte[] payload;
    public int pos;
    public int bitPosition;
    public static final char[] cp1252AsciiExtension = new char[]{'\u20ac', '\u0000', '\u201a', '\u0192', '\u201e', '\u2026', '\u2020', '\u2021', '\u02c6', '\u2030', '\u0160', '\u2039', '\u0152', '\u0000', '\u017d', '\u0000', '\u0000', '\u2018', '\u2019', '\u201c', '\u201d', '\u2022', '\u2013', '\u2014', '\u02dc', '\u2122', '\u0161', '\u203a', '\u0153', '\u0000', '\u017e', '\u0178'};

    public float readFloat() {
        return Float.intBitsToFloat(this.readInt());
    }

    public int readShortOSRS() {
        this.pos += 2;
        int var1 = (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8);
        if (var1 > Short.MAX_VALUE) {
            var1 -= 65536;
        }
        return var1;
    }

    public int peekUByte() {
        if (this.pos >= this.payload.length) {
            return -1;
        }
        return this.payload[this.pos] & 0xFF;
    }

    public int read24BitInt() {
        return (this.readUnsignedByte() << 16) + (this.readUnsignedByte() << 8) + this.readUnsignedByte();
    }

    public String readJagexString() {
        int i = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        return new String(this.payload, i, this.pos - i - 1);
    }

    public int readBigSmart2() {
        if (this.pos < 0) {
            return this.readInt() & Integer.MAX_VALUE;
        }
        int value = this.readUnsignedShort();
        return value == Short.MAX_VALUE ? -1 : value;
    }

    public int readSmart() {
        int value = this.payload[this.pos] & 0xFF;
        if (value < 128) {
            return this.readUnsignedByte() - 64;
        }
        return this.readUnsignedShort() - 49152;
    }

    public Buffer(byte[] payload) {
        this.payload = payload;
        this.pos = 0;
    }

    public int readMedium() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8);
    }

    public static Buffer create(int size, IsaacCipher cipher) {
        Buffer stream_1 = new Buffer(new byte[size]);
        stream_1.payload = new byte[size];
        stream_1.cipher = cipher;
        return stream_1;
    }

    public byte readByte() {
        return this.payload[++this.pos - 1];
    }

    public int getUIncrementalSmart() {
        int value = 0;
        int remainder = this.readUSmart();
        while (remainder == Short.MAX_VALUE) {
            value += Short.MAX_VALUE;
            remainder = this.readUSmart();
        }
        return value += remainder;
    }

    public final int readUTriByte() {
        this.pos += 3;
        return (0xFF & this.payload[this.pos - 3] << 16) + (0xFF & this.payload[this.pos - 2] << 8) + (0xFF & this.payload[this.pos - 1]);
    }

    public final int readUTriByte(int i) {
        this.pos += 3;
        return (0xFF & this.payload[this.pos - 3] << 16) + (0xFF & this.payload[this.pos - 2] << 8) + (0xFF & this.payload[this.pos - 1]);
    }

    public int readUnsignedShortSmartMinusOne() {
        int peek = this.bitPosition & 0xFF;
        return peek < 128 ? this.readUnsignedByte() - 1 : this.readUnsignedShort() - 32769;
    }

    public int readUSmart2() {
        int baseVal = 0;
        int lastVal = 0;
        while ((lastVal = this.readUSmart()) == Short.MAX_VALUE) {
            baseVal += Short.MAX_VALUE;
        }
        return baseVal + lastVal;
    }

    public String readNewString() {
        int i = this.pos;
        while (this.payload[this.pos++] != 0) {
        }
        return new String(this.payload, i, this.pos - i - 1);
    }

    public void writeOpcode(int i) {
        this.payload[this.pos++] = (byte)(i + this.cipher.value());
    }

    public void writeByte(int value) {
        this.payload[this.pos++] = (byte)value;
    }

    public String readStrings() {
        int i = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        return new String(this.payload, i, this.pos - i - 1);
    }

    public int writeWordBigEndian(int value) {
        this.payload[this.pos++] = (byte)value;
        return (byte)value;
    }

    public void writeShort(int value) {
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeTriByte(int value) {
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeInt(int value) {
        this.payload[this.pos++] = (byte)(value >> 24);
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)value;
    }

    public void writeLEInt(int value) {
        this.payload[this.pos++] = (byte)value;
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)(value >> 16);
        this.payload[this.pos++] = (byte)(value >> 24);
    }

    public void writeLong(long value) {
        try {
            this.payload[this.pos++] = (byte)(value >> 56);
            this.payload[this.pos++] = (byte)(value >> 48);
            this.payload[this.pos++] = (byte)(value >> 40);
            this.payload[this.pos++] = (byte)(value >> 32);
            this.payload[this.pos++] = (byte)(value >> 24);
            this.payload[this.pos++] = (byte)(value >> 16);
            this.payload[this.pos++] = (byte)(value >> 8);
            this.payload[this.pos++] = (byte)value;
        }
        catch (RuntimeException runtimeexception) {
            System.out.println("14395, 5, " + value + ", " + runtimeexception.toString());
            throw new RuntimeException();
        }
    }

    public void writeString(String text) {
        System.arraycopy(text.getBytes(), 0, this.payload, this.pos, text.length());
        this.pos += text.length();
        this.payload[this.pos++] = 10;
    }

    public void writeBytes(byte[] data2, int offset, int length) {
        for (int index = length; index < length + offset; ++index) {
            this.payload[this.pos++] = data2[index];
        }
    }

    public void writeBytes(byte[] data2) {
        for (byte b : data2) {
            this.writeByte(b);
        }
    }

    public void writeByteAtPosition(int value) {
        this.payload[this.pos - value - 1] = (byte)value;
    }

    public int method440() {
        this.pos += 4;
        return ((this.payload[this.pos - 3] & 0xFF) << 24) + ((this.payload[this.pos - 4] & 0xFF) << 16) + ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public int readShort2() {
        this.pos += 2;
        int i = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (i > Short.MAX_VALUE) {
            i -= 65537;
        }
        return i;
    }

    public byte readSignedByte() {
        return this.payload[this.pos++];
    }

    public int readUnsignedShort() {
        this.pos += 2;
        return ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readUnsignedShort2() {
        this.pos += 2;
        return (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8);
    }

    public int readSignedShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
        if (value > 60000) {
            value = -65535 + value;
        }
        return value;
    }

    public int readTriByte() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 4] & 0xFF) << 24) + ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readInt2() {
        this.pos += 4;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8) + ((this.payload[this.pos - 4] & 0xFF) << 24);
    }

    public int read24Int() {
        this.pos += 3;
        return ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public long readLong() {
        long msi = (long)this.readInt() & 0xFFFFFFFFL;
        long lsi = (long)this.readInt() & 0xFFFFFFFFL;
        return (msi << 32) + lsi;
    }

    public String readStringCp1252NullTerminated() {
        int var1 = this.pos;
        while (this.payload[++this.pos - 1] != 0) {
        }
        int var2 = this.pos - var1 - 1;
        return var2 == 0 ? "" : this.decodeStringCp1252(this.payload, var1, var2);
    }

    public static int method8302(int var0) {
        --var0;
        var0 |= var0 >>> 1;
        var0 |= var0 >>> 2;
        var0 |= var0 >>> 4;
        var0 |= var0 >>> 8;
        var0 |= var0 >>> 16;
        return var0 + 1;
    }

    public String decodeStringCp1252(byte[] var0, int var1, int var2) {
        char[] var3 = new char[var2];
        int var4 = 0;
        for (int var5 = 0; var5 < var2; ++var5) {
            int var6 = var0[var5 + var1] & 0xFF;
            if (var6 == 0) continue;
            if (var6 >= 128 && var6 < 160) {
                int var7 = cp1252AsciiExtension[var6 - 128];
                if (var7 == 0) {
                    var7 = 63;
                }
                var6 = var7;
            }
            var3[var4++] = (char)var6;
        }
        return new String(var3, 0, var4);
    }

    public String readString() {
        int index = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        return new String(this.payload, index, this.pos - index - 1);
    }

    public byte[] readBytes() {
        int index = this.pos;
        while (this.payload[this.pos++] != 10) {
        }
        byte[] data2 = new byte[this.pos - index - 1];
        System.arraycopy(this.payload, index, data2, index - index, this.pos - 1 - index);
        return data2;
    }

    public byte[] readBytes(int length) {
        byte[] bytes = new byte[length];
        System.arraycopy(this.payload, this.pos, bytes, 0, length);
        this.pos += length;
        return bytes;
    }

    public void readBytes(int offset, int length, byte[] data2) {
        for (int index = length; index < length + offset; ++index) {
            data2[index] = this.payload[this.pos++];
        }
    }

    public void initBitAccess() {
        this.bitPosition = this.pos * 8;
    }

    public int readBits(int amount) {
        int byteOffset = this.bitPosition >> 3;
        int bitOffset = 8 - (this.bitPosition & 7);
        int value = 0;
        this.bitPosition += amount;
        while (amount > bitOffset) {
            value += (this.payload[byteOffset++] & BIT_MASKS[bitOffset]) << amount - bitOffset;
            amount -= bitOffset;
            bitOffset = 8;
        }
        value = amount == bitOffset ? (value += this.payload[byteOffset] & BIT_MASKS[bitOffset]) : (value += this.payload[byteOffset] >> bitOffset - amount & BIT_MASKS[amount]);
        return value;
    }

    public void disableBitAccess() {
        this.pos = (this.bitPosition + 7) / 8;
    }

    public int readSignedSmart() {
        int value = this.payload[this.pos] & 0xFF;
        if (value < 128) {
            return this.readUnsignedByte() - 64;
        }
        return this.readUnsignedShort() - 49152;
    }

    public void setOffset(int offset) {
        this.pos = offset;
    }

    public int getSmart() {
        try {
            if (this.pos >= this.payload.length) {
                return this.payload[this.payload.length - 1] & 0xFF;
            }
            int value = this.payload[this.pos] & 0xFF;
            if (value < 128) {
                return this.readUnsignedByte();
            }
            return this.readUnsignedShort() - 32768;
        }
        catch (Exception e) {
            e.printStackTrace();
            Client.addReportToServer(e.getMessage());
            return this.readUnsignedShort() - 32768;
        }
    }

    public int readUSmart() {
        int peek = this.payload[this.pos] & 0xFF;
        return peek < 128 ? this.readUnsignedByte() : this.readUnsignedShort() - 32768;
    }

    public void encodeRSA(BigInteger exponent, BigInteger modulus) {
        int length = this.pos;
        this.pos = 0;
        byte[] buffer = new byte[length];
        this.readBytes(length, 0, buffer);
        byte[] rsa = buffer;
        rsa = new BigInteger(buffer).modPow(exponent, modulus).toByteArray();
        this.pos = 0;
        this.writeByte(rsa.length);
        this.writeBytes(rsa, rsa.length, 0);
    }

    public void writeNegatedByte(int value) {
        this.payload[this.pos++] = (byte)(-value);
    }

    public void writeByteS(int value) {
        this.payload[this.pos++] = (byte)(128 - value);
    }

    public int readUByteA() {
        return this.payload[this.pos++] - 128 & 0xFF;
    }

    public int readNegUByte() {
        return -this.payload[this.pos++] & 0xFF;
    }

    public int readUnsignedByte() {
        return this.payload[this.pos++] & 0xFF;
    }

    public int readNullableLargeSmart() {
        if (this.payload[this.pos] < 0) {
            return this.readInt() & Integer.MAX_VALUE;
        }
        int var1 = this.readUShort();
        return var1 == Short.MAX_VALUE ? -1 : var1;
    }

    public int readShortSmartSub() {
        int var1 = this.payload[this.pos] & 0xFF;
        return var1 < 128 ? this.readUnsignedByte() - 1 : this.readUShort() - 32768 - 1;
    }

    public int readUShort() {
        this.pos += 2;
        return ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readUnsignedShort3() {
        this.pos += 2;
        return (this.payload[this.pos - 1] & 0xFF) + ((this.payload[this.pos - 2] & 0xFF) << 8);
    }

    public int readUByteS() {
        return 128 - this.payload[this.pos++] & 0xFF;
    }

    public byte readNegByte() {
        return -this.payload[this.pos++];
    }

    public byte readByteS() {
        return (byte)(128 - this.payload[this.pos++]);
    }

    public void writeLEShort(int value) {
        this.payload[this.pos++] = (byte)value;
        this.payload[this.pos++] = (byte)(value >> 8);
    }

    public void writeShortA(int value) {
        this.payload[this.pos++] = (byte)(value >> 8);
        this.payload[this.pos++] = (byte)(value + 128);
    }

    public void writeLEShortA(int value) {
        this.payload[this.pos++] = (byte)(value + 128);
        this.payload[this.pos++] = (byte)(value >> 8);
    }

    public int readLEUShort() {
        this.pos += 2;
        return ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public int readUShortA() {
        this.pos += 2;
        return ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] - 128 & 0xFF);
    }

    public int readLEUShortA() {
        this.pos += 2;
        return ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] - 128 & 0xFF);
    }

    public int readLEShort() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readLEShortA() {
        this.pos += 2;
        int value = ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] - 128 & 0xFF);
        if (value > Short.MAX_VALUE) {
            value -= 65536;
        }
        return value;
    }

    public int readIntLittleEndian() {
        this.pos += 4;
        return ((this.payload[this.pos - 4] & 0xFF) << 24) + ((this.payload[this.pos - 3] & 0xFF) << 16) + ((this.payload[this.pos - 2] & 0xFF) << 8) + (this.payload[this.pos - 1] & 0xFF);
    }

    public int readMEInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 2] & 0xFF) << 24) + ((this.payload[this.pos - 1] & 0xFF) << 16) + ((this.payload[this.pos - 4] & 0xFF) << 8) + (this.payload[this.pos - 3] & 0xFF);
    }

    public int readIMEInt() {
        this.pos += 4;
        return ((this.payload[this.pos - 3] & 0xFF) << 24) + ((this.payload[this.pos - 4] & 0xFF) << 16) + ((this.payload[this.pos - 1] & 0xFF) << 8) + (this.payload[this.pos - 2] & 0xFF);
    }

    public void writeReverseDataA(byte[] data2, int length, int offset) {
        for (int index = length + offset - 1; index >= length; --index) {
            this.payload[this.pos++] = (byte)(data2[index] + 128);
        }
    }

    public void readReverseData(byte[] data2, int offset, int length) {
        for (int index = length + offset - 1; index >= length; --index) {
            data2[index] = this.payload[this.pos++];
        }
    }

    public void getBytes(int len, int off, byte[] dest) {
        for (int i = off; i < off + len; ++i) {
            dest[i] = this.payload[this.pos++];
        }
    }

    public void resetPosition() {
        this.pos = 0;
    }

    public void encryptRSAContent() {
        int cachedPosition = this.pos;
        this.pos = 0;
        byte[] decodeBuffer = new byte[cachedPosition];
        this.getBytes(cachedPosition, 0, decodeBuffer);
        BigInteger decodedBigInteger = new BigInteger(decodeBuffer);
        BigInteger encodedBigInteger = decodedBigInteger.modPow(RSA_EXPONENT, RSA_MODULUS);
        byte[] encodedBuffer = encodedBigInteger.toByteArray();
        this.pos = 0;
        this.writeByte(encodedBuffer.length);
        this.writeBytes(encodedBuffer, encodedBuffer.length, 0);
    }

    public int readUnsignedIntSmartShortCompat() {
        int var1 = 0;
        int var2 = this.readUSmart();
        while (var2 == Short.MAX_VALUE) {
            var1 += Short.MAX_VALUE;
            var2 = this.readUSmart();
        }
        return var1 += var2;
    }
}

