/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.model.content;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;

public final class Announcement {
    private final String text;
    private final String link;
    private final Client instance = Client.instance;
    private int lastX = 0;
    private int lastY = 0;

    public Announcement(String text) {
        this(text, " ");
    }

    public Announcement(String text, String link) {
        this.text = text;
        this.link = link;
    }

    public String getText() {
        return this.text;
    }

    public String getLink() {
        return this.link;
    }

    public boolean hasUrl() {
        return !this.link.equals(" ");
    }

    public void isHovered(int mouseX, int mouseY) {
        boolean hovered;
        int x = this.text.length() * 6;
        boolean bl = hovered = mouseX >= this.lastX && mouseX <= this.lastX + x && mouseY >= this.lastY - 10 && mouseY <= this.lastY + 10;
        if (hovered && this.instance.isDisplayed) {
            this.actions();
        }
    }

    public void actions() {
        if (this.hasUrl()) {
            this.instance.menuActionText[2] = "Open Link";
            this.instance.menuActionText[1] = "Hide";
            this.instance.menuActionTypes[1] = 5001;
            this.instance.menuActionTypes[2] = 5000;
            this.instance.menuActionRow = 3;
        } else {
            this.instance.menuActionText[1] = "Hide";
            this.instance.menuActionTypes[1] = 5001;
            this.instance.menuActionRow = 2;
        }
    }

    public void dismiss() {
        this.instance.isDisplayed = false;
    }

    public void process() {
        SimpleImage sprite;
        int offsetX = 0;
        if (this.hasUrl() && (sprite = Client.spriteCache.get(856)) != null) {
            offsetX = sprite.width + 1;
            sprite.drawAdvancedSprite(5, this.lastY - 11);
        }
        boolean fixed = !Client.instance.isResized();
        this.lastX = 5 + offsetX;
        this.lastY = fixed ? 328 : Client.canvasHeight - 170;
        Client.adv_font_regular.draw(Client.capitalizeFirstChar(this.text), this.lastX, this.lastY, 0xFFFF00, -1);
    }
}

