/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.model.content;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.cache.graphics.font.AdvancedFont;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.TreeSet;

public class ExpCounter {
    private static final int START_SPRITE = 82;
    private static final int START = 130;
    private static final int STOP = 35;
    private static final int MIDLINE = 82;
    private static int xpCounter;
    private static final ArrayList<ExpGain> GAINS;
    private static ExpGain currentGain;

    public static void addXP(int skill, int xp, boolean increment) {
        if (skill == 99) {
            xpCounter = xp;
        } else {
            if (increment) {
                xpCounter += xp;
            }
            if (xp != 0) {
                if (currentGain != null && Math.abs(currentGain.getY() - 130.0f) <= (float)ExpCounter.getSize((int)Client.instance.setting.counter_size).base_char_height) {
                    ExpCounter.currentGain.xp += xp;
                    currentGain.addSprite(skill);
                } else {
                    ExpGain gain = new ExpGain(skill, xp);
                    GAINS.add(gain);
                    currentGain = gain;
                }
            }
        }
    }

    public static void drawExperienceCounter() {
        int x = Client.canvasWidth - 80 - 255;
        int y = 12;
        if (!GAINS.isEmpty()) {
            Iterator<ExpGain> gained = GAINS.iterator();
            while (gained.hasNext()) {
                ExpGain gain = gained.next();
                if (gain.getY() > 35.0f) {
                    if (gain.getY() >= 82.0f) {
                        gain.increaseAlpha();
                    } else {
                        gain.decreaseAlpha();
                    }
                    gain.changeY();
                } else if (gain.getY() <= 35.0f) {
                    gained.remove();
                }
                if (!(gain.getY() > 35.0f)) continue;
                PriorityQueue<ExpSprite> temp = new PriorityQueue<ExpSprite>(gain.sprites);
                int dx = 0;
                while (!temp.isEmpty()) {
                    ExpSprite expSprite = (ExpSprite)temp.poll();
                    expSprite.sprite.drawSprite1(x + dx, (int)((float)y + gain.getY()), gain.getAlpha());
                    dx += expSprite.sprite.width + 1;
                }
                String drop = String.format("<trans=%s>%,d", gain.getAlpha(), gain.getXP());
                ExpCounter.getSize(Client.instance.setting.counter_size).draw(drop, x + dx + 2, (int)(gain.getY() + (float)y) + 14, Client.instance.setting.counter_color, 0);
            }
        }
    }

    private static AdvancedFont getSize(int size) {
        if (size == 0) {
            return Client.adv_font_small;
        }
        if (size == 2) {
            return Client.adv_font_bold;
        }
        return Client.adv_font_regular;
    }

    static {
        GAINS = new ArrayList();
        currentGain = null;
    }

    static class ExpGain {
        private int skill;
        private int xp;
        private float y;
        private double alpha = 0.0;
        private Set<ExpSprite> sprites = new TreeSet<ExpSprite>();

        ExpGain(int skill, int xp) {
            this.skill = skill;
            this.xp = xp;
            this.y = 130.0f;
            this.addSprite(skill);
        }

        void addSprite(int skill) {
            for (ExpSprite sprite : this.sprites) {
                if (sprite.skill != skill) continue;
                return;
            }
            this.sprites.add(new ExpSprite(skill, Client.spriteCache.get(82 + skill)));
        }

        void changeY() {
            this.y -= Client.instance.setting.counter_speed;
        }

        int getXP() {
            return this.xp;
        }

        public float getY() {
            return this.y;
        }

        public int getAlpha() {
            return (int)this.alpha;
        }

        void increaseAlpha() {
            this.alpha += this.alpha < 256.0 ? 30.0 : 0.0;
            this.alpha = this.alpha > 256.0 ? 256.0 : this.alpha;
        }

        void decreaseAlpha() {
            this.alpha -= (double)(this.alpha > 0.0 ? 30 : 0) * 0.1;
            this.alpha = this.alpha > 256.0 ? 256.0 : this.alpha;
        }
    }

    static class ExpSprite
    implements Comparable<ExpSprite> {
        private int skill;
        private SimpleImage sprite;

        ExpSprite(int skill, SimpleImage sprite) {
            this.skill = skill;
            this.sprite = sprite;
        }

        @Override
        public int compareTo(ExpSprite other) {
            return Integer.signum(other.skill - this.skill);
        }
    }
}

