/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.model.content;

import com.hazy.Client;
import com.hazy.draw.Rasterizer2D;
import java.util.HashMap;
import java.util.Map;

public class StatusBars {
    public Restore restore = Restore.NONE;

    public void drawStatusBars(int xOffset, int yOffset) {
        if (!Client.instance.setting.status_bars) {
            return;
        }
        int hpColor = 0;
        int prayerColor = BarType.PRAYER.getNormal();
        if (Client.instance.poisonType == 0) {
            hpColor = BarType.HP.getNormal();
        } else if (Client.instance.poisonType == 1) {
            hpColor = BarType.HP.getPoisoned();
        } else if (Client.instance.poisonType == 2) {
            hpColor = BarType.HP.getVenom();
        }
        this.renderStatusBars(xOffset, yOffset, BarType.HP, hpColor);
        this.renderStatusBars(xOffset, yOffset, BarType.PRAYER, prayerColor);
    }

    public void renderStatusBars(int xOffset, int yOffset, BarType type2, int backgroundColor) {
        int hitpoints = Client.instance.currentLevels[3];
        int prayer = Client.instance.currentLevels[5];
        int percent = StatusBars.getPercent(this.getPercent(type2, 0), 250);
        Rasterizer2D.draw_rectangle_outline(xOffset + 11 + this.getBarOffsetX(type2), 42 + yOffset, 20, 250, 0);
        Rasterizer2D.drawTransparentBox(xOffset + 11 + this.getBarOffsetX(type2), 42 + yOffset, 20, 250, 0, 130);
        Rasterizer2D.drawTransparentBox(xOffset + 12 + this.getBarOffsetX(type2), 242 - percent + 50 + yOffset, 18, percent, backgroundColor, 135);
        if (this.restore.type == type2 && this.restore != Restore.NONE) {
            Rasterizer2D.drawTransparentBox(xOffset + 12 + this.getBarOffsetX(type2), 242 - StatusBars.getPercent(this.getPercent(type2, this.restore.restore), 250) + 50 + yOffset, 18, StatusBars.getPercent(this.getPercent(type2, this.restore.restore), 250), type2.getHeal(), 140);
        }
        if (this.getPercent(type2, 0) < 20) {
            if (Client.tick % 20 < 10) {
                if (type2.icon == 9) {
                    Client.spriteCache.get(type2.getIcon()).drawSprite(xOffset + 13 + this.getBarOffsetX(type2), 50 + yOffset);
                } else if (type2.icon == 10) {
                    Client.spriteCache.get(type2.getIcon()).drawSprite(xOffset + 12 + this.getBarOffsetX(type2), 50 + yOffset);
                }
            }
        } else if (type2.icon == 9) {
            Client.spriteCache.get(type2.getIcon()).drawSprite(xOffset + 13 + this.getBarOffsetX(type2), 50 + yOffset);
        } else if (type2.icon == 10) {
            Client.spriteCache.get(type2.getIcon()).drawSprite(xOffset + 12 + this.getBarOffsetX(type2), 50 + yOffset);
        }
        Client.adv_font_small.draw_centered(type2 == BarType.HP ? "" + hitpoints : "" + prayer, xOffset + 21 + this.getBarOffsetX(type2), 80 + yOffset, 0xFFFFFF, 1);
    }

    public int getBarOffsetX(BarType type2) {
        if (type2 == BarType.HP) {
            return Client.instance.isResized() ? -5 : 0;
        }
        if (type2 == BarType.PRAYER) {
            return Client.instance.isResized() ? 204 : 210;
        }
        return 0;
    }

    public static int getPercent(int current, int pixels) {
        return (int)((double)pixels * 0.01 * (double)current);
    }

    public int getPercent(BarType type2, int extra) {
        if (type2 == BarType.HP) {
            int level = Client.instance.currentLevels[3] + extra;
            int max = Client.instance.maximumLevels[3];
            double percent = (double)level / (double)max;
            return level > 99 ? 100 : (int)(percent * 100.0);
        }
        if (type2 == BarType.PRAYER) {
            int level = Client.instance.currentLevels[5] + extra;
            int max = Client.instance.maximumLevels[5];
            double percent = (double)level / (double)max;
            return level > 99 ? 100 : (int)(percent * 100.0);
        }
        return 0;
    }

    public void setConsume(Restore restore) {
        this.restore = restore;
    }

    public static enum BarType {
        HP(8332046, 16740358, 37120, 16640, 9),
        PRAYER(2987153, 3764410, 10);

        private final int normal;
        private final int heal;
        private int poisoned;
        private int venom;
        private final int icon;

        public int getNormal() {
            return this.normal;
        }

        public int getHeal() {
            return this.heal;
        }

        public int getPoisoned() {
            return this.poisoned;
        }

        public int getVenom() {
            return this.venom;
        }

        public int getIcon() {
            return this.icon;
        }

        private BarType(int normal, int heal, int icon) {
            this.normal = normal;
            this.heal = heal;
            this.icon = icon;
        }

        private BarType(int normal, int heal, int poisoned, int venom, int icon) {
            this.normal = normal;
            this.heal = heal;
            this.poisoned = poisoned;
            this.venom = venom;
            this.icon = icon;
        }
    }

    public static enum Restore {
        NONE(0, 0, BarType.PRAYER),
        PRAYER_3(139, 40, BarType.PRAYER);

        private final int item;
        private final int restore;
        private final BarType type;
        private static final Map<Integer, Restore> restoreMap;

        public int getItem() {
            return this.item;
        }

        public int getRestore() {
            return this.restore;
        }

        public BarType getType() {
            return this.type;
        }

        private Restore(int item, int restore, BarType type2) {
            this.item = item;
            this.restore = restore;
            this.type = type2;
        }

        public static Restore get(int item) {
            return restoreMap.getOrDefault(item, NONE);
        }

        static {
            restoreMap = new HashMap<Integer, Restore>();
            for (Restore restore : Restore.values()) {
                restoreMap.put(restore.item, restore);
            }
        }
    }
}

