/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.model.content.account;

import com.hazy.Client;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.io.Buffer;
import com.hazy.model.content.account.Account;
import com.hazy.sign.SignLink;
import com.hazy.util.FileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;

public class AccountManager {
    private static final int MAXIMUM_ACCOUNTS = 3;
    private static final Path ACCOUNTS_FILE = Paths.get(SignLink.findDataDir(), "accounts.dat");
    private final Collection<Account> accountList = new ArrayList<Account>(3);
    private final SimpleImage backgroundSprite;
    private final Client client;

    public AccountManager(Client client, SimpleImage backgroundSprite) {
        this.client = client;
        this.backgroundSprite = backgroundSprite;
    }

    public void addAccount(String userName, String userPassword) throws IOException {
        if (this.accountList.size() == 3) {
            this.client.firstLoginMessage = "Account list full!";
            this.client.secondLoginMessage = "Delete an account to create space for a new one.";
            return;
        }
        if (userName.length() == 0 || userPassword.length() == 0) {
            this.client.firstLoginMessage = "Username & Password";
            this.client.secondLoginMessage = "Must be more than 1 character";
            return;
        }
        Account accountToAdd = new Account(userName, userPassword);
        for (Account account : this.accountList) {
            if (!accountToAdd.getUserName().equals(account.getUserName())) continue;
            this.client.firstLoginMessage = "There is already an account";
            this.client.secondLoginMessage = "saved with that username.";
            return;
        }
        this.accountList.add(accountToAdd);
        this.saveAccounts();
    }

    public void processAccountDrawing() {
        int xPosition = Client.canvasWidth / 2;
        int yPosition = Client.canvasHeight / 2 + 165;
        xPosition -= -3 + this.accountList.size() * (Client.spriteCache.get((int)1915).width / 2 + (this.accountList.size() > 1 ? 10 : 0));
        for (Account account : this.accountList) {
            if (this.accountList.size() > 1) {
                xPosition += 10;
            }
            account.setXPosition(xPosition);
            account.setYPosition(yPosition);
            this.draw(account);
            xPosition += Client.spriteCache.get((int)1915).width + 10;
        }
    }

    public void processAccountInput() throws IOException {
        ArrayList<Account> accountsToRemove = new ArrayList<Account>();
        for (Account account : this.accountList) {
            if (this.client.newclickInRegion(account.getXPosition(), account.getYPosition(), Client.spriteCache.get(1916))) {
                this.client.myUsername = account.getUserName();
                this.client.myPassword = account.getUserPassword();
                if (this.client.loginTimer.finished()) {
                    this.client.login(this.client.myUsername, this.client.myPassword, false);
                    this.client.loginTimer.start(2);
                }
            }
            if (!this.client.newclickInRegion(account.getXPosition() + 74 - 54, account.getYPosition() + 23, Client.spriteCache.get(1918))) continue;
            accountsToRemove.add(account);
            this.client.firstLoginMessage = "Deleted Account:";
            this.client.secondLoginMessage = account.getUserName();
        }
        if (!accountsToRemove.isEmpty()) {
            this.accountList.removeAll(accountsToRemove);
            this.saveAccounts();
        }
    }

    private void draw(Account account) {
        Client.spriteCache.get(1915).drawHoverSprite(account.getXPosition(), account.getYPosition(), Client.spriteCache.get(1916));
        Client.spriteCache.get(1917).drawHoverSprite(account.getXPosition() + 74 - 54, account.getYPosition() + 23, Client.spriteCache.get(1918));
        Client.adv_font_regular.draw_centered(account.getUserName(), account.getXPosition() + Client.spriteCache.get((int)1915).width / 2, account.getYPosition() + 16, 0xFFFFFF, 0);
    }

    public void saveAccounts() throws IOException {
        if (this.accountList.isEmpty()) {
            Files.deleteIfExists(ACCOUNTS_FILE);
            return;
        }
        Files.deleteIfExists(ACCOUNTS_FILE);
        Files.createFile(ACCOUNTS_FILE, new FileAttribute[0]);
        Buffer buffer = Buffer.create(30000, null);
        buffer.writeByte(this.accountList.size());
        for (Account account : this.accountList) {
            buffer.writeString(account.getUserName());
            buffer.writeString(account.getUserPassword());
        }
        FileUtils.writeFile(ACCOUNTS_FILE.toString(), Arrays.copyOf(buffer.payload, buffer.pos));
    }

    public void loadAccounts() throws IOException {
        File file = ACCOUNTS_FILE.toFile();
        if (!file.exists()) {
            return;
        }
        byte[] fileData = FileUtils.read(file);
        Buffer buffer = new Buffer(fileData);
        try {
            int size = buffer.readUnsignedByte();
            for (int index = 0; index < size; ++index) {
                String userName = buffer.readString();
                String userPassword = buffer.readString();
                this.accountList.add(new Account(userName, userPassword));
            }
        }
        catch (Exception e) {
            file.delete();
            e.printStackTrace();
        }
    }
}

