/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.model.settings;

import com.hazy.Client;
import com.hazy.model.content.Keybinding;
import com.hazy.model.settings.SettingData;
import com.hazy.sign.SignLink;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;

public class Settings {
    public boolean status_bars = true;
    public boolean draw_fps = false;
    public boolean draw_special_orb = true;
    public boolean draw_orb_arc = true;
    public static boolean toggle_music = true;
    public boolean draw_health_overlay = true;
    public boolean draw_timers = true;
    public boolean toggle_overhead_names = false;
    public boolean toggle_overhead_hp = false;
    public boolean toggle_npc_overhead_names = false;
    public boolean toggle_npc_overhead_hp = false;
    public boolean toggle_item_pile_names = true;
    public boolean filter_item_pile_names = false;
    public boolean moving_prayers = false;
    public boolean ground_snow = false;
    public boolean shift_pet_options = false;
    public int drag_item_value = 10;
    public boolean incinerator = false;
    public boolean hide_equipment_button = false;
    public boolean hide_inventory_button = false;
    public int player_attack_priority = 0;
    public int npc_attack_priority = 2;
    public boolean show_hit_predictor = false;
    public boolean show_exp_counter = true;
    public int counter_size = 1;
    public int counter_color = 0xFFFFFF;
    public float counter_speed = 1.0f;
    public int counter_position;
    public boolean counter_group = true;
    public int sound_state = 4;
    public boolean showHitPredictor = false;
    public boolean hidePrivateChat = false;
    public boolean loginLogoutNotification = false;
    public boolean profanityFilter = false;
    public boolean cameraMovement = true;
    public boolean shiftClick = true;
    public boolean esc_close = true;
    public boolean mouseButtons = false;
    public boolean acceptAid = false;
    public int brightness = 3;
    public boolean zoomToggle = false;
    public boolean chatEffects = true;
    public boolean privateChat = false;
    public boolean transparentSidePanel = false;
    public boolean transparentChatbox = false;
    public boolean sideStonesArrangement = false;
    public boolean roofs = true;
    public boolean orbs = true;
    private String fileLine = "";
    public String location;
    public static final int SOUND_BUTTON_OFF = 43538;
    public static final int SOUND_BUTTON_STATE_ONE = 43539;
    public static final int SOUND_BUTTON_STATE_TWO = 43540;
    public static final int SOUND_BUTTON_STATE_THREE = 43541;
    public static final int SOUND_BUTTON_STATE_FOUR = 43542;
    public static final int WELCOME_SCREEN_PLAY_BUTTON = 44420;
    public static final int ADVANCED_OPTIONS_BUTTON = 42524;
    public static final int ESCAPE_CONFIG_BUTTON = 53003;
    public static final int BRIGHTNESS_STATE_ONE = 906;
    public static final int BRIGHTNESS_STATE_TWO = 908;
    public static final int BRIGHTNESS_STATE_THREE = 910;
    public static final int BRIGHTNESS_STATE_FOUR = 912;
    public static final int ZOOM_TOGGLE_BUTTON = 44151;
    public static final int RESTORE_ZOOM_BUTTON = 42521;
    public static final int FIXED_MODE_BUTTON = 42522;
    public static final int RESIZABLE_MODE_BUTTON = 42523;
    public static final int ACCEPT_AID_BUTTON = 42506;
    public static final int HOUSE_OPTIONS_BUTTON = 42508;
    public static final int BOND_POUCH_BUTTON = 42509;
    public static final int CHAT_EFFECTS_BUTTON = 42541;
    public static final int SPLIT_PRIVATE_CHAT_BUTTON = 42542;
    public static final int HIDE_PRIVATE_CHAT_BUTTON = 42543;
    public static final int MOUSE_BUTTONS_BUTTON = 42551;
    public static final int FOLLOWER_OPTIONS_BUTTON = 42553;
    public static final int PROFANITY_FILTER_BUTTON = 41541;
    public static final int NOTIFICATIONS_BUTTON = 41542;
    public static final int LOGIN_LOGOUT_NOTIFICATION_TIMEOUT_BUTTON = 41543;
    public static final int DISPLAY_NAME_BUTTON = 42544;
    public static final int KEYBINDING_BUTTON = 42552;
    public static final int MOUSE_CAMERA_BUTTON = 41551;
    public static final int SHIFT_CLICK_DROP_BUTTON = 41552;
    public static final int TRANSPARENT_SIDE_PANEL = 43007;
    public static final int TRANSPARENT_CHATBOX = 43025;
    public static final int SIDE_STONES_ARRANGEMENT = 43032;
    public static final int ROOF_REMOVAL = 43019;
    public static final int ORBS = 43022;

    public void toggleVarbits() {
        Client.instance.toggleConfig(169, this.sound_state);
        Client.instance.toggleConfig(166, this.brightness);
        Client.instance.toggleConfig(289, this.profanityFilter ? 1 : 0);
        Client.instance.toggleConfig(207, this.cameraMovement ? 1 : 0);
        Client.instance.toggleConfig(290, this.loginLogoutNotification ? 1 : 0);
        Client.instance.toggleConfig(288, this.hidePrivateChat ? 1 : 0);
        Client.instance.toggleConfig(594, this.esc_close ? 1 : 0);
        Client.instance.toggleConfig(293, this.shiftClick ? 1 : 0);
        Client.instance.toggleConfig(427, this.acceptAid ? 1 : 0);
        Client.instance.toggleConfig(291, this.shift_pet_options ? 1 : 0);
        Client.instance.toggleConfig(170, this.mouseButtons ? 1 : 0);
        Client.instance.toggleConfig(294, this.zoomToggle ? 1 : 0);
        Client.instance.toggleConfig(171, this.chatEffects ? 1 : 0);
        Client.instance.toggleConfig(287, this.privateChat ? 1 : 0);
        Client.instance.toggleConfig(295, this.transparentSidePanel ? 1 : 0);
        Client.instance.toggleConfig(296, this.transparentChatbox ? 1 : 0);
        Client.instance.toggleConfig(297, this.sideStonesArrangement ? 1 : 0);
        Client.instance.toggleConfig(298, this.roofs ? 1 : 0);
        Client.instance.toggleConfig(299, this.orbs ? 1 : 0);
    }

    private void createSettingsFile(String location1) {
        File location = new File(location1);
        if (location.exists()) {
            return;
        }
        try {
            this.save();
            location.createNewFile();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean contains(String match) {
        String string2 = this.fileLine.substring(0, this.fileLine.indexOf(" = "));
        return string2.equals(match);
    }

    private boolean readBoolean() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return this.fileLine.equals("true");
    }

    private String readString() {
        this.fileLine = this.fileLine.substring(this.fileLine.indexOf("=") + 2);
        return this.fileLine;
    }

    private int readInt() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return Integer.parseInt(this.fileLine);
    }

    private int readFloat() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return (int)Float.parseFloat(this.fileLine);
    }

    private Double readDouble() {
        this.fileLine = this.fileLine.substring(this.fileLine.lastIndexOf("=") + 2);
        return Double.parseDouble(this.fileLine);
    }

    private void writeLine(String line, String line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(String line, Boolean line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(Double line1, BufferedWriter bw) {
        try {
            bw.write("counter_speed = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void writeLine(String line, int line1, BufferedWriter bw) {
        try {
            bw.write(line + " = " + line1);
            bw.newLine();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void save() {
        if (this.location == null) {
            return;
        }
        try {
            FileOutputStream writer = new FileOutputStream(this.location);
            writer.write("".getBytes());
            writer.close();
            BufferedWriter bw = new BufferedWriter(new FileWriter(this.location, true));
            this.writeLine("cameraSpeed", Client.cameraSpeed, bw);
            this.writeLine("zoom_distance", Client.cameraZoom, bw);
            this.writeLine("drag_item_value", this.drag_item_value, bw);
            this.writeLine("player_attack_priority", this.player_attack_priority, bw);
            this.writeLine("npc_attack_priority", this.npc_attack_priority, bw);
            this.writeLine("keybinds", Arrays.toString(Keybinding.KEYBINDINGS), bw);
            this.writeLine("show_exp_counter", this.show_exp_counter, bw);
            this.writeLine("counter_size", this.counter_size, bw);
            this.writeLine("counter_color", this.counter_color, bw);
            this.writeLine(Double.valueOf(this.counter_speed), bw);
            this.writeLine("counter_position", this.counter_position, bw);
            this.writeLine("counter_group", this.counter_group, bw);
            this.writeLine("sound_state", this.sound_state, bw);
            this.writeLine("toggle_music", toggle_music, bw);
            this.writeLine("show_hit_predictor", this.show_hit_predictor, bw);
            this.writeLine("hidePrivateChat", this.hidePrivateChat, bw);
            this.writeLine("loginLogoutNotification", this.loginLogoutNotification, bw);
            this.writeLine("profanityFilter", this.profanityFilter, bw);
            this.writeLine("cameraMovement", this.cameraMovement, bw);
            this.writeLine("shiftClick", this.shiftClick, bw);
            this.writeLine("ESC_Close", this.esc_close, bw);
            this.writeLine("mouseButtons", this.mouseButtons, bw);
            this.writeLine("acceptAid", this.acceptAid, bw);
            this.writeLine("brightness", this.brightness, bw);
            this.writeLine("zoomToggle", this.zoomToggle, bw);
            this.writeLine("chatEffects", this.chatEffects, bw);
            this.writeLine("privateChat", this.privateChat, bw);
            this.writeLine("transparentSidePanel", this.transparentSidePanel, bw);
            this.writeLine("transparentChatbox", this.transparentChatbox, bw);
            this.writeLine("sideStonesArrangement", this.sideStonesArrangement, bw);
            this.writeLine("roofs", this.roofs, bw);
            this.writeLine("orbs", this.orbs, bw);
            this.writeLine("draw_orb_arc", this.draw_orb_arc, bw);
            this.writeLine("draw_special_orb", this.draw_special_orb, bw);
            this.writeLine("draw_health_overlay", this.draw_health_overlay, bw);
            this.writeLine("draw_ground_item_overlay", this.toggle_item_pile_names, bw);
            this.writeLine("draw_timers", this.draw_timers, bw);
            this.writeLine("display_names", this.toggle_overhead_names, bw);
            this.writeLine("toggle_overhead_hp", this.toggle_overhead_hp, bw);
            this.writeLine("toggle_npc_overhead_names", this.toggle_npc_overhead_names, bw);
            this.writeLine("toggle_npc_overhead_hp", this.toggle_npc_overhead_hp, bw);
            this.writeLine("ground_snow", this.ground_snow, bw);
            this.writeLine("show_pet_options", this.shift_pet_options, bw);
            this.writeLine("toggle_music", toggle_music, bw);
            this.writeLine("draw_fps", this.draw_fps, bw);
            this.writeLine("moving_prayers", this.moving_prayers, bw);
            bw.flush();
            bw.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    public void load() {
        this.location = SignLink.findDataDir() + "/settings.txt";
        this.createSettingsFile(this.location);
        try {
            String line;
            BufferedReader file = new BufferedReader(new FileReader(this.location));
            while ((line = file.readLine()) != null) {
                this.fileLine = line;
                if (this.contains("cameraSpeed")) {
                    Client.cameraSpeed = this.readString();
                    continue;
                }
                if (this.contains("zoom_distance")) {
                    Client.cameraZoom = this.readInt();
                    continue;
                }
                if (this.contains("drag_item_value")) {
                    this.drag_item_value = this.readInt();
                    continue;
                }
                if (this.contains("player_attack_priority")) {
                    this.player_attack_priority = this.readInt();
                    continue;
                }
                if (this.contains("npc_attack_priority")) {
                    this.npc_attack_priority = this.readInt();
                    continue;
                }
                if (this.contains("keybinds")) {
                    String array = this.readString();
                    array = array.substring(1, array.length() - 1);
                    String[] entries = array.split(",");
                    for (int index = 0; index < Keybinding.KEYBINDINGS.length; ++index) {
                        Keybinding.KEYBINDINGS[index] = Integer.parseInt(entries[index].trim());
                    }
                    continue;
                }
                if (this.contains("show_exp_counter")) {
                    this.show_exp_counter = this.readBoolean();
                    continue;
                }
                if (this.contains("counter_size")) {
                    this.counter_size = this.readInt();
                    continue;
                }
                if (this.contains("counter_color")) {
                    this.counter_color = this.readInt();
                    continue;
                }
                if (this.contains("counter_speed")) {
                    this.counter_speed = this.readFloat();
                    continue;
                }
                if (this.contains("counter_position")) {
                    this.counter_position = this.readInt();
                    continue;
                }
                if (this.contains("counter_group")) {
                    this.counter_group = this.readBoolean();
                    continue;
                }
                if (this.contains("sound_state")) {
                    this.sound_state = this.readInt();
                    continue;
                }
                if (this.contains("toggle_music")) {
                    toggle_music = this.readBoolean();
                    continue;
                }
                if (this.contains("show_hit_predictor")) {
                    this.show_hit_predictor = this.readBoolean();
                    continue;
                }
                if (this.contains("hidePrivateChat")) {
                    this.hidePrivateChat = this.readBoolean();
                    continue;
                }
                if (this.contains("loginLogoutNotification")) {
                    this.loginLogoutNotification = this.readBoolean();
                    continue;
                }
                if (this.contains("profanityFilter")) {
                    this.profanityFilter = this.readBoolean();
                    continue;
                }
                if (this.contains("cameraMovement")) {
                    this.cameraMovement = this.readBoolean();
                    continue;
                }
                if (this.contains("shiftClick")) {
                    this.shiftClick = this.readBoolean();
                    continue;
                }
                if (this.contains("esc_close")) {
                    this.esc_close = this.readBoolean();
                    continue;
                }
                if (this.contains("mouseButtons")) {
                    this.mouseButtons = this.readBoolean();
                    continue;
                }
                if (this.contains("acceptAid")) {
                    this.acceptAid = this.readBoolean();
                    continue;
                }
                if (this.contains("brightness")) {
                    this.brightness = this.readInt();
                    continue;
                }
                if (this.contains("chatEffects")) {
                    this.chatEffects = this.readBoolean();
                    continue;
                }
                if (this.contains("privateChat")) {
                    this.privateChat = this.readBoolean();
                    continue;
                }
                if (this.contains("transparentSidePanel")) {
                    this.transparentSidePanel = this.readBoolean();
                    continue;
                }
                if (this.contains("transparentChatbox")) {
                    this.transparentChatbox = this.readBoolean();
                    continue;
                }
                if (this.contains("sideStonesArrangement")) {
                    this.sideStonesArrangement = this.readBoolean();
                    continue;
                }
                if (this.contains("roofs")) {
                    this.roofs = this.readBoolean();
                    continue;
                }
                if (this.contains("orbs")) {
                    this.orbs = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_orb_arc")) {
                    this.draw_orb_arc = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_orb_arc")) {
                    this.draw_orb_arc = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_special_orb")) {
                    this.draw_special_orb = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_health_overlay")) {
                    this.draw_health_overlay = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_ground_item_overlay")) {
                    this.toggle_item_pile_names = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_timers")) {
                    this.draw_timers = this.readBoolean();
                    continue;
                }
                if (this.contains("display_names")) {
                    this.toggle_overhead_names = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_overhead_hp")) {
                    this.toggle_overhead_hp = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_npc_overhead_names")) {
                    this.toggle_npc_overhead_names = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_npc_overhead_hp")) {
                    this.toggle_npc_overhead_hp = this.readBoolean();
                    continue;
                }
                if (this.contains("ground_snow")) {
                    this.ground_snow = this.readBoolean();
                    continue;
                }
                if (this.contains("show_pet_options")) {
                    this.shift_pet_options = this.readBoolean();
                    continue;
                }
                if (this.contains("toggle_music")) {
                    toggle_music = this.readBoolean();
                    continue;
                }
                if (this.contains("draw_fps")) {
                    this.draw_fps = this.readBoolean();
                    continue;
                }
                if (!this.contains("moving_prayers")) continue;
                this.moving_prayers = this.readBoolean();
            }
            file.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        int length = SettingData.values().length;
        for (int index = 0; index < length; ++index) {
            SettingData setting = SettingData.forOrdinal(index);
            if (setting == null) {
                return;
            }
            Client.instance.updateString(setting.setting, 50301 + index);
            Client.instance.toggleConfig(900 + index, setting.status() ? 1 : 0);
        }
        this.save();
    }

    public boolean click(Client client, int button) {
        int base_button = 50301;
        int index = button - base_button;
        SettingData settingData = SettingData.forOrdinal(index);
        if (index < SettingData.values().length && settingData != null) {
            settingData.handle(client);
            this.update();
            return true;
        }
        base_button = 50350;
        index = button - base_button;
        settingData = SettingData.forOrdinal(index);
        if (index < SettingData.values().length && settingData != null) {
            settingData.handle(client);
            this.update();
            return true;
        }
        return false;
    }

    public boolean settingButtons(int button) {
        switch (button) {
            case 53003: {
                this.esc_close = !this.esc_close;
                Client.instance.toggleConfig(594, this.esc_close ? 1 : 0);
                return true;
            }
            case 912: {
                Client.instance.toggleConfig(505, 0);
                Client.instance.toggleConfig(506, 0);
                Client.instance.toggleConfig(507, 0);
                Client.instance.toggleConfig(508, 1);
                Client.instance.toggleConfig(166, 4);
                this.brightness = 4;
                return true;
            }
            case 910: {
                Client.instance.toggleConfig(505, 0);
                Client.instance.toggleConfig(506, 0);
                Client.instance.toggleConfig(507, 1);
                Client.instance.toggleConfig(508, 0);
                Client.instance.toggleConfig(166, 3);
                this.brightness = 3;
                return true;
            }
            case 908: {
                Client.instance.toggleConfig(505, 0);
                Client.instance.toggleConfig(506, 1);
                Client.instance.toggleConfig(507, 0);
                Client.instance.toggleConfig(508, 0);
                Client.instance.toggleConfig(166, 2);
                this.brightness = 2;
                return true;
            }
            case 906: {
                Client.instance.toggleConfig(505, 1);
                Client.instance.toggleConfig(506, 0);
                Client.instance.toggleConfig(507, 0);
                Client.instance.toggleConfig(508, 0);
                Client.instance.toggleConfig(166, 1);
                this.brightness = 1;
                return true;
            }
            case 42553: {
                this.shift_pet_options = !this.shift_pet_options;
                Client.instance.toggleConfig(291, this.shift_pet_options ? 1 : 0);
                return true;
            }
            case 42551: {
                this.mouseButtons = !this.mouseButtons;
                Client.instance.toggleConfig(170, this.mouseButtons ? 1 : 0);
                return true;
            }
            case 42506: {
                this.acceptAid = !this.acceptAid;
                Client.instance.toggleConfig(427, this.acceptAid ? 1 : 0);
                return true;
            }
            case 42522: {
                Client.instance.frameMode(765, 503);
                return true;
            }
            case 42523: {
                Client.instance.frameMode(766, 559);
                return true;
            }
            case 42508: {
                return true;
            }
            case 42509: {
                return true;
            }
            case 42521: {
                return true;
            }
            case 44151: {
                this.zoomToggle = !this.zoomToggle;
                Client.instance.toggleConfig(294, this.zoomToggle ? 1 : 0);
                return true;
            }
            case 42541: {
                this.chatEffects = !this.chatEffects;
                Client.instance.toggleConfig(171, this.chatEffects ? 1 : 0);
                return true;
            }
            case 42542: {
                this.privateChat = !this.privateChat;
                Client.instance.toggleConfig(287, this.privateChat ? 1 : 0);
                return true;
            }
            case 42543: {
                this.hidePrivateChat = !this.hidePrivateChat;
                Client.instance.toggleConfig(288, this.hidePrivateChat ? 1 : 0);
                return true;
            }
            case 41541: {
                this.profanityFilter = !this.profanityFilter;
                Client.instance.toggleConfig(289, this.profanityFilter ? 1 : 0);
                return true;
            }
            case 41542: 
            case 42544: {
                return true;
            }
            case 41543: {
                this.loginLogoutNotification = !this.loginLogoutNotification;
                Client.instance.toggleConfig(290, this.loginLogoutNotification ? 1 : 0);
                return true;
            }
            case 41551: {
                this.cameraMovement = !this.cameraMovement;
                Client.instance.toggleConfig(207, this.cameraMovement ? 1 : 0);
                return true;
            }
            case 41552: {
                this.shiftClick = !this.shiftClick;
                Client.instance.toggleConfig(293, this.shiftClick ? 1 : 0);
                return true;
            }
            case 43022: {
                this.orbs = !this.orbs;
                Client.instance.toggleConfig(299, this.orbs ? 1 : 0);
                return true;
            }
            case 43007: {
                this.transparentSidePanel = !this.transparentSidePanel;
                Client.instance.toggleConfig(295, this.transparentSidePanel ? 1 : 0);
                break;
            }
            case 43025: {
                this.transparentChatbox = !this.transparentChatbox;
                Client.instance.toggleConfig(296, this.transparentChatbox ? 1 : 0);
                return true;
            }
            case 43032: {
                this.sideStonesArrangement = !this.sideStonesArrangement;
                Client.instance.toggleConfig(297, this.sideStonesArrangement ? 1 : 0);
                return true;
            }
            case 43019: {
                this.roofs = !this.roofs;
                Client.instance.toggleConfig(298, this.roofs ? 1 : 0);
                return true;
            }
            case 43039: {
                Client.tabInterfaceIDs[11] = 50290;
                Client.update_tab_producer = true;
                return true;
            }
            case 50293: {
                Client.tabInterfaceIDs[11] = 42500;
                Client.update_tab_producer = true;
                return true;
            }
            case 43538: {
                Client.instance.toggleConfig(169, 0);
                this.sound_state = 0;
                return true;
            }
            case 43539: {
                Client.instance.toggleConfig(169, 1);
                this.sound_state = 1;
                return true;
            }
            case 43540: {
                Client.instance.toggleConfig(169, 2);
                this.sound_state = 2;
                return true;
            }
            case 43541: {
                Client.instance.toggleConfig(169, 3);
                this.sound_state = 3;
                return true;
            }
            case 43542: {
                Client.instance.toggleConfig(169, 4);
                this.sound_state = 4;
                return true;
            }
        }
        return false;
    }
}

