/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.net.requester;

import com.hazy.Client;
import com.hazy.cache.Archive;
import com.hazy.collection.LinkedList;
import com.hazy.collection.Queue;
import com.hazy.io.Buffer;
import com.hazy.net.requester.Provider;
import com.hazy.net.requester.Resource;
import com.hazy.sign.SignLink;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.zip.CRC32;

public final class ResourceProvider
extends Provider {
    private int totalFiles;
    private final LinkedList requested;
    private int maximumPriority;
    public String loadingMessage = "";
    private int deadTime;
    private long lastRequestTime;
    private int[] landscapes;
    private final byte[] payload;
    public int tick;
    private final byte[][] fileStatus;
    private Client clientInstance;
    private final LinkedList extras;
    private int completedSize;
    private int remainingData;
    private int[] musicPriorities;
    public int errors;
    private int[] mapFiles;
    private int filesLoaded;
    private boolean running = true;
    private OutputStream outputStream;
    private int[] membersArea;
    private boolean expectingData = false;
    private final LinkedList complete;
    private final byte[] gzipInputBuffer;
    private int[] anIntArray1360;
    private final Queue requests;
    private InputStream inputStream;
    private Socket socket;
    private final int[][] versions;
    private int uncompletedCount;
    private int completedCount;
    private final LinkedList unrequested;
    private Resource current;
    private final LinkedList mandatoryRequests;
    private int[] areas;
    private byte[] modelIndices;
    private int idleTime;
    private final CRC32 crc32;
    public String currentDownload = "";
    public int[] file_amounts = new int[4];
    private final String[] crcNames = new String[]{"model_crc", "anim_crc", "midi_crc", "map_crc"};
    private final int[][] crcs = new int[this.crcNames.length][];
    private boolean debugCheapHaxValues = false;
    int[] cheapHaxValues = new int[]{3627, 3628, 3655, 3656, 3625, 3626, 3629, 3630, 4071, 4072, 5253, 1816, 1817, 3653, 3654, 4067, 4068, 3639, 3640, 1976, 1977, 3571, 3572, 5129, 5130, 2066, 2067, 3545, 3546, 3559, 3560, 3569, 3570, 3551, 3552, 3579, 3580, 3575, 3576, 1766, 1767, 3547, 3548, 3682, 3683, 3696, 3697, 3692, 3693, 4013, 4079, 4080, 4082, 3996, 4083, 4084, 4075, 4076, 3664, 3993, 3994, 3995, 4077, 4078, 4073, 4074, 4011, 4012, 3998, 3999, 4081, 6400, 6401};

    private String forId(int type2) {
        switch (type2) {
            case 1: {
                return "Model";
            }
            case 2: {
                return "Animation";
            }
            case 3: {
                return "Sound";
            }
            case 4: {
                return "Map";
            }
        }
        return "";
    }

    public ResourceProvider() {
        this.requested = new LinkedList();
        this.payload = new byte[500];
        this.fileStatus = new byte[4][];
        this.extras = new LinkedList();
        this.complete = new LinkedList();
        this.gzipInputBuffer = new byte[465000];
        this.requests = new Queue();
        this.versions = new int[4][];
        this.unrequested = new LinkedList();
        this.mandatoryRequests = new LinkedList();
        this.crc32 = new CRC32();
    }

    public void initialize(Archive archive, Client client) {
        for (int i = 0; i < this.crcNames.length; ++i) {
            byte[] crc_file = archive.get(this.crcNames[i]);
            int length = 0;
            if (crc_file == null) continue;
            length = crc_file.length / 4;
            Buffer crcStream = new Buffer(crc_file);
            this.crcs[i] = new int[length];
            this.fileStatus[i] = new byte[length];
            for (int ptr = 0; ptr < length; ++ptr) {
                this.crcs[i][ptr] = crcStream.readInt();
            }
        }
        byte[] data2 = archive.get("map_index");
        Buffer stream = new Buffer(data2);
        int j1 = stream.readUnsignedShort();
        this.areas = new int[j1];
        this.mapFiles = new int[j1];
        this.landscapes = new int[j1];
        this.file_amounts[3] = j1;
        for (int i2 = 0; i2 < j1; ++i2) {
            this.areas[i2] = stream.readUnsignedShort();
            this.mapFiles[i2] = stream.readUnsignedShort();
            this.landscapes[i2] = stream.readUnsignedShort();
            int finalI2 = i2;
            if (!this.debugCheapHaxValues || !Arrays.stream(this.cheapHaxValues).anyMatch(id -> id == this.mapFiles[finalI2])) continue;
            System.out.println("Area: " + this.areas[i2]);
        }
        System.out.println(String.format("Loaded %d maps loading OSRS version %d and SUB version %d", this.file_amounts[3], 212, 0));
        data2 = archive.get("midi_index");
        stream = new Buffer(data2);
        this.file_amounts[2] = j1 = data2.length;
        this.musicPriorities = new int[j1];
        for (int k2 = 0; k2 < j1; ++k2) {
            this.musicPriorities[k2] = stream.readUnsignedByte();
        }
        System.out.println(String.format("Loaded %d sounds loading OSRS version %d and SUB version %d", this.file_amounts[2], 212, 0));
        data2 = archive.get("model_index");
        this.file_amounts[1] = data2.length;
        data2 = archive.get("anim_index");
        this.file_amounts[0] = data2.length;
        System.out.println(String.format("Loaded %d models loading OSRS version %d and SUB version %d", this.file_amounts[0], 212, 0));
        this.clientInstance = client;
        this.running = true;
    }

    public boolean passive_request(int fileId, int indexId) {
        return this.loadData(indexId, fileId, true);
    }

    public int getVersionCount(int index) {
        return this.versions[index].length;
    }

    public int getAnimCount() {
        return 33568;
    }

    public int getModelCount() {
        return 120000;
    }

    @Override
    public void provide(int file) {
        this.provide(0, file);
    }

    public boolean provide(int type2, int file) {
        return this.loadData(type2, file, true);
    }

    public boolean loadData(int indexID, int fileID, boolean flush) {
        Client.instance.getSwiftFUP().getFileRequests().file(indexID + 1, fileID);
        return true;
    }

    public byte[] decompress(int type2, int id) {
        try {
            File file = new File(SignLink.findCacheDir() + "index" + type2 + "/" + id + ".gz");
            if (file.exists()) {
                return Files.readAllBytes(file.toPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public byte[] getFile(int index, int id) {
        try {
            File file = new File(SignLink.findCacheDir() + "index" + index + "/" + id + ".gz");
            if (file.exists()) {
                return Files.readAllBytes(file.toPath());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public int getModelIndex(int i) {
        return this.modelIndices[i] & 0xFF;
    }

    public int getMapIdForRegions(int landscapeOrObject, int regionY, int regionX) {
        int code = (regionX << 8) + regionY;
        for (int area = 0; area < this.areas.length; ++area) {
            if (this.areas[area] != code) continue;
            if (landscapeOrObject == 0) {
                return this.mapFiles[area] > 9999 ? -1 : this.mapFiles[area];
            }
            return this.landscapes[area] > 9999 ? -1 : this.landscapes[area];
        }
        int regionId = (regionX << 8) + regionY;
        for (int j1 = 0; j1 < this.areas.length; ++j1) {
            if (this.areas[j1] != regionId) continue;
            if (regionId == 11840) {
                System.out.println("m=" + this.mapFiles[j1]);
                System.out.println("l=" + this.landscapes[j1]);
            }
            if (landscapeOrObject == 0) {
                if (this.mapFiles[j1] >= 3700 && this.mapFiles[j1] <= 3840) {
                    return this.mapFiles[j1];
                }
                for (int cheapHax : this.mapFiles) {
                    if (this.mapFiles[j1] != cheapHax) continue;
                    return this.mapFiles[j1];
                }
                return this.mapFiles[j1] > 3535 ? -1 : this.mapFiles[j1];
            }
            if (this.landscapes[j1] >= 3700 && this.landscapes[j1] <= 3840) {
                return this.landscapes[j1];
            }
            for (int cheapHax : this.cheapHaxValues) {
                if (this.landscapes[j1] != cheapHax) continue;
                return this.landscapes[j1];
            }
            return this.landscapes[j1] > 3535 ? -1 : this.landscapes[j1];
        }
        return -1;
    }

    public boolean requestExtra(byte priority, int type2, int file) {
        return this.loadData(type2, file, true);
    }
}

