/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.scene;

import com.hazy.Client;
import com.hazy.cache.def.FloorDefinition;
import com.hazy.cache.def.ObjectDefinition;
import com.hazy.draw.Rasterizer3D;
import com.hazy.entity.Renderable;
import com.hazy.entity.model.Model;
import com.hazy.io.Buffer;
import com.hazy.net.requester.ResourceProvider;
import com.hazy.scene.CollisionMap;
import com.hazy.scene.SceneGraph;
import com.hazy.scene.SceneObject;
import com.hazy.util.ChunkUtil;

public final class MapRegion {
    static int hue_offset = (int)(Math.random() * 17.0) - 8;
    static int lightness_offset = (int)(Math.random() * 33.0) - 16;
    private final int[] blended_hue;
    private final int[] blended_saturation;
    private final int[] blended_lightness;
    private final int[] blended_hue_factor;
    private final int[] blend_direction_tracker;
    private final int[][][] vertex_heights;
    public byte[][][] overlays;
    public static int plane;
    private final byte[][][] tile_shadow_intensity;
    private final int[][][] tile_culling_bitsets;
    public byte[][][] overlayTypes;
    private static final int[] decor_x_offsets;
    private final int[][] tile_light_intensity;
    private static final int[] wall_orientations;
    public byte[][][] underlays;
    private static final int[] decor_y_offsets;
    public static int min_plane;
    private final int region_size_x;
    private final int region_size_y;
    private final byte[][][] overlayOrientations;
    private final byte[][][] tile_flags;
    public static boolean low_detail;
    private static final int[] wall_corner_orientations;
    private static final int BLOCKED_TILE = 1;
    public static final int BRIDGE_TILE = 2;
    private static final int FORCE_LOWEST_PLANE = 8;

    public MapRegion(byte[][][] flags, int[][][] heights) {
        min_plane = 99;
        this.region_size_x = 104;
        this.region_size_y = 104;
        this.vertex_heights = heights;
        this.tile_flags = flags;
        this.underlays = new byte[4][this.region_size_x][this.region_size_y];
        this.overlays = new byte[4][this.region_size_x][this.region_size_y];
        this.overlayTypes = new byte[4][this.region_size_x][this.region_size_y];
        this.overlayOrientations = new byte[4][this.region_size_x][this.region_size_y];
        this.tile_culling_bitsets = new int[4][this.region_size_x + 1][this.region_size_y + 1];
        this.tile_shadow_intensity = new byte[4][this.region_size_x + 1][this.region_size_y + 1];
        this.tile_light_intensity = new int[this.region_size_x + 1][this.region_size_y + 1];
        this.blended_hue = new int[this.region_size_y];
        this.blended_saturation = new int[this.region_size_y];
        this.blended_lightness = new int[this.region_size_y];
        this.blended_hue_factor = new int[this.region_size_y];
        this.blend_direction_tracker = new int[this.region_size_y];
    }

    private static int perlin(int x, int y) {
        int k = x + y * 57;
        k = k << 13 ^ k;
        int noise = k * (k * k * 15731 + 789221) + 1376312589 & Integer.MAX_VALUE;
        return noise >> 19 & 0xFF;
    }

    public void create_region(CollisionMap[] clipping_map, SceneGraph scene) {
        for (int plane = 0; plane < 4; ++plane) {
            for (int x = 0; x < 104; ++x) {
                for (int y = 0; y < 104; ++y) {
                    if ((this.tile_flags[plane][x][y] & 1) != 1) continue;
                    int marking_plane = plane;
                    if ((this.tile_flags[1][x][y] & 2) == 2) {
                        --marking_plane;
                    }
                    if (marking_plane < 0) continue;
                    clipping_map[marking_plane].setBlockedByFloor(x, y);
                }
            }
        }
        for (int z = 0; z < 4; ++z) {
            int x;
            int y;
            byte[][] shadow_intensity = this.tile_shadow_intensity[z];
            int directional_light_initial_intensity = 96;
            int specular_distribution_factor = 768;
            int directional_light_x = -50;
            int directional_light_y = -10;
            int directional_light_z = -50;
            int directional_light_length = (int)Math.sqrt(directional_light_x * directional_light_x + directional_light_y * directional_light_y + directional_light_z * directional_light_z);
            int specular_distribution = specular_distribution_factor * directional_light_length >> 8;
            for (y = 1; y < this.region_size_y - 1; ++y) {
                for (x = 1; x < this.region_size_x - 1; ++x) {
                    int x_height_difference = this.vertex_heights[z][x + 1][y] - this.vertex_heights[z][x - 1][y];
                    int y_height_difference = this.vertex_heights[z][x][y + 1] - this.vertex_heights[z][x][y - 1];
                    int normal_length = (int)Math.sqrt(x_height_difference * x_height_difference + 65536 + y_height_difference * y_height_difference);
                    int normalized_normal_x = (x_height_difference << 8) / normal_length;
                    int normalized_normal_y = 65536 / normal_length;
                    int normalized_normal_z = (y_height_difference << 8) / normal_length;
                    int directional_light_intensity = directional_light_initial_intensity + (directional_light_x * normalized_normal_x + directional_light_y * normalized_normal_y + directional_light_z * normalized_normal_z) / specular_distribution;
                    int weighted_shadow_intensity = (shadow_intensity[x - 1][y] >> 2) + (shadow_intensity[x + 1][y] >> 3) + (shadow_intensity[x][y - 1] >> 2) + (shadow_intensity[x][y + 1] >> 3) + (shadow_intensity[x][y] >> 1);
                    this.tile_light_intensity[x][y] = directional_light_intensity - weighted_shadow_intensity;
                }
            }
            for (y = 0; y < this.region_size_y; ++y) {
                this.blended_hue[y] = 0;
                this.blended_saturation[y] = 0;
                this.blended_lightness[y] = 0;
                this.blended_hue_factor[y] = 0;
                this.blend_direction_tracker[y] = 0;
            }
            for (int l6 = -5; l6 < this.region_size_x + 5; ++l6) {
                for (int y2 = 0; y2 < this.region_size_y; ++y2) {
                    int floor_id;
                    int x_negative_offset;
                    int floor_id2;
                    int x_positive_offset = l6 + 5;
                    if (x_positive_offset >= 0 && x_positive_offset < this.region_size_x && (floor_id2 = this.underlays[z][x_positive_offset][y2] & 0xFF) > 0) {
                        FloorDefinition def = FloorDefinition.underlays[floor_id2 - 1];
                        int n = y2;
                        this.blended_hue[n] = this.blended_hue[n] + def.blendHue;
                        int n2 = y2;
                        this.blended_saturation[n2] = this.blended_saturation[n2] + def.saturation;
                        int n3 = y2;
                        this.blended_lightness[n3] = this.blended_lightness[n3] + def.luminance;
                        int n4 = y2;
                        this.blended_hue_factor[n4] = this.blended_hue_factor[n4] + def.blendHueMultiplier;
                        int n5 = y2;
                        this.blend_direction_tracker[n5] = this.blend_direction_tracker[n5] + 1;
                    }
                    if ((x_negative_offset = l6 - 5) < 0 || x_negative_offset >= this.region_size_x || (floor_id = this.underlays[z][x_negative_offset][y2] & 0xFF) <= 0) continue;
                    FloorDefinition def = FloorDefinition.underlays[floor_id - 1];
                    int n = y2;
                    this.blended_hue[n] = this.blended_hue[n] - def.blendHue;
                    int n6 = y2;
                    this.blended_saturation[n6] = this.blended_saturation[n6] - def.saturation;
                    int n7 = y2;
                    this.blended_lightness[n7] = this.blended_lightness[n7] - def.luminance;
                    int n8 = y2;
                    this.blended_hue_factor[n8] = this.blended_hue_factor[n8] - def.blendHueMultiplier;
                    int n9 = y2;
                    this.blend_direction_tracker[n9] = this.blend_direction_tracker[n9] - 1;
                }
                if (l6 < 1 || l6 >= this.region_size_x - 1) continue;
                int blend_hue = 0;
                int blend_saturation = 0;
                int blend_lightness = 0;
                int blend_hue_factor = 0;
                int blended_tracker = 0;
                for (int k17 = -5; k17 < this.region_size_y + 5; ++k17) {
                    int lightness;
                    int encodedMinimap;
                    int encodedTile;
                    int minimapColor;
                    int y_negative_offset;
                    int y_positive_offset = k17 + 5;
                    if (y_positive_offset >= 0 && y_positive_offset < this.region_size_y) {
                        blend_hue += this.blended_hue[y_positive_offset];
                        blend_saturation += this.blended_saturation[y_positive_offset];
                        blend_lightness += this.blended_lightness[y_positive_offset];
                        blend_hue_factor += this.blended_hue_factor[y_positive_offset];
                        blended_tracker += this.blend_direction_tracker[y_positive_offset];
                    }
                    if ((y_negative_offset = k17 - 5) >= 0 && y_negative_offset < this.region_size_y) {
                        blend_hue -= this.blended_hue[y_negative_offset];
                        blend_saturation -= this.blended_saturation[y_negative_offset];
                        blend_lightness -= this.blended_lightness[y_negative_offset];
                        blend_hue_factor -= this.blended_hue_factor[y_negative_offset];
                        blended_tracker -= this.blend_direction_tracker[y_negative_offset];
                    }
                    if (k17 < 1 || k17 >= this.region_size_y - 1) continue;
                    if (low_detail && (this.tile_flags[0][l6][k17] & 2) == 0) {
                        if ((this.tile_flags[z][l6][k17] & 0x10) != 0) continue;
                        if (this.get_visibility(k17, z, l6) != plane) continue;
                    }
                    if (z < min_plane) {
                        min_plane = z;
                    }
                    int underlay_id = this.underlays[z][l6][k17] & 0xFF;
                    int i19 = this.overlays[z][l6][k17] & 0xFF;
                    if (underlay_id <= 0 && i19 <= 0) continue;
                    int v_sw = this.vertex_heights[z][l6][k17];
                    int v_se = this.vertex_heights[z][l6 + 1][k17];
                    int v_ne = this.vertex_heights[z][l6 + 1][k17 + 1];
                    int v_nw = this.vertex_heights[z][l6][k17 + 1];
                    int l_sw = this.tile_light_intensity[l6][k17];
                    int l_se = this.tile_light_intensity[l6 + 1][k17];
                    int l_ne = this.tile_light_intensity[l6 + 1][k17 + 1];
                    int l_nw = this.tile_light_intensity[l6][k17 + 1];
                    int hsl_bitset_unmodified = -1;
                    int hsl_bitset_randomized = -1;
                    if (underlay_id > 0) {
                        int hue = blend_hue * 256 / blend_hue_factor;
                        int sat = blend_saturation / blended_tracker;
                        int lum = blend_lightness / blended_tracker;
                        hsl_bitset_unmodified = this.encode_hsl(hue, sat, lum);
                        if (lum < 0) {
                            lum = 0;
                        } else if (lum > 255) {
                            lum = 255;
                        }
                        hsl_bitset_randomized = this.encode_hsl(hue, sat, lum);
                    }
                    boolean hide_underlay = true;
                    if (z > 0) {
                        if (underlay_id == 0 && this.overlayTypes[z][l6][k17] != 0) {
                            hide_underlay = false;
                        }
                        if (i19 > 0 && !FloorDefinition.overlays[i19 - 1].hideUnderlay) {
                            hide_underlay = false;
                        }
                    }
                    if (hide_underlay && v_sw == v_se && v_sw == v_ne && v_sw == v_nw) {
                        int[] nArray = this.tile_culling_bitsets[z][l6];
                        int n = k17;
                        nArray[n] = nArray[n] | 0x924;
                    }
                    int rgb_bitset_randomized = 0;
                    if (hsl_bitset_unmodified != -1) {
                        rgb_bitset_randomized = Rasterizer3D.hslToRgb[this.method1766(hsl_bitset_randomized, 96)];
                    }
                    if (i19 == 0) {
                        scene.addTile(z, l6, k17, 0, 0, -1, v_sw, v_se, v_ne, v_nw, this.method1766(hsl_bitset_unmodified, l_sw), this.method1766(hsl_bitset_unmodified, l_se), this.method1766(hsl_bitset_unmodified, l_ne), this.method1766(hsl_bitset_unmodified, l_nw), 0, 0, 0, 0, rgb_bitset_randomized, 0);
                        continue;
                    }
                    int k22 = this.overlayTypes[z][l6][k17] + 1;
                    byte byte4 = this.overlayOrientations[z][l6][k17];
                    if (i19 - 1 > FloorDefinition.overlays.length) {
                        i19 = FloorDefinition.overlays.length;
                    }
                    FloorDefinition overlay_flo = FloorDefinition.overlays[i19 - 1];
                    int texture = overlay_flo.texture;
                    if (texture >= 0) {
                        minimapColor = Rasterizer3D.textureLoader.getAverageTextureRGB(texture);
                        encodedTile = -1;
                    } else if (overlay_flo.rgb == 0xFF00FF) {
                        encodedTile = -2;
                        texture = -1;
                        minimapColor = -2;
                    } else {
                        encodedTile = MapRegion.set_hsl_bitset(overlay_flo.hue, overlay_flo.saturation, overlay_flo.lightness);
                        encodedMinimap = overlay_flo.hue;
                        lightness = overlay_flo.lightness;
                        if (lightness < 0) {
                            lightness = 0;
                        } else if (lightness > 255) {
                            lightness = 255;
                        }
                        minimapColor = MapRegion.set_hsl_bitset(encodedMinimap, overlay_flo.saturation, lightness);
                    }
                    encodedMinimap = 0;
                    if (minimapColor != -2) {
                        encodedMinimap = Rasterizer3D.hslToRgb[this.method425(minimapColor, 96)];
                    }
                    if (overlay_flo.secondaryRgb != -1) {
                        lightness = overlay_flo.secondaryHue;
                        int secondaryLightness = overlay_flo.secondaryLightness;
                        if (secondaryLightness < 0) {
                            secondaryLightness = 0;
                        } else if (secondaryLightness > 255) {
                            secondaryLightness = 255;
                        }
                        minimapColor = MapRegion.set_hsl_bitset(lightness, overlay_flo.secondarySaturation, secondaryLightness);
                        encodedMinimap = Rasterizer3D.hslToRgb[this.method425(minimapColor, 96)];
                    }
                    scene.addTile(z, l6, k17, k22, byte4, texture, v_sw, v_se, v_ne, v_nw, this.method1766(hsl_bitset_unmodified, l_sw), this.method1766(hsl_bitset_unmodified, l_se), this.method1766(hsl_bitset_unmodified, l_ne), this.method1766(hsl_bitset_unmodified, l_nw), this.method425(encodedTile, l_sw), this.method425(encodedTile, l_se), this.method425(encodedTile, l_ne), this.method425(encodedTile, l_nw), rgb_bitset_randomized, encodedMinimap);
                }
            }
            for (y = 1; y < this.region_size_y - 1; ++y) {
                for (x = 1; x < this.region_size_x - 1; ++x) {
                    scene.setTileLogicHeight(z, x, y, this.get_visibility(y, z, x));
                }
            }
        }
        scene.shadeModels(-10, -50, -50);
        for (int y = 0; y < this.region_size_x; ++y) {
            for (int x = 0; x < this.region_size_y; ++x) {
                if ((this.tile_flags[1][y][x] & 2) != 2) continue;
                scene.applyBridgeMode(x, y);
            }
        }
        int flag_0x8 = 1;
        int flag_0x10 = 2;
        int flag_0x20 = 4;
        for (int cur_plane = 0; cur_plane < 4; ++cur_plane) {
            if (cur_plane > 0) {
                flag_0x8 <<= 3;
                flag_0x10 <<= 3;
                flag_0x20 <<= 3;
            }
            for (int plane = 0; plane <= cur_plane; ++plane) {
                for (int y = 0; y <= this.region_size_y; ++y) {
                    for (int x = 0; x <= this.region_size_x; ++x) {
                        int lowest_occlusion_y;
                        int lowest_occlusion_x;
                        int highest_occlusion_x;
                        int occluded_plane;
                        int occluded_y;
                        int highest_occlusion_plane;
                        int lowest_occlusion_plane;
                        if ((this.tile_culling_bitsets[plane][x][y] & flag_0x8) != 0) {
                            int occlusion_surface;
                            int lowest_occlusion_y2;
                            int highest_occlusion_y = y;
                            lowest_occlusion_plane = plane;
                            highest_occlusion_plane = plane;
                            for (lowest_occlusion_y2 = y; lowest_occlusion_y2 > 0 && (this.tile_culling_bitsets[plane][x][lowest_occlusion_y2 - 1] & flag_0x8) != 0; --lowest_occlusion_y2) {
                            }
                            while (highest_occlusion_y < this.region_size_y && (this.tile_culling_bitsets[plane][x][highest_occlusion_y + 1] & flag_0x8) != 0) {
                                ++highest_occlusion_y;
                            }
                            block20: while (lowest_occlusion_plane > 0) {
                                for (occluded_y = lowest_occlusion_y2; occluded_y <= highest_occlusion_y; ++occluded_y) {
                                    if ((this.tile_culling_bitsets[lowest_occlusion_plane - 1][x][occluded_y] & flag_0x8) == 0) break block20;
                                }
                                --lowest_occlusion_plane;
                            }
                            block22: while (highest_occlusion_plane < cur_plane) {
                                for (occluded_y = lowest_occlusion_y2; occluded_y <= highest_occlusion_y; ++occluded_y) {
                                    if ((this.tile_culling_bitsets[highest_occlusion_plane + 1][x][occluded_y] & flag_0x8) == 0) break block22;
                                }
                                ++highest_occlusion_plane;
                            }
                            if ((occlusion_surface = (highest_occlusion_plane + 1 - lowest_occlusion_plane) * (highest_occlusion_y - lowest_occlusion_y2 + 1)) >= 8) {
                                int c1 = 240;
                                int highest_occlusion_vertex_height = this.vertex_heights[highest_occlusion_plane][x][lowest_occlusion_y2] - c1;
                                int lowest_occlusion_vertex_height = this.vertex_heights[lowest_occlusion_plane][x][lowest_occlusion_y2];
                                SceneGraph.createNewSceneCluster(cur_plane, x * 128, lowest_occlusion_vertex_height, x * 128, highest_occlusion_y * 128 + 128, highest_occlusion_vertex_height, lowest_occlusion_y2 * 128, 1);
                                for (occluded_plane = lowest_occlusion_plane; occluded_plane <= highest_occlusion_plane; ++occluded_plane) {
                                    int occluded_y2 = lowest_occlusion_y2;
                                    while (occluded_y2 <= highest_occlusion_y) {
                                        int[] nArray = this.tile_culling_bitsets[occluded_plane][x];
                                        int n = occluded_y2++;
                                        nArray[n] = nArray[n] & ~flag_0x8;
                                    }
                                }
                            }
                        }
                        if ((this.tile_culling_bitsets[plane][x][y] & flag_0x10) != 0) {
                            int occlussion_surface;
                            int occluded_x;
                            highest_occlusion_x = x;
                            lowest_occlusion_plane = plane;
                            highest_occlusion_plane = plane;
                            for (lowest_occlusion_x = x; lowest_occlusion_x > 0 && (this.tile_culling_bitsets[plane][lowest_occlusion_x - 1][y] & flag_0x10) != 0; --lowest_occlusion_x) {
                            }
                            while (highest_occlusion_x < this.region_size_x && (this.tile_culling_bitsets[plane][highest_occlusion_x + 1][y] & flag_0x10) != 0) {
                                ++highest_occlusion_x;
                            }
                            block28: while (lowest_occlusion_plane > 0) {
                                for (occluded_x = lowest_occlusion_x; occluded_x <= highest_occlusion_x; ++occluded_x) {
                                    if ((this.tile_culling_bitsets[lowest_occlusion_plane - 1][occluded_x][y] & flag_0x10) == 0) break block28;
                                }
                                --lowest_occlusion_plane;
                            }
                            block30: while (highest_occlusion_plane < cur_plane) {
                                for (occluded_x = lowest_occlusion_x; occluded_x <= highest_occlusion_x; ++occluded_x) {
                                    if ((this.tile_culling_bitsets[highest_occlusion_plane + 1][occluded_x][y] & flag_0x10) == 0) break block30;
                                }
                                ++highest_occlusion_plane;
                            }
                            if ((occlussion_surface = (highest_occlusion_plane + 1 - lowest_occlusion_plane) * (highest_occlusion_x - lowest_occlusion_x + 1)) >= 8) {
                                int c2 = 240;
                                int highest_occlussion_vertex_height = this.vertex_heights[highest_occlusion_plane][lowest_occlusion_x][y] - c2;
                                int lowest_occlussion_vertex_height = this.vertex_heights[lowest_occlusion_plane][lowest_occlusion_x][y];
                                SceneGraph.createNewSceneCluster(cur_plane, lowest_occlusion_x * 128, lowest_occlussion_vertex_height, highest_occlusion_x * 128 + 128, y * 128, highest_occlussion_vertex_height, y * 128, 2);
                                for (occluded_plane = lowest_occlusion_plane; occluded_plane <= highest_occlusion_plane; ++occluded_plane) {
                                    for (int occluded_x2 = lowest_occlusion_x; occluded_x2 <= highest_occlusion_x; ++occluded_x2) {
                                        int[] nArray = this.tile_culling_bitsets[occluded_plane][occluded_x2];
                                        int n = y;
                                        nArray[n] = nArray[n] & ~flag_0x10;
                                    }
                                }
                            }
                        }
                        if ((this.tile_culling_bitsets[plane][x][y] & flag_0x20) == 0) continue;
                        lowest_occlusion_x = x;
                        highest_occlusion_x = x;
                        int highest_occlusion_y = y;
                        for (lowest_occlusion_y = y; lowest_occlusion_y > 0 && (this.tile_culling_bitsets[plane][x][lowest_occlusion_y - 1] & flag_0x20) != 0; --lowest_occlusion_y) {
                        }
                        while (highest_occlusion_y < this.region_size_y && (this.tile_culling_bitsets[plane][x][highest_occlusion_y + 1] & flag_0x20) != 0) {
                            ++highest_occlusion_y;
                        }
                        block36: while (lowest_occlusion_x > 0) {
                            for (occluded_y = lowest_occlusion_y; occluded_y <= highest_occlusion_y; ++occluded_y) {
                                if ((this.tile_culling_bitsets[plane][lowest_occlusion_x - 1][occluded_y] & flag_0x20) == 0) break block36;
                            }
                            --lowest_occlusion_x;
                        }
                        block38: while (highest_occlusion_x < this.region_size_x) {
                            for (occluded_y = lowest_occlusion_y; occluded_y <= highest_occlusion_y; ++occluded_y) {
                                if ((this.tile_culling_bitsets[plane][highest_occlusion_x + 1][occluded_y] & flag_0x20) == 0) break block38;
                            }
                            ++highest_occlusion_x;
                        }
                        if ((highest_occlusion_x - lowest_occlusion_x + 1) * (highest_occlusion_y - lowest_occlusion_y + 1) < 4) continue;
                        int lowest_occlussion_vertex_height = this.vertex_heights[plane][lowest_occlusion_x][lowest_occlusion_y];
                        SceneGraph.createNewSceneCluster(cur_plane, lowest_occlusion_x * 128, lowest_occlussion_vertex_height, highest_occlusion_x * 128 + 128, highest_occlusion_y * 128 + 128, lowest_occlussion_vertex_height, lowest_occlusion_y * 128, 4);
                        for (int occluded_x = lowest_occlusion_x; occluded_x <= highest_occlusion_x; ++occluded_x) {
                            int occluded_y3 = lowest_occlusion_y;
                            while (occluded_y3 <= highest_occlusion_y) {
                                int[] nArray = this.tile_culling_bitsets[plane][occluded_x];
                                int n = occluded_y3++;
                                nArray[n] = nArray[n] & ~flag_0x20;
                            }
                        }
                    }
                }
            }
        }
    }

    public int method425(int var0, int var1) {
        if (var0 == -2) {
            return 12345678;
        }
        if (var0 == -1) {
            if (var1 < 2) {
                var1 = 2;
            } else if (var1 > 126) {
                var1 = 126;
            }
            return var1;
        }
        if ((var1 = (var0 & 0x7F) * var1 / 128) < 2) {
            var1 = 2;
        } else if (var1 > 126) {
            var1 = 126;
        }
        return (var0 & 0xFF80) + var1;
    }

    public int method1766(int var0, int var1) {
        if (var0 == -1) {
            return 12345678;
        }
        if ((var1 = (var0 & 0x7F) * var1 / 128) < 2) {
            var1 = 2;
        } else if (var1 > 126) {
            var1 = 126;
        }
        return (var0 & 0xFF80) + var1;
    }

    private static int calc_heights(int x, int y) {
        int height = MapRegion.interpolated_noise(x + 45365, y + 91923, 4) - 128 + (MapRegion.interpolated_noise(x + 10294, y + 37821, 2) - 128 >> 1) + (MapRegion.interpolated_noise(x, y, 1) - 128 >> 2);
        if ((height = (int)((double)height * 0.3) + 35) < 10) {
            height = 10;
        } else if (height > 60) {
            height = 60;
        }
        return height;
    }

    public static void passive_request_obj_models(Buffer buffer, ResourceProvider provider) {
        int id_offset;
        int object_id = -1;
        while ((id_offset = buffer.readUSmart2()) != 0) {
            int terminate;
            ObjectDefinition def = ObjectDefinition.get(object_id += id_offset);
            def.passive_request_load(provider);
            while ((terminate = buffer.readUSmart()) != 0) {
                buffer.readUnsignedByte();
            }
        }
    }

    public final void set_vertex_heights(int y, int height, int width, int x) {
        for (int y_pos = y; y_pos <= y + height; ++y_pos) {
            for (int x_pos = x; x_pos <= x + width; ++x_pos) {
                if (x_pos < 0 || x_pos >= this.region_size_x || y_pos < 0 || y_pos >= this.region_size_y) continue;
                this.tile_shadow_intensity[0][x_pos][y_pos] = 127;
                if (x_pos == x && x_pos > 0) {
                    this.vertex_heights[0][x_pos][y_pos] = this.vertex_heights[0][x_pos - 1][y_pos];
                }
                if (x_pos == x + width && x_pos < this.region_size_x - 1) {
                    this.vertex_heights[0][x_pos][y_pos] = this.vertex_heights[0][x_pos + 1][y_pos];
                }
                if (y_pos == y && y_pos > 0) {
                    this.vertex_heights[0][x_pos][y_pos] = this.vertex_heights[0][x_pos][y_pos - 1];
                }
                if (y_pos != y + height || y_pos >= this.region_size_y - 1) continue;
                this.vertex_heights[0][x_pos][y_pos] = this.vertex_heights[0][x_pos][y_pos + 1];
            }
        }
    }

    private void render(int y, SceneGraph scene, CollisionMap map, int type2, int plane, int x, int object_id, int orientation) {
        int obj_y_factor_a;
        int obj_y_factor_b;
        int obj_x_factor_a;
        int obj_x_factor_b;
        int obj_size_offset_b;
        int obj_size_offset_a;
        if (low_detail && (this.tile_flags[0][x][y] & 2) == 0) {
            if ((this.tile_flags[plane][x][y] & 0x10) != 0) {
                return;
            }
            if (this.get_visibility(y, plane, x) != MapRegion.plane) {
                return;
            }
        }
        if (plane < min_plane) {
            min_plane = plane;
        }
        ObjectDefinition def = ObjectDefinition.get(object_id);
        if (orientation == 1 || orientation == 3) {
            obj_size_offset_a = def.height;
            obj_size_offset_b = def.width;
        } else {
            obj_size_offset_a = def.width;
            obj_size_offset_b = def.height;
        }
        if (104 >= obj_size_offset_a + x) {
            obj_x_factor_b = x + (obj_size_offset_a + 1 >> 1);
            obj_x_factor_a = x + (obj_size_offset_a >> 1);
        } else {
            obj_x_factor_a = x;
            obj_x_factor_b = x + 1;
        }
        if (104 >= obj_size_offset_b + y) {
            obj_y_factor_b = y + (obj_size_offset_b + 1 >> 1);
            obj_y_factor_a = (obj_size_offset_b >> 1) + y;
        } else {
            obj_y_factor_a = y;
            obj_y_factor_b = 1 + y;
        }
        int v_sw = this.vertex_heights[plane][obj_x_factor_a][obj_y_factor_a];
        int v_se = this.vertex_heights[plane][obj_x_factor_b][obj_y_factor_a];
        int v_ne = this.vertex_heights[plane][obj_x_factor_b][obj_y_factor_b];
        int v_nw = this.vertex_heights[plane][obj_x_factor_a][obj_y_factor_b];
        int avg = v_sw + v_se + v_ne + v_nw >> 2;
        int mX = Client.instance.region_x - 6;
        int mY = Client.instance.region_y - 6;
        int actualX = mX * 8 + x;
        int actualY = mY * 8 + y;
        if (object_id == 1391 && actualX == 3099 && actualY == 3493) {
            return;
        }
        if (object_id == 1123 && actualX == 3099 && actualY == 3491) {
            return;
        }
        if (actualX == 2031 && actualY == 3568) {
            return;
        }
        if (actualX == 2670 && actualY == 2593) {
            return;
        }
        if (actualX == 2670 && actualY == 2592) {
            return;
        }
        if (actualX == 2657 && actualY == 2585) {
            return;
        }
        if (actualX == 2656 && actualY == 2585) {
            return;
        }
        if (actualX == 2643 && actualY == 2592) {
            return;
        }
        if (actualX == 2643 && actualY == 2593) {
            return;
        }
        if (plane == 0) {
            if (actualX == 2958 && actualY == 3821) {
                return;
            }
            if (actualX == 2958 && actualY == 3820) {
                return;
            }
            if (actualX == 3040 && actualY == 10307) {
                return;
            }
            if (actualX == 3040 && actualY == 10308) {
                return;
            }
            if (actualX == 3022 && actualY == 10311) {
                return;
            }
            if (actualX == 3022 && actualY == 10312) {
                return;
            }
            if (actualX == 3044 && actualY == 10341) {
                return;
            }
            if (actualX == 3044 && actualY == 10342) {
                return;
            }
        }
        long key = orientation << 20 | type2 << 14 | (y << 7 | x) + 0x40000000;
        if (def.wallOrDoor == 0) {
            key |= Long.MIN_VALUE;
        }
        if (def.supportsItems == 1) {
            key |= 0x400000L;
        }
        key |= (long)object_id << 32;
        if (type2 == 22) {
            if (low_detail && def.wallOrDoor == 0 && def.interactType == 1 && !def.obstructsGround) {
                return;
            }
            Renderable ground_map_scene_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(22, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 22, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_ground_decor(plane, avg, y, ground_map_scene_decor, key, x);
            if (def.interactType == 1 && map != null) {
                map.setBlockedByFloorDec(x, y);
            }
            return;
        }
        if (type2 == 10 || type2 == 11) {
            Renderable scene_objects = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(10, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 10, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            if (scene_objects != null) {
                Renderable model;
                int size_offset_b;
                int size_offset_a;
                int obj_rotation = 0;
                if (type2 == 11) {
                    obj_rotation += 256;
                }
                if (orientation == 1 || orientation == 3) {
                    size_offset_a = def.height;
                    size_offset_b = def.width;
                } else {
                    size_offset_a = def.width;
                    size_offset_b = def.height;
                }
                if (scene.add_entity(key, avg, size_offset_b, scene_objects, size_offset_a, plane, obj_rotation, y, x) && def.shadow && (model = scene_objects instanceof Model ? scene_objects : def.modelAt(10, orientation, v_sw, v_se, v_ne, v_nw, -1)) != null) {
                    for (int x_factor = 0; x_factor <= size_offset_a; ++x_factor) {
                        for (int y_factor = 0; y_factor <= size_offset_b; ++y_factor) {
                            int shadow = model.diagonal2DAboveOrigin / 4;
                            if (shadow > 30) {
                                shadow = 30;
                            }
                            if (shadow <= this.tile_shadow_intensity[plane][x + x_factor][y + y_factor]) continue;
                            this.tile_shadow_intensity[plane][x + x_factor][y + y_factor] = (byte)shadow;
                        }
                    }
                }
            }
            if (def.interactType != 0 && map != null) {
                map.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (type2 >= 12) {
            Renderable roofs = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(type2, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, type2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_entity(key, avg, 1, roofs, 1, plane, 0, y, x);
            if (type2 >= 12 && type2 <= 17 && type2 != 13 && plane > 0) {
                int[] nArray = this.tile_culling_bitsets[plane][x];
                int n = y;
                nArray[n] = nArray[n] | 0x924;
            }
            if (def.interactType != 0 && map != null) {
                map.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 0) {
            Renderable straight_wall = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(0, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 0, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_corner_orientations[orientation], straight_wall, key, y, x, null, avg, 0, plane);
            if (orientation == 0) {
                if (def.shadow) {
                    this.tile_shadow_intensity[plane][x][y] = 50;
                    this.tile_shadow_intensity[plane][x][y + 1] = 50;
                }
                if (def.aBool2111) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y;
                    nArray[n] = nArray[n] | 0x249;
                }
            } else if (orientation == 1) {
                if (def.shadow) {
                    this.tile_shadow_intensity[plane][x][y + 1] = 50;
                    this.tile_shadow_intensity[plane][x + 1][y + 1] = 50;
                }
                if (def.aBool2111) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y + 1;
                    nArray[n] = nArray[n] | 0x492;
                }
            } else if (orientation == 2) {
                if (def.shadow) {
                    this.tile_shadow_intensity[plane][x + 1][y] = 50;
                    this.tile_shadow_intensity[plane][x + 1][y + 1] = 50;
                }
                if (def.aBool2111) {
                    int[] nArray = this.tile_culling_bitsets[plane][x + 1];
                    int n = y;
                    nArray[n] = nArray[n] | 0x249;
                }
            } else if (orientation == 3) {
                if (def.shadow) {
                    this.tile_shadow_intensity[plane][x][y] = 50;
                    this.tile_shadow_intensity[plane][x + 1][y] = 50;
                }
                if (def.aBool2111) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y;
                    nArray[n] = nArray[n] | 0x492;
                }
            }
            if (def.interactType != 0 && map != null) {
                map.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            if (def.decorDisplacement != 16) {
                scene.method290(y, def.decorDisplacement, x, plane);
            }
            return;
        }
        if (type2 == 1) {
            Renderable diagonal_wall_connector = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(1, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 1, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_orientations[orientation], diagonal_wall_connector, key, y, x, null, avg, 0, plane);
            if (def.shadow) {
                if (orientation == 0) {
                    this.tile_shadow_intensity[plane][x][y + 1] = 50;
                } else if (orientation == 1) {
                    this.tile_shadow_intensity[plane][x + 1][y + 1] = 50;
                } else if (orientation == 2) {
                    this.tile_shadow_intensity[plane][x + 1][y] = 50;
                } else if (orientation == 3) {
                    this.tile_shadow_intensity[plane][x][y] = 50;
                }
            }
            if (def.interactType != 0 && map != null) {
                map.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 2) {
            Renderable corner;
            Renderable wall;
            int orientation_offset = orientation + 1 & 3;
            if (def.animationID == -1 && def.configChangeDest == null) {
                wall = def.modelAt(2, 4 + orientation, v_sw, v_se, v_ne, v_nw, -1);
                corner = def.modelAt(2, orientation_offset, v_sw, v_se, v_ne, v_nw, -1);
            } else {
                wall = new SceneObject(object_id, 4 + orientation, 2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
                corner = new SceneObject(object_id, orientation_offset, 2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            }
            scene.add_wall(wall_corner_orientations[orientation], wall, key, y, x, corner, avg, wall_corner_orientations[orientation_offset], plane);
            if (def.aBool2111) {
                if (orientation == 0) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y;
                    nArray[n] = nArray[n] | 0x249;
                    int[] nArray2 = this.tile_culling_bitsets[plane][x];
                    int n2 = y + 1;
                    nArray2[n2] = nArray2[n2] | 0x492;
                } else if (orientation == 1) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y + 1;
                    nArray[n] = nArray[n] | 0x492;
                    int[] nArray3 = this.tile_culling_bitsets[plane][x + 1];
                    int n3 = y;
                    nArray3[n3] = nArray3[n3] | 0x249;
                } else if (orientation == 2) {
                    int[] nArray = this.tile_culling_bitsets[plane][x + 1];
                    int n = y;
                    nArray[n] = nArray[n] | 0x249;
                    int[] nArray4 = this.tile_culling_bitsets[plane][x];
                    int n4 = y;
                    nArray4[n4] = nArray4[n4] | 0x492;
                } else if (orientation == 3) {
                    int[] nArray = this.tile_culling_bitsets[plane][x];
                    int n = y;
                    nArray[n] = nArray[n] | 0x492;
                    int[] nArray5 = this.tile_culling_bitsets[plane][x];
                    int n5 = y;
                    nArray5[n5] = nArray5[n5] | 0x249;
                }
            }
            if (def.interactType != 0 && map != null) {
                map.addWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            if (def.decorDisplacement != 16) {
                scene.method290(y, def.decorDisplacement, x, plane);
            }
            return;
        }
        if (type2 == 3) {
            Renderable straight_corner_connector = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(3, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 3, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_orientations[orientation], straight_corner_connector, key, y, x, null, avg, 0, plane);
            if (def.shadow) {
                if (orientation == 0) {
                    this.tile_shadow_intensity[plane][x][y + 1] = 50;
                } else if (orientation == 1) {
                    this.tile_shadow_intensity[plane][x + 1][y + 1] = 50;
                } else if (orientation == 2) {
                    this.tile_shadow_intensity[plane][x + 1][y] = 50;
                } else if (orientation == 3) {
                    this.tile_shadow_intensity[plane][x][y] = 50;
                }
            }
            if (def.interactType != 0 && map != null) {
                map.addWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 9) {
            Renderable diagonal_walls = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(type2, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, type2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_entity(key, avg, 1, diagonal_walls, 1, plane, 0, y, x);
            if (def.interactType != 0 && map != null) {
                map.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (def.contouredGround) {
            int pos;
            if (orientation == 1) {
                pos = v_nw;
                v_nw = v_ne;
                v_ne = v_se;
                v_se = v_sw;
                v_sw = pos;
            } else if (orientation == 2) {
                pos = v_nw;
                v_nw = v_se;
                v_se = pos;
                pos = v_ne;
                v_ne = v_sw;
                v_sw = pos;
            } else if (orientation == 3) {
                pos = v_nw;
                v_nw = v_sw;
                v_sw = v_se;
                v_se = v_ne;
                v_ne = pos;
            }
        }
        if (type2 == 4) {
            Renderable inner_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation * 512, plane, 0, avg, inner_wall_decor, x, 0, wall_corner_orientations[orientation]);
            return;
        }
        if (type2 == 5) {
            int offset = 16;
            long wall_uid = scene.get_wall_uid(plane, x, y);
            if (wall_uid > 0L) {
                offset = ObjectDefinition.get((int)((int)(wall_uid >>> 32) & Integer.MAX_VALUE)).decorDisplacement;
            }
            Renderable outer_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation * 512, plane, decor_x_offsets[orientation] * offset, avg, outer_wall_decor, x, decor_y_offsets[orientation] * offset, wall_corner_orientations[orientation]);
            return;
        }
        if (type2 == 6) {
            Renderable outer_diagonal_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, plane, 0, avg, outer_diagonal_wall_decor, x, 0, 256);
            return;
        }
        if (type2 == 7) {
            Renderable inner_diagonal_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, plane, 0, avg, inner_diagonal_wall_decor, x, 0, 512);
            return;
        }
        if (type2 == 8) {
            Renderable diagonal_window_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, plane, 0, avg, diagonal_window_decor, x, 0, 768);
        }
    }

    private static int interpolated_noise(int freq_x, int freq_y, int frequency) {
        int x = freq_x / frequency;
        int width = freq_x & frequency - 1;
        int y = freq_y / frequency;
        int height = freq_y & frequency - 1;
        int sw = MapRegion.smooth(x, y);
        int se = MapRegion.smooth(x + 1, y);
        int ne = MapRegion.smooth(x, y + 1);
        int nw = MapRegion.smooth(x + 1, y + 1);
        int a = MapRegion.interpolate(sw, se, width, frequency);
        int b = MapRegion.interpolate(ne, nw, width, frequency);
        return MapRegion.interpolate(a, b, height, frequency);
    }

    public static boolean cached(int object_id, int type2) {
        ObjectDefinition def = ObjectDefinition.get(object_id);
        if (type2 == 11) {
            type2 = 10;
        }
        if (type2 >= 5 && type2 <= 8) {
            type2 = 4;
        }
        return def.group_cached(type2);
    }

    public final void load_sub_terrain_block(int sub_plane, int rotation, CollisionMap[] collision, int block_x, int width, byte[] data2, int height, int plane, int block_y) {
        for (int x = 0; x < 8; ++x) {
            for (int y = 0; y < 8; ++y) {
                if (block_x + x <= 0 || block_x + x >= 103 || block_y + y <= 0 || block_y + y >= 103) continue;
                int[] nArray = collision[plane].adjacencies[block_x + x];
                int n = block_y + y;
                nArray[n] = nArray[n] & 0xFEFFFFFF;
            }
        }
        Buffer buffer = new Buffer(data2);
        for (int tile_plane = 0; tile_plane < 4; ++tile_plane) {
            for (int tile_x = 0; tile_x < 64; ++tile_x) {
                for (int tile_y = 0; tile_y < 64; ++tile_y) {
                    if (tile_plane == sub_plane && tile_x >= width && tile_x < width + 8 && tile_y >= height && tile_y < height + 8) {
                        this.load_terrain_tile(block_y + ChunkUtil.get_rotated_map_y(tile_y & 7, rotation, tile_x & 7), 0, buffer, block_x + ChunkUtil.get_rotated_map_x(rotation, tile_y & 7, tile_x & 7), plane, rotation, 0);
                        continue;
                    }
                    this.load_terrain_tile(-1, 0, buffer, -1, 0, 0, 0);
                }
            }
        }
    }

    public final void load_terrain_block(byte[] data2, int block_y, int block_x, int x_offset, int y_offset, CollisionMap[] collision) {
        for (int plane = 0; plane < 4; ++plane) {
            for (int x = 0; x < 64; ++x) {
                for (int y = 0; y < 64; ++y) {
                    if (block_x + x <= 0 || block_x + x >= 103 || block_y + y <= 0 || block_y + y >= 103) continue;
                    int[] nArray = collision[plane].adjacencies[block_x + x];
                    int n = block_y + y;
                    nArray[n] = nArray[n] & 0xFEFFFFFF;
                }
            }
        }
        Buffer buffer = new Buffer(data2);
        for (int plane = 0; plane < 4; ++plane) {
            for (int x = 0; x < 64; ++x) {
                for (int y = 0; y < 64; ++y) {
                    this.load_terrain_tile(y + block_y, y_offset, buffer, x + block_x, plane, 0, x_offset);
                }
            }
        }
    }

    private void load_terrain_tile(int y, int y_offset, Buffer buffer, int x, int plane, int orientation, int x_offset) {
        try {
            int index;
            if (x >= 0 && x < 104 && y >= 0 && y < 104) {
                int absX = x_offset + x;
                int absY = y_offset + y;
                int absZ = orientation + plane;
                this.tile_flags[plane][x][y] = 0;
                while (true) {
                    int index2;
                    if ((index2 = buffer.readUnsignedByte()) == 0) {
                        if (plane == 0) {
                            this.vertex_heights[0][x][y] = -MapRegion.calc_heights(932731 + x + x_offset, 556238 + y + y_offset) * 8;
                            return;
                        }
                        this.vertex_heights[plane][x][y] = this.vertex_heights[plane - 1][x][y] - 240;
                        return;
                    }
                    if (index2 == 1) {
                        int height = buffer.readUnsignedByte();
                        if (height == 1) {
                            height = 0;
                        }
                        if (plane == 0) {
                            this.vertex_heights[0][x][y] = -height * 8;
                            return;
                        }
                        this.vertex_heights[plane][x][y] = this.vertex_heights[plane - 1][x][y] - height * 8;
                        return;
                    }
                    if (index2 <= 49) {
                        this.overlays[plane][x][y] = buffer.readSignedByte();
                        this.overlayTypes[plane][x][y] = (byte)((index2 - 2) / 4);
                        this.overlayOrientations[plane][x][y] = (byte)(index2 - 2 + orientation & 3);
                        continue;
                    }
                    if (index2 <= 81) {
                        this.tile_flags[plane][x][y] = (byte)(index2 - 49);
                        continue;
                    }
                    this.underlays[plane][x][y] = (byte)(index2 - 81);
                }
            }
            while ((index = buffer.readUnsignedByte()) != 0) {
                if (index == 1) {
                    buffer.readUnsignedByte();
                    return;
                }
                if (index > 49) continue;
                buffer.readUnsignedByte();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private int get_visibility(int y, int z, int x) {
        if ((this.tile_flags[z][x][y] & 8) != 0) {
            return 0;
        }
        if (z > 0 && (this.tile_flags[1][x][y] & 2) != 0) {
            return z - 1;
        }
        return z;
    }

    public final void load_sub_object_block(CollisionMap[] map, SceneGraph scene, int sub_plane, int x_offset, int height, int l, byte[] abyte0, int width, int rotation, int y_offset) {
        int offset;
        Buffer stream = new Buffer(abyte0);
        int object_id = -1;
        while ((offset = stream.readUSmart2()) != 0) {
            int pos_offset;
            object_id += offset;
            int pos = 0;
            while ((pos_offset = stream.readUSmart()) != 0) {
                int region_y = (pos += pos_offset - 1) & 0x3F;
                int region_x = pos >> 6 & 0x3F;
                int plane = pos >> 12;
                int hash = stream.readUnsignedByte();
                int type2 = hash >> 2;
                int orientation = hash & 3;
                if (plane != sub_plane || region_x < width || region_x >= width + 8 || region_y < height || region_y >= height + 8) continue;
                ObjectDefinition def = ObjectDefinition.get(object_id);
                int x = x_offset + ChunkUtil.get_rotated_landscape_x(rotation, def.height, region_x & 7, region_y & 7, def.width);
                int y = y_offset + ChunkUtil.get_rotated_landscape_y(region_y & 7, def.height, rotation, def.width, region_x & 7);
                if (x <= 0 || y <= 0 || x >= 103 || y >= 103) continue;
                int marking_plane = plane;
                if ((this.tile_flags[1][x][y] & 2) == 2) {
                    --marking_plane;
                }
                CollisionMap collision = null;
                if (marking_plane >= 0) {
                    collision = map[marking_plane];
                }
                this.render(y, scene, collision, type2, l, x, object_id, orientation + rotation & 3);
            }
        }
    }

    private static int interpolate(int a, int b, int angle, int frequencyReciprocal) {
        int cosine = 65536 - Rasterizer3D.COSINE[angle * 1024 / frequencyReciprocal] >> 1;
        return (a * (65536 - cosine) >> 16) + (b * cosine >> 16);
    }

    private int encode_hsl(int h2, int s2, int l) {
        if (l > 179) {
            s2 /= 2;
        }
        if (l > 192) {
            s2 /= 2;
        }
        if (l > 217) {
            s2 /= 2;
        }
        if (l > 243) {
            s2 /= 2;
        }
        return (h2 / 4 << 10) + (s2 / 32 << 7) + l / 2;
    }

    private static int encode_hsl(int hsl, int light) {
        if (hsl == -1) {
            return 12345678;
        }
        if ((light = light * (hsl & 0x7F) / 128) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (hsl & 0xFF80) + light;
    }

    private int encode_signed_hsl(int hsl, int light) {
        if (hsl == -2) {
            return 12345678;
        }
        if (hsl == -1) {
            if (light < 0) {
                light = 0;
            } else if (light > 127) {
                light = 127;
            }
            light = 127 - light;
            return light;
        }
        if ((light = light * (hsl & 0x7F) / 128) < 2) {
            light = 2;
        } else if (light > 126) {
            light = 126;
        }
        return (hsl & 0xFF80) + light;
    }

    static final int set_hsl_bitset(int h2, int s2, int l) {
        if (l > 179) {
            s2 /= 2;
        }
        if (l > 192) {
            s2 /= 2;
        }
        if (l > 217) {
            s2 /= 2;
        }
        if (l > 243) {
            s2 /= 2;
        }
        int hsl = (s2 / 32 << 7) + (h2 / 4 << 10) + l / 2;
        return hsl;
    }

    private static int smooth(int x, int y) {
        int corners = MapRegion.perlin(x - 1, y - 1) + MapRegion.perlin(x + 1, y - 1) + MapRegion.perlin(x - 1, y + 1) + MapRegion.perlin(x + 1, y + 1);
        int sides = MapRegion.perlin(x - 1, y) + MapRegion.perlin(x + 1, y) + MapRegion.perlin(x, y - 1) + MapRegion.perlin(x, y + 1);
        int center = MapRegion.perlin(x, y);
        return corners / 16 + sides / 8 + center / 4;
    }

    public static void place(SceneGraph scene, int orientation, int y, int type2, int plane, CollisionMap collision, int[][][] vertex_heights, int x, int object_id, int z) {
        int obj_y_factor_a;
        int obj_y_factor_b;
        int obj_x_factor_a;
        int obj_x_factor_b;
        int obj_size_offset_b;
        int obj_size_offset_a;
        ObjectDefinition def = ObjectDefinition.get(object_id);
        if (orientation == 1 || orientation == 3) {
            obj_size_offset_a = def.height;
            obj_size_offset_b = def.width;
        } else {
            obj_size_offset_a = def.width;
            obj_size_offset_b = def.height;
        }
        if (104 >= obj_size_offset_a + x) {
            obj_x_factor_b = x + (obj_size_offset_a + 1 >> 1);
            obj_x_factor_a = x + (obj_size_offset_a >> 1);
        } else {
            obj_x_factor_a = x;
            obj_x_factor_b = x + 1;
        }
        if (104 >= obj_size_offset_b + y) {
            obj_y_factor_b = y + (obj_size_offset_b + 1 >> 1);
            obj_y_factor_a = (obj_size_offset_b >> 1) + y;
        } else {
            obj_y_factor_a = y;
            obj_y_factor_b = 1 + y;
        }
        int v_sw = vertex_heights[plane][obj_x_factor_a][obj_y_factor_a];
        int v_se = vertex_heights[plane][obj_x_factor_b][obj_y_factor_a];
        int v_ne = vertex_heights[plane][obj_x_factor_b][obj_y_factor_b];
        int v_nw = vertex_heights[plane][obj_x_factor_a][obj_y_factor_b];
        int avg = v_sw + v_se + v_ne + v_nw >> 2;
        long key = orientation << 20 | type2 << 14 | (y << 7 | x) + 0x40000000;
        if (def.wallOrDoor == 0) {
            key |= Long.MIN_VALUE;
        }
        if (def.supportsItems == 1) {
            key |= 0x400000L;
        }
        key |= (long)object_id << 32;
        if (type2 == 22) {
            Renderable ground_map_scene_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(22, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 22, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_ground_decor(z, avg, y, ground_map_scene_decor, key, x);
            if (def.interactType == 1) {
                collision.setBlockedByFloor(x, y);
            }
            return;
        }
        if (type2 == 10 || type2 == 11) {
            Renderable scecne_object = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(10, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 10, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            if (scecne_object != null) {
                int size_offset_b;
                int size_offset_a;
                int rotation = 0;
                if (type2 == 11) {
                    rotation += 256;
                }
                if (orientation == 1 || orientation == 3) {
                    size_offset_a = def.height;
                    size_offset_b = def.width;
                } else {
                    size_offset_a = def.width;
                    size_offset_b = def.height;
                }
                scene.add_entity(key, avg, size_offset_b, scecne_object, size_offset_a, z, rotation, y, x);
            }
            if (def.interactType != 0 && collision != null) {
                collision.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (type2 >= 12) {
            Renderable roofs = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(type2, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, type2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_entity(key, avg, 1, roofs, 1, z, 0, y, x);
            if (def.interactType != 0 && collision != null) {
                collision.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 0) {
            Renderable straight_wall = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(0, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 0, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_corner_orientations[orientation], straight_wall, key, y, x, null, avg, 0, z);
            if (def.interactType != 0 && collision != null) {
                collision.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 1) {
            Renderable diagonal_wall_connector = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(1, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 1, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_orientations[orientation], diagonal_wall_connector, key, y, x, null, avg, 0, z);
            if (def.interactType != 0 && collision != null) {
                collision.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 2) {
            Renderable corner;
            Renderable wall;
            int orientation_offset = orientation + 1 & 3;
            if (def.animationID == -1 && def.configChangeDest == null) {
                wall = def.modelAt(2, 4 + orientation, v_sw, v_se, v_ne, v_nw, -1);
                corner = def.modelAt(2, orientation_offset, v_sw, v_se, v_ne, v_nw, -1);
            } else {
                wall = new SceneObject(object_id, 4 + orientation, 2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
                corner = new SceneObject(object_id, orientation_offset, 2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            }
            scene.add_wall(wall_corner_orientations[orientation], wall, key, y, x, corner, avg, wall_corner_orientations[orientation_offset], z);
            if (def.interactType != 0 && collision != null) {
                collision.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 3) {
            Renderable straight_corner_connector = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(3, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, 3, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall(wall_orientations[orientation], straight_corner_connector, key, y, x, null, avg, 0, z);
            if (def.interactType != 0) {
                collision.removeWallObstruction(x, y, type2, orientation, def.blocksProjectile);
            }
            return;
        }
        if (type2 == 9) {
            Renderable diagonal_walls = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(type2, orientation, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, orientation, type2, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_entity(key, avg, 1, diagonal_walls, 1, z, 0, y, x);
            if (def.interactType != 0 && collision != null) {
                collision.addGameObject(x, y, def.width, def.height, def.blocksProjectile);
            }
            return;
        }
        if (def.contouredGround) {
            int pos;
            if (orientation == 1) {
                pos = v_nw;
                v_nw = v_ne;
                v_ne = v_se;
                v_se = v_sw;
                v_sw = pos;
            } else if (orientation == 2) {
                int l3 = v_nw;
                v_nw = v_se;
                v_se = l3;
                l3 = v_ne;
                v_ne = v_sw;
                v_sw = l3;
            } else if (orientation == 3) {
                pos = v_nw;
                v_nw = v_sw;
                v_sw = v_se;
                v_se = v_ne;
                v_ne = pos;
            }
        }
        if (type2 == 4) {
            Renderable straight_inner_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation * 512, z, 0, avg, straight_inner_decor, x, 0, wall_corner_orientations[orientation]);
            return;
        }
        if (type2 == 5) {
            int offset = 16;
            long wall_uid = scene.get_wall_uid(z, x, y);
            if (wall_uid > 0L) {
                offset = ObjectDefinition.get((int)((int)(wall_uid >>> 32) & Integer.MAX_VALUE)).decorDisplacement;
            }
            Renderable outer_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation * 512, z, decor_x_offsets[orientation] * offset, avg, outer_wall_decor, x, decor_y_offsets[orientation] * offset, wall_corner_orientations[orientation]);
            return;
        }
        if (type2 == 6) {
            Renderable outer_diagonal_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, z, 0, avg, outer_diagonal_wall_decor, x, 0, 256);
            return;
        }
        if (type2 == 7) {
            Renderable inner_diagonal_wall_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, z, 0, avg, inner_diagonal_wall_decor, x, 0, 512);
            return;
        }
        if (type2 == 8) {
            Renderable diagonal_window_decor = def.animationID == -1 && def.configChangeDest == null ? def.modelAt(4, 0, v_sw, v_se, v_ne, v_nw, -1) : new SceneObject(object_id, 0, 4, v_se, v_ne, v_sw, v_nw, def.animationID, true);
            scene.add_wall_decor(key, y, orientation, z, 0, avg, diagonal_window_decor, x, 0, 768);
        }
    }

    public static boolean cached(int region_x, byte[] data2, int region_y) {
        int id_increment;
        boolean cached = true;
        Buffer buffer = new Buffer(data2);
        int object_id = -1;
        block0: while ((id_increment = buffer.getUIncrementalSmart()) != 0) {
            object_id += id_increment;
            int pos = 0;
            boolean read_second = false;
            while (true) {
                if (read_second) {
                    int second = buffer.readUSmart();
                    if (second == 0) continue block0;
                    buffer.readUnsignedByte();
                    continue;
                }
                int pos_offset = buffer.readUSmart();
                if (pos_offset == 0) continue block0;
                int region_y_offset = (pos += pos_offset - 1) & 0x3F;
                int region_x_offset = pos >> 6 & 0x3F;
                int obj_type = buffer.readUnsignedByte() >> 2;
                int x = region_x_offset + region_x;
                int y = region_y_offset + region_y;
                if (x <= 0 || y <= 0 || x >= 103 || y >= 103) continue;
                ObjectDefinition def = ObjectDefinition.get(object_id);
                if (obj_type == 22 && low_detail && def.wallOrDoor == 0 && def.interactType != 1 && !def.obstructsGround) continue;
                cached &= def.cached();
                read_second = true;
            }
        }
        return cached;
    }

    public final void load(int block_x, CollisionMap[] map, int block_y, SceneGraph scene, byte[] data2) {
        int id_offset;
        Buffer buffer = new Buffer(data2);
        int object_id = -1;
        while ((id_offset = buffer.readUnsignedIntSmartShortCompat()) != 0) {
            int pos_offset;
            object_id += id_offset;
            int pos = 0;
            while ((pos_offset = buffer.readUSmart()) != 0) {
                int tile_y = (pos += pos_offset - 1) & 0x3F;
                int tile_x = pos >> 6 & 0x3F;
                int plane = pos >> 12;
                int hash = buffer.readUnsignedByte();
                int type2 = hash >> 2;
                int orientation = hash & 3;
                int x = tile_x + block_x;
                int y = tile_y + block_y;
                if (x <= 0 || y <= 0 || x >= 103 || y >= 103 || plane < 0 || plane >= 4) continue;
                int marking_plane = plane;
                if ((this.tile_flags[1][x][y] & 2) == 2) {
                    --marking_plane;
                }
                CollisionMap collision = null;
                if (marking_plane >= 0) {
                    collision = map[marking_plane];
                }
                this.render(y, scene, collision, type2, plane, x, object_id, orientation);
            }
        }
    }

    static {
        decor_x_offsets = new int[]{1, 0, -1, 0};
        wall_orientations = new int[]{16, 32, 64, 128};
        decor_y_offsets = new int[]{0, -1, 0, 1};
        min_plane = 99;
        low_detail = true;
        wall_corner_orientations = new int[]{1, 2, 4, 8};
    }
}

