/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.scene;

import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.anim.SpotAnimation;
import com.hazy.entity.Renderable;
import com.hazy.entity.model.Model;

public final class Projectile
extends Renderable {
    public final int delay;
    public final int cycle_limit;
    private double vector_speed_x;
    private double vector_speed_y;
    private double momentum_scalar;
    private double vector_speed_z;
    private double height_offset;
    private boolean traveling;
    private final int start_x;
    private final int start_y;
    private final int start_z;
    public final int end_z;
    public double current_x;
    public double current_y;
    public double current_height;
    private final int slope_start;
    private final int distance;
    public final int target_id;
    private final SeqDefinition sequenceDefinition;
    private int flow;
    private int duration;
    public int jaw;
    private int pitch;
    public final int plane;
    public final int id;

    public void track(int cycle, int target_y, int k, int target_x) {
        if (!this.traveling) {
            double vector_x = target_x - this.start_x;
            double vector_y = target_y - this.start_y;
            double scalar = Math.sqrt(vector_x * vector_x + vector_y * vector_y);
            this.current_x = (double)this.start_x + vector_x * (double)this.distance / scalar;
            this.current_y = (double)this.start_y + vector_y * (double)this.distance / scalar;
            this.current_height = this.start_z;
        }
        double remaining = this.cycle_limit + 1 - cycle;
        this.vector_speed_x = ((double)target_x - this.current_x) / remaining;
        this.vector_speed_y = ((double)target_y - this.current_y) / remaining;
        this.momentum_scalar = Math.sqrt(this.vector_speed_x * this.vector_speed_x + this.vector_speed_y * this.vector_speed_y);
        if (!this.traveling) {
            this.vector_speed_z = -this.momentum_scalar * Math.tan((double)this.slope_start * 0.02454369);
        }
        this.height_offset = 2.0 * ((double)k - this.current_height - this.vector_speed_z * remaining) / (remaining * remaining);
    }

    @Override
    public Model get_rotated_model() {
        SpotAnimation animation = SpotAnimation.spotAnims[this.id];
        if (animation == null) {
            return null;
        }
        Model model = animation.get_model();
        if (model == null) {
            return null;
        }
        Model animated_model = new Model(true, true, false, model);
        if (this.sequenceDefinition != null && this.sequenceDefinition.primaryFrameIds != null) {
            int totalFrames = this.sequenceDefinition.primaryFrameIds.length;
            if (this.flow < 0 || this.flow >= totalFrames) {
                System.err.println("[Projectile Debug] Flow index out of bounds: gfx=" + this.id + " seq=" + this.sequenceDefinition.animId + " flow=" + this.flow + " frameCount=" + totalFrames);
                return animated_model;
            }
            int frame = this.sequenceDefinition.primaryFrameIds[this.flow];
            if (frame == -1) {
                System.err.println("[Projectile Debug] Invalid frame=-1 for gfx=" + this.id + " seq=" + this.sequenceDefinition.animId);
            } else {
                try {
                    if (this.sequenceDefinition.isSkeletalAnimation()) {
                        animated_model.playSkeletal(this.sequenceDefinition, frame);
                    } else {
                        animated_model.generateBones();
                        animated_model.interpolate(frame);
                    }
                }
                catch (Exception e) {
                    System.err.println("[Projectile Debug] Exception while animating gfx=" + this.id + " seq=" + this.sequenceDefinition.animId + " frame=" + frame + " -> " + String.valueOf(e));
                }
            }
            animated_model.faceGroups = null;
            animated_model.groupedTriangleLabels = null;
        }
        if (animation.model_scale_x != 128 || animation.model_scale_y != 128) {
            animated_model.scale(animation.model_scale_x, animation.model_scale_y, animation.model_scale_x);
        }
        animated_model.leanOverX(this.pitch);
        animated_model.light(64 + animation.ambient, 850 + animation.contrast, -30, -50, -30, true);
        return animated_model;
    }

    public Projectile(int slope_start, int end_z, int delay, int cycle_limit, int distance, int plane, int start_z, int start_y, int start_x, int target_id, int id) {
        this.target_id = target_id;
        this.id = id;
        SeqDefinition sequence = SpotAnimation.spotAnims[id].seq;
        this.sequenceDefinition = sequence != null ? SeqDefinition.get(sequence.animId) : null;
        this.plane = plane;
        this.start_x = start_x;
        this.start_y = start_y;
        this.start_z = start_z;
        this.delay = delay;
        this.cycle_limit = cycle_limit;
        this.slope_start = slope_start;
        this.distance = distance;
        this.end_z = end_z;
        this.traveling = false;
    }

    public void travel(int step) {
        this.traveling = true;
        this.current_x += this.vector_speed_x * (double)step;
        this.current_y += this.vector_speed_y * (double)step;
        this.current_height += this.vector_speed_z * (double)step + 0.5 * this.height_offset * (double)step * (double)step;
        this.vector_speed_z += this.height_offset * (double)step;
        this.jaw = (int)(Math.atan2(this.vector_speed_x, this.vector_speed_y) * 325.949) + 1024 & 0x7FF;
        this.pitch = (int)(Math.atan2(this.vector_speed_z, this.momentum_scalar) * 325.949) & 0x7FF;
        if (this.sequenceDefinition != null) {
            this.duration += step;
            while (this.duration > this.sequenceDefinition.duration(this.flow)) {
                this.duration -= this.sequenceDefinition.duration(this.flow) + 1;
                ++this.flow;
                if (this.flow < this.sequenceDefinition.primaryFrameIds.length) continue;
                this.flow = 0;
            }
        }
    }
}

