/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.scene;

import com.hazy.Client;
import com.hazy.cache.anim.SeqDefinition;
import com.hazy.cache.config.VariableBits;
import com.hazy.cache.def.ObjectDefinition;
import com.hazy.entity.Renderable;
import com.hazy.entity.model.Model;
import net.runelite.api.DynamicObject;

public final class SceneObject
extends Renderable
implements DynamicObject {
    private int animation_frame;
    private final int[] configs;
    private final int varbit_id;
    private final int config_id;
    private final int cos_y;
    private final int sin_y;
    private final int cos_x;
    private final int sin_x;
    private SeqDefinition seq;
    private int cycle_delay;
    private final int object_id;
    private final int click_type;
    private final int orientation;

    private ObjectDefinition get_configs() {
        int index = -1;
        if (this.varbit_id != -1) {
            try {
                VariableBits varBit = VariableBits.cache[this.varbit_id];
                int setting = varBit.configId;
                int low_varbit = varBit.leastSignificantBit;
                int high_varbit = varBit.mostSignificantBit;
                int bit_mask = Client.BIT_MASKS[high_varbit - low_varbit];
                index = Client.instance.settings[setting] >> low_varbit & bit_mask;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (this.config_id != -1 && this.config_id < Client.instance.settings.length) {
            index = Client.instance.settings[this.config_id];
        }
        int var = index >= 0 && index < this.configs.length ? this.configs[index] : this.configs[this.configs.length - 1];
        return var != -1 ? ObjectDefinition.get(var) : null;
    }

    @Override
    public Model get_rotated_model() {
        ObjectDefinition def;
        int animation_id = -1;
        if (this.seq != null) {
            if (this.seq.isSkeletalAnimation()) {
                int length = this.seq.getSkeletalLength();
                ++this.animation_frame;
                if (this.animation_frame >= length) {
                    this.seq = null;
                }
                if (this.seq != null) {
                    animation_id = this.seq.getSkeletalId();
                }
            } else {
                int step = Client.tick - this.cycle_delay;
                if (step > 100 && this.seq.getFrameStep() > 0) {
                    step = 100;
                }
                while (step > this.seq.duration(this.animation_frame)) {
                    step -= this.seq.duration(this.animation_frame);
                    ++this.animation_frame;
                    if (this.animation_frame < this.seq.getFrameCount()) continue;
                    this.animation_frame -= this.seq.getFrameStep();
                    if (this.animation_frame >= 0 && this.animation_frame < this.seq.getFrameCount()) continue;
                    this.seq = null;
                    break;
                }
                this.cycle_delay = Client.tick - step;
                if (this.seq != null) {
                    animation_id = this.seq.isSkeletalAnimation() ? this.seq.getSkeletalId() : this.seq.getPrimaryFrameIds()[this.animation_frame];
                }
            }
        }
        if ((def = this.configs != null ? this.get_configs() : ObjectDefinition.get(this.object_id)) == null) {
            return null;
        }
        return def.modelAt(this.click_type, this.orientation, this.cos_y, this.sin_y, this.cos_x, this.sin_x, animation_id);
    }

    public SceneObject(int id, int orientation, int click_type, int sin_y, int cos_x, int cos_y, int sin_x, int animation_id, boolean flag) {
        this.object_id = id;
        this.click_type = click_type;
        this.orientation = orientation;
        this.cos_y = cos_y;
        this.sin_y = sin_y;
        this.cos_x = cos_x;
        this.sin_x = sin_x;
        if (animation_id != -1) {
            this.seq = SeqDefinition.get(animation_id);
            this.animation_frame = 0;
            this.cycle_delay = Client.tick;
            if (flag && this.seq.frameStep != -1) {
                this.animation_frame = (int)(Math.random() * (double)this.seq.frameCount);
                this.cycle_delay -= (int)(Math.random() * (double)this.seq.duration(this.animation_frame));
            }
        }
        ObjectDefinition def = ObjectDefinition.get(this.object_id);
        this.varbit_id = def.varbitID;
        this.config_id = def.varpID;
        this.configs = def.configChangeDest;
    }

    @Override
    public int getAnimationID() {
        return this.seq.animId;
    }

    @Override
    public int getAnimFrame() {
        return this.animation_frame;
    }

    @Override
    public int getAnimCycleCount() {
        return this.cycle_delay;
    }
}

