/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.scene;

import com.hazy.cache.anim.SeqFrame;
import com.hazy.cache.anim.SpotAnimation;
import com.hazy.entity.Renderable;
import com.hazy.entity.model.Model;

public final class StaticObject
extends Renderable {
    public final int z;
    public final int x;
    public final int y;
    public final int height;
    public int cycle;
    public boolean expired;
    private final SpotAnimation graphics;
    private int flow;
    private int duration;

    public StaticObject(int z, int cycle, int offset, int id, int height, int y, int x) {
        this.graphics = SpotAnimation.spotAnims[id];
        this.z = z;
        this.x = x;
        this.y = y;
        this.height = height;
        this.cycle = cycle + offset;
        this.expired = false;
    }

    @Override
    public Model get_rotated_model() {
        Model model = this.graphics.get_model();
        if (model == null) {
            return null;
        }
        int frame = this.graphics.seq.primaryFrameIds[this.flow];
        Model animated_model = new Model(true, SeqFrame.noAnimationInProgress(frame), false, model);
        if (!this.expired) {
            animated_model.generateBones();
            animated_model.interpolate(frame);
            animated_model.faceGroups = null;
            animated_model.groupedTriangleLabels = null;
        }
        if (this.graphics.model_scale_x != 128 || this.graphics.model_scale_y != 128) {
            animated_model.scale(this.graphics.model_scale_x, this.graphics.model_scale_x, this.graphics.model_scale_y);
        }
        if (this.graphics.rotation != 0) {
            if (this.graphics.rotation == 90) {
                animated_model.rotate_90();
            }
            if (this.graphics.rotation == 180) {
                animated_model.rotate_90();
                animated_model.rotate_90();
            }
            if (this.graphics.rotation == 270) {
                animated_model.rotate_90();
                animated_model.rotate_90();
                animated_model.rotate_90();
            }
        }
        animated_model.light(64 + this.graphics.ambient, 850 + this.graphics.contrast, -30, -50, -30, true);
        return animated_model;
    }

    public void step(int length) {
        this.duration += length;
        while (this.duration > this.graphics.seq.duration(this.flow)) {
            this.duration -= this.graphics.seq.duration(this.flow) + 1;
            ++this.flow;
            if (this.flow < this.graphics.seq.frameCount || this.flow >= 0 && this.flow < this.graphics.seq.frameCount) continue;
            this.flow = 0;
            this.expired = true;
        }
    }
}

