/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.scene.object.tile;

import com.hazy.Client;
import com.hazy.collection.Node;
import com.hazy.entity.GroundItem;
import com.hazy.entity.InteractiveObject;
import com.hazy.scene.object.GroundDecoration;
import com.hazy.scene.object.Wall;
import com.hazy.scene.object.WallDecoration;
import com.hazy.scene.object.tile.ShapedTile;
import com.hazy.scene.object.tile.SimpleTile;
import java.util.ArrayList;
import java.util.List;
import net.runelite.api.DecorativeObject;
import net.runelite.api.GameObject;
import net.runelite.api.GroundObject;
import net.runelite.api.ItemLayer;
import net.runelite.api.Point;
import net.runelite.api.SceneTilePaint;
import net.runelite.api.TileItem;
import net.runelite.api.WallObject;
import net.runelite.api.coords.LocalPoint;
import net.runelite.api.coords.WorldPoint;
import net.runelite.api.events.DecorativeObjectChanged;
import net.runelite.api.events.DecorativeObjectDespawned;
import net.runelite.api.events.DecorativeObjectSpawned;
import net.runelite.api.events.GameObjectChanged;
import net.runelite.api.events.GameObjectDespawned;
import net.runelite.api.events.GameObjectSpawned;
import net.runelite.api.events.GroundObjectChanged;
import net.runelite.api.events.GroundObjectDespawned;
import net.runelite.api.events.GroundObjectSpawned;
import net.runelite.api.events.WallObjectChanged;
import net.runelite.api.events.WallObjectDespawned;
import net.runelite.api.events.WallObjectSpawned;
import net.runelite.rs.api.RSActor;
import net.runelite.rs.api.RSBoundaryObject;
import net.runelite.rs.api.RSCollisionMap;
import net.runelite.rs.api.RSFloorDecoration;
import net.runelite.rs.api.RSGameObject;
import net.runelite.rs.api.RSGraphicsObject;
import net.runelite.rs.api.RSProjectile;
import net.runelite.rs.api.RSRenderable;
import net.runelite.rs.api.RSSceneTileModel;
import net.runelite.rs.api.RSSceneTilePaint;
import net.runelite.rs.api.RSTile;
import net.runelite.rs.api.RSTileItem;
import net.runelite.rs.api.RSWallDecoration;
import org.slf4j.Logger;

public final class Tile
extends Node
implements RSTile {
    public int z1AnInt1307;
    public final int anInt1308;
    public final int anInt1309;
    public final int anInt1310;
    public SimpleTile mySimpleTile;
    public ShapedTile myShapedTile;
    public Wall wallObject;
    public WallDecoration wallDecoration;
    public GroundDecoration groundDecoration;
    public GroundItem groundItemTile;
    public int gameObjectIndex;
    public final InteractiveObject[] gameObjects = new InteractiveObject[5];
    public final int[] tiledObjectMasks = new int[5];
    public int totalTiledObjectMask;
    public int logicHeight;
    public boolean aBoolean1322;
    public boolean aBoolean1323;
    public boolean aBoolean1324;
    public int wallCullDirection;
    public int anInt1326;
    public int anInt1327;
    public int anInt1328;
    public Tile firstFloorTile;
    private RSGameObject[] previousGameObjects;
    private WallObject previousWallObject;
    private DecorativeObject previousDecorativeObject;
    private GroundObject previousGroundObject;
    public boolean isBridge = false;

    public Tile(int z, int x, int y) {
        this.anInt1310 = this.z1AnInt1307 = z;
        this.anInt1308 = x;
        this.anInt1309 = y;
    }

    @Override
    public Point getSceneLocation() {
        return new Point(this.anInt1308, this.anInt1309);
    }

    @Override
    public boolean hasLineOfSightTo(net.runelite.api.Tile other) {
        if (this.getPlane() != other.getPlane()) {
            return false;
        }
        RSCollisionMap[] collisionData = Client.instance.getCollisionMaps();
        if (collisionData == null) {
            return false;
        }
        int z = this.getPlane();
        int[][] collisionDataFlags = collisionData[z].getFlags();
        Point p1 = this.getSceneLocation();
        Point p2 = other.getSceneLocation();
        if (p1.getX() == p2.getX() && p1.getY() == p2.getY()) {
            return true;
        }
        int dx = p2.getX() - p1.getX();
        int dy = p2.getY() - p1.getY();
        int dxAbs = Math.abs(dx);
        int dyAbs = Math.abs(dy);
        int xFlags = 131072;
        int yFlags = 131072;
        xFlags = dx < 0 ? (xFlags |= 0x1000) : (xFlags |= 0x10000);
        yFlags = dy < 0 ? (yFlags |= 0x400) : (yFlags |= 0x4000);
        if (dxAbs > dyAbs) {
            int direction;
            int x = p1.getX();
            int yBig = p1.getY() << 16;
            int slope = (dy << 16) / dxAbs;
            yBig += 32768;
            if (dy < 0) {
                --yBig;
            }
            int n = direction = dx < 0 ? -1 : 1;
            while (x != p2.getX()) {
                int y = yBig >>> 16;
                if ((collisionDataFlags[x += direction][y] & xFlags) != 0) {
                    return false;
                }
                int nextY = (yBig += slope) >>> 16;
                if (nextY == y || (collisionDataFlags[x][nextY] & yFlags) == 0) continue;
                return false;
            }
        } else {
            int direction;
            int y = p1.getY();
            int xBig = p1.getX() << 16;
            int slope = (dx << 16) / dyAbs;
            xBig += 32768;
            if (dx < 0) {
                --xBig;
            }
            int n = direction = dy < 0 ? -1 : 1;
            while (y != p2.getY()) {
                int x = xBig >>> 16;
                if ((collisionDataFlags[x][y += direction] & yFlags) != 0) {
                    return false;
                }
                int nextX = (xBig += slope) >>> 16;
                if (nextX == x || (collisionDataFlags[nextX][y] & xFlags) == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public List<net.runelite.api.Tile> pathTo(net.runelite.api.Tile other) {
        int directionOld;
        int z = this.getPlane();
        if (z != other.getPlane()) {
            return null;
        }
        RSCollisionMap[] collisionData = Client.instance.getCollisionMaps();
        if (collisionData == null) {
            return null;
        }
        int[][] directions = new int[128][128];
        int[][] distances = new int[128][128];
        int[] bufferX = new int[4096];
        int[] bufferY = new int[4096];
        for (int i = 0; i < 128; ++i) {
            for (int j = 0; j < 128; ++j) {
                directions[i][j] = 0;
                distances[i][j] = Integer.MAX_VALUE;
            }
        }
        Point p1 = this.getSceneLocation();
        Point p2 = other.getSceneLocation();
        int middleX = p1.getX();
        int middleY = p1.getY();
        int currentX = middleX;
        int currentY = middleY;
        int offsetX = 64;
        int offsetY = 64;
        directions[offsetX][offsetY] = 99;
        distances[offsetX][offsetY] = 0;
        int index1 = 0;
        bufferX[0] = currentX;
        int index2 = 1;
        bufferY[0] = currentY;
        int[][] collisionDataFlags = collisionData[z].getFlags();
        boolean isReachable = false;
        while (index1 != index2) {
            currentX = bufferX[index1];
            currentY = bufferY[index1];
            index1 = index1 + 1 & 0xFFF;
            int currentMapX = currentX - middleX + offsetX;
            int currentMapY = currentY - middleY + offsetY;
            if (currentX == p2.getX() && currentY == p2.getY()) {
                isReachable = true;
                break;
            }
            int currentDistance = distances[currentMapX][currentMapY] + 1;
            if (currentMapX > 0 && directions[currentMapX - 1][currentMapY] == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0) {
                bufferX[index2] = currentX - 1;
                bufferY[index2] = currentY;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX - 1][currentMapY] = 2;
                distances[currentMapX - 1][currentMapY] = currentDistance;
            }
            if (currentMapX < 127 && directions[currentMapX + 1][currentMapY] == 0 && (collisionDataFlags[currentX + 1][currentY] & 0x1240180) == 0) {
                bufferX[index2] = currentX + 1;
                bufferY[index2] = currentY;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX + 1][currentMapY] = 8;
                distances[currentMapX + 1][currentMapY] = currentDistance;
            }
            if (currentMapY > 0 && directions[currentMapX][currentMapY - 1] == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                bufferX[index2] = currentX;
                bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX][currentMapY - 1] = 1;
                distances[currentMapX][currentMapY - 1] = currentDistance;
            }
            if (currentMapY < 127 && directions[currentMapX][currentMapY + 1] == 0 && (collisionDataFlags[currentX][currentY + 1] & 0x1240120) == 0) {
                bufferX[index2] = currentX;
                bufferY[index2] = currentY + 1;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX][currentMapY + 1] = 4;
                distances[currentMapX][currentMapY + 1] = currentDistance;
            }
            if (currentMapX > 0 && currentMapY > 0 && directions[currentMapX - 1][currentMapY - 1] == 0 && (collisionDataFlags[currentX - 1][currentY - 1] & 0x124010E) == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                bufferX[index2] = currentX - 1;
                bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX - 1][currentMapY - 1] = 3;
                distances[currentMapX - 1][currentMapY - 1] = currentDistance;
            }
            if (currentMapX < 127 && currentMapY > 0 && directions[currentMapX + 1][currentMapY - 1] == 0 && (collisionDataFlags[currentX + 1][currentY - 1] & 0x1240183) == 0 && (collisionDataFlags[currentX + 1][currentY] & 0x1240180) == 0 && (collisionDataFlags[currentX][currentY - 1] & 0x1240102) == 0) {
                bufferX[index2] = currentX + 1;
                bufferY[index2] = currentY - 1;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX + 1][currentMapY - 1] = 9;
                distances[currentMapX + 1][currentMapY - 1] = currentDistance;
            }
            if (currentMapX > 0 && currentMapY < 127 && directions[currentMapX - 1][currentMapY + 1] == 0 && (collisionDataFlags[currentX - 1][currentY + 1] & 0x1240138) == 0 && (collisionDataFlags[currentX - 1][currentY] & 0x1240108) == 0 && (collisionDataFlags[currentX][currentY + 1] & 0x1240120) == 0) {
                bufferX[index2] = currentX - 1;
                bufferY[index2] = currentY + 1;
                index2 = index2 + 1 & 0xFFF;
                directions[currentMapX - 1][currentMapY + 1] = 6;
                distances[currentMapX - 1][currentMapY + 1] = currentDistance;
            }
            if (currentMapX >= 127 || currentMapY >= 127 || directions[currentMapX + 1][currentMapY + 1] != 0 || (collisionDataFlags[currentX + 1][currentY + 1] & 0x12401E0) != 0 || (collisionDataFlags[currentX + 1][currentY] & 0x1240180) != 0 || (collisionDataFlags[currentX][currentY + 1] & 0x1240120) != 0) continue;
            bufferX[index2] = currentX + 1;
            bufferY[index2] = currentY + 1;
            index2 = index2 + 1 & 0xFFF;
            directions[currentMapX + 1][currentMapY + 1] = 12;
            distances[currentMapX + 1][currentMapY + 1] = currentDistance;
        }
        if (!isReachable) {
            int upperboundDistance = Integer.MAX_VALUE;
            int pathLength = Integer.MAX_VALUE;
            int checkRange = 10;
            int approxDestinationX = p2.getX();
            int approxDestinationY = p2.getY();
            for (int i = approxDestinationX - checkRange; i <= checkRange + approxDestinationX; ++i) {
                for (int j = approxDestinationY - checkRange; j <= checkRange + approxDestinationY; ++j) {
                    int currentMapX = i - middleX + offsetX;
                    int currentMapY = j - middleY + offsetY;
                    if (currentMapX < 0 || currentMapY < 0 || currentMapX >= 128 || currentMapY >= 128 || distances[currentMapX][currentMapY] >= 100) continue;
                    int deltaX = 0;
                    if (i < approxDestinationX) {
                        deltaX = approxDestinationX - i;
                    } else if (i > approxDestinationX) {
                        deltaX = i - approxDestinationX;
                    }
                    int deltaY = 0;
                    if (j < approxDestinationY) {
                        deltaY = approxDestinationY - j;
                    } else if (j > approxDestinationY) {
                        deltaY = j - approxDestinationY;
                    }
                    int distanceSquared = deltaX * deltaX + deltaY * deltaY;
                    if (distanceSquared >= upperboundDistance && (distanceSquared != upperboundDistance || distances[currentMapX][currentMapY] >= pathLength)) continue;
                    upperboundDistance = distanceSquared;
                    pathLength = distances[currentMapX][currentMapY];
                    currentX = i;
                    currentY = j;
                }
            }
            if (upperboundDistance == Integer.MAX_VALUE) {
                return null;
            }
        }
        bufferX[0] = currentX;
        bufferY[0] = currentY;
        int index = 1;
        int directionNew = directionOld = directions[currentX - middleX + offsetX][currentY - middleY + offsetY];
        while (p1.getX() != currentX || p1.getY() != currentY) {
            if (directionNew != directionOld) {
                directionOld = directionNew;
                bufferX[index] = currentX;
                bufferY[index++] = currentY;
            }
            if ((directionNew & 2) != 0) {
                ++currentX;
            } else if ((directionNew & 8) != 0) {
                --currentX;
            }
            if ((directionNew & 1) != 0) {
                ++currentY;
            } else if ((directionNew & 4) != 0) {
                --currentY;
            }
            directionNew = directions[currentX - middleX + offsetX][currentY - middleY + offsetY];
        }
        int checkpointTileNumber = 1;
        Tile[][][] tiles = (Tile[][][])Client.instance.getScene().getTiles();
        ArrayList<net.runelite.api.Tile> checkpointTiles = new ArrayList<net.runelite.api.Tile>();
        while (index-- > 0) {
            checkpointTiles.add(tiles[this.getPlane()][bufferX[index]][bufferY[index]]);
            if (checkpointTileNumber == 25) break;
            ++checkpointTileNumber;
        }
        return checkpointTiles;
    }

    @Override
    public List<TileItem> getGroundItems() {
        ItemLayer layer = this.getItemLayer();
        if (layer == null) {
            return null;
        }
        ArrayList<TileItem> result2 = new ArrayList<TileItem>();
        net.runelite.api.Node node = layer.getBottom();
        while (node instanceof RSTileItem) {
            RSTileItem item = (RSTileItem)node;
            item.setX(this.getX());
            item.setY(this.getY());
            result2.add(item);
            node = node.getNext();
        }
        return result2;
    }

    @Override
    public WorldPoint getWorldLocation() {
        return WorldPoint.fromScene(Client.instance, this.getX(), this.getY(), this.getPlane());
    }

    @Override
    public LocalPoint getLocalLocation() {
        return LocalPoint.fromScene(this.getX(), this.getY());
    }

    @Override
    public GameObject[] getGameObjects() {
        return this.gameObjects;
    }

    @Override
    public ItemLayer getItemLayer() {
        return this.groundItemTile;
    }

    @Override
    public DecorativeObject getDecorativeObject() {
        return this.wallDecoration;
    }

    @Override
    public void setDecorativeObject(DecorativeObject object) {
    }

    @Override
    public GroundObject getGroundObject() {
        return this.groundDecoration;
    }

    @Override
    public void setGroundObject(GroundObject object) {
    }

    @Override
    public WallObject getWallObject() {
        return this.wallObject;
    }

    @Override
    public void setWallObject(WallObject object) {
    }

    @Override
    public RSSceneTilePaint getSceneTilePaint() {
        return this.mySimpleTile;
    }

    @Override
    public void setSceneTilePaint(SceneTilePaint paint) {
    }

    @Override
    public RSSceneTileModel getSceneTileModel() {
        return this.myShapedTile;
    }

    @Override
    public int getX() {
        return this.anInt1308;
    }

    @Override
    public int getY() {
        return this.anInt1309;
    }

    @Override
    public int getPlane() {
        return this.z1AnInt1307;
    }

    @Override
    public int getRenderLevel() {
        return this.isBridge ? this.anInt1310 + 1 : this.anInt1310;
    }

    @Override
    public int getPhysicalLevel() {
        return this.logicHeight;
    }

    @Override
    public int getFlags() {
        return this.totalTiledObjectMask;
    }

    @Override
    public RSTile getBridge() {
        return this.firstFloorTile;
    }

    @Override
    public boolean isDraw() {
        return this.aBoolean1322;
    }

    @Override
    public void setDraw(boolean draw) {
        this.aBoolean1322 = draw;
    }

    @Override
    public boolean isVisible() {
        return this.aBoolean1323;
    }

    @Override
    public void setVisible(boolean visible) {
        this.aBoolean1323 = visible;
    }

    @Override
    public void setDrawEntities(boolean drawEntities) {
        this.aBoolean1324 = drawEntities;
    }

    @Override
    public void setWallCullDirection(int wallCullDirection) {
        this.wallCullDirection = wallCullDirection;
    }

    public void gameObjectsChanged(int idx) {
        if (idx != -1) {
            RSRenderable renderable;
            RSGameObject current;
            if (this.previousGameObjects == null) {
                this.previousGameObjects = new RSGameObject[5];
            }
            RSGameObject previous = this.previousGameObjects[idx];
            this.previousGameObjects[idx] = current = (RSGameObject)this.getGameObjects()[idx];
            if (current == previous) {
                return;
            }
            boolean currentInvalid = false;
            boolean prevInvalid = false;
            if (current != null) {
                renderable = current.getRenderable();
                currentInvalid = renderable instanceof RSActor || renderable instanceof RSProjectile || renderable instanceof RSGraphicsObject;
                currentInvalid |= current.getStartX() != this.getX() || current.getStartY() != this.getY();
            }
            if (previous != null) {
                renderable = previous.getRenderable();
                prevInvalid = renderable instanceof RSActor || renderable instanceof RSProjectile || renderable instanceof RSGraphicsObject;
                prevInvalid |= previous.getStartX() != this.getX() || previous.getStartY() != this.getY();
            }
            Logger logger = Client.instance.getLogger();
            if (current == null) {
                if (prevInvalid) {
                    return;
                }
                logger.trace("Game object despawn: {}", (Object)previous.getId());
                GameObjectDespawned gameObjectDespawned = new GameObjectDespawned();
                gameObjectDespawned.setTile(this);
                gameObjectDespawned.setGameObject(previous);
                Client.instance.getCallbacks().post(gameObjectDespawned);
            } else if (previous == null) {
                if (currentInvalid) {
                    return;
                }
                logger.trace("Game object spawn: {}", (Object)current.getId());
                GameObjectSpawned gameObjectSpawned = new GameObjectSpawned();
                gameObjectSpawned.setTile(this);
                gameObjectSpawned.setGameObject(current);
                Client.instance.getCallbacks().post(gameObjectSpawned);
            } else {
                if (currentInvalid && prevInvalid) {
                    return;
                }
                logger.trace("Game object change: {} -> {}", (Object)previous.getId(), (Object)current.getId());
                GameObjectChanged gameObjectsChanged = new GameObjectChanged();
                gameObjectsChanged.setTile(this);
                gameObjectsChanged.setPrevious(previous);
                gameObjectsChanged.setGameObject(current);
                Client.instance.getCallbacks().post(gameObjectsChanged);
            }
        }
    }

    public void wallObjectChanged() {
        WallObject previous = this.previousWallObject;
        RSBoundaryObject current = (RSBoundaryObject)this.getWallObject();
        this.previousWallObject = current;
        if (current == null && previous != null) {
            WallObjectDespawned wallObjectDespawned = new WallObjectDespawned();
            wallObjectDespawned.setTile(this);
            wallObjectDespawned.setWallObject(previous);
            Client.instance.getCallbacks().post(wallObjectDespawned);
        } else if (current != null && previous == null) {
            WallObjectSpawned wallObjectSpawned = new WallObjectSpawned();
            wallObjectSpawned.setTile(this);
            wallObjectSpawned.setWallObject(current);
            Client.instance.getCallbacks().post(wallObjectSpawned);
        } else if (current != null) {
            WallObjectChanged wallObjectChanged = new WallObjectChanged();
            wallObjectChanged.setTile(this);
            wallObjectChanged.setPrevious(previous);
            wallObjectChanged.setWallObject(current);
            Client.instance.getCallbacks().post(wallObjectChanged);
        }
    }

    public void decorativeObjectChanged() {
        DecorativeObject previous = this.previousDecorativeObject;
        RSWallDecoration current = (RSWallDecoration)this.getDecorativeObject();
        this.previousDecorativeObject = current;
        if (current == null && previous != null) {
            DecorativeObjectDespawned decorativeObjectDespawned = new DecorativeObjectDespawned();
            decorativeObjectDespawned.setTile(this);
            decorativeObjectDespawned.setDecorativeObject(previous);
            Client.instance.getCallbacks().post(decorativeObjectDespawned);
        } else if (current != null && previous == null) {
            DecorativeObjectSpawned decorativeObjectSpawned = new DecorativeObjectSpawned();
            decorativeObjectSpawned.setTile(this);
            decorativeObjectSpawned.setDecorativeObject(current);
            Client.instance.getCallbacks().post(decorativeObjectSpawned);
        } else if (current != null) {
            DecorativeObjectChanged decorativeObjectChanged = new DecorativeObjectChanged();
            decorativeObjectChanged.setTile(this);
            decorativeObjectChanged.setPrevious(previous);
            decorativeObjectChanged.setDecorativeObject(current);
            Client.instance.getCallbacks().post(decorativeObjectChanged);
        }
    }

    public void groundObjectChanged() {
        GroundObject previous = this.previousGroundObject;
        RSFloorDecoration current = (RSFloorDecoration)this.getGroundObject();
        this.previousGroundObject = current;
        if (current == null && previous != null) {
            GroundObjectDespawned groundObjectDespawned = new GroundObjectDespawned();
            groundObjectDespawned.setTile(this);
            groundObjectDespawned.setGroundObject(previous);
            Client.instance.getCallbacks().post(groundObjectDespawned);
        } else if (current != null && previous == null) {
            GroundObjectSpawned groundObjectSpawned = new GroundObjectSpawned();
            groundObjectSpawned.setTile(this);
            groundObjectSpawned.setGroundObject(current);
            Client.instance.getCallbacks().post(groundObjectSpawned);
        } else if (current != null) {
            GroundObjectChanged groundObjectChanged = new GroundObjectChanged();
            groundObjectChanged.setTile(this);
            groundObjectChanged.setPrevious(previous);
            groundObjectChanged.setGroundObject(current);
            Client.instance.getCallbacks().post(groundObjectChanged);
        }
    }
}

