/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.sign;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.zip.GZIPInputStream;

public class CacheAudioScanner {
    public static void main(String[] args2) {
        String cacheDir = "C:\\Users\\tvlek\\hazy-swift\\cache";
        CacheAudioScanner.scanOldSchoolCache(cacheDir);
    }

    public static void scanOldSchoolCache(String cacheDir) {
        System.out.println("[Scanner] \ud83d\udd0d Starting JAGGRAB-style cache scan in: " + cacheDir);
        File datFile = new File(cacheDir, "main_file_cache.dat");
        if (!datFile.exists()) {
            System.err.println("[Scanner] \u274c Could not find main_file_cache.dat");
            return;
        }
        for (int idx = 0; idx <= 5; ++idx) {
            File idxFile = new File(cacheDir, "main_file_cache.idx" + idx);
            if (!idxFile.exists()) continue;
            try (RandomAccessFile dat = new RandomAccessFile(datFile, "r");
                 RandomAccessFile idxf = new RandomAccessFile(idxFile, "r");){
                int entries = (int)(idxf.length() / 6L);
                System.out.printf("[Scanner] \ud83d\uddc2\ufe0f Index %d \u2014 %d entries%n", idx, entries);
                for (int archiveId = 0; archiveId < entries; ++archiveId) {
                    byte[] data2;
                    idxf.seek(archiveId * 6);
                    int size = idxf.readUnsignedByte() << 16 | idxf.readUnsignedByte() << 8 | idxf.readUnsignedByte();
                    int sector = idxf.readUnsignedByte() << 16 | idxf.readUnsignedByte() << 8 | idxf.readUnsignedByte();
                    if (size <= 0 || sector <= 0 || (data2 = CacheAudioScanner.readFromDat(dat, sector, size, idx)) == null || data2.length == 0) continue;
                    System.out.printf("[Idx %d] File %d (%d bytes): ", idx, archiveId, size);
                    for (int i = 0; i < Math.min(16, data2.length); ++i) {
                        System.out.printf("%02X ", data2[i]);
                    }
                    System.out.println();
                    byte[] decompressed = CacheAudioScanner.tryDecompress(data2);
                    String type2 = CacheAudioScanner.identify(decompressed);
                    if (type2.equals("unknown")) continue;
                    System.out.printf("[Scanner] \u2705 Index %d / File %d \u2192 %s (%d bytes)%n", idx, archiveId, type2, decompressed.length);
                    File out = new File("found_idx" + idx + "_file" + archiveId + "." + type2);
                    try (FileOutputStream fos = new FileOutputStream(out);){
                        fos.write(decompressed);
                        continue;
                    }
                }
                continue;
            }
            catch (Exception e) {
                System.out.println("[Scanner] \u26a0\ufe0f Error reading index " + idx + ": " + e.getMessage());
            }
        }
        System.out.println("[Scanner] \u2705 Full scan complete!");
    }

    private static byte[] readFromDat(RandomAccessFile dat, int startSector, int size, int indexId) throws IOException {
        byte[] buffer = new byte[size];
        int read2 = 0;
        int sector = startSector;
        int part = 0;
        while (read2 < size) {
            dat.seek((long)sector * 520L);
            int archive = dat.readUnsignedShort();
            int chunk = dat.readUnsignedShort();
            int nextSector = dat.readUnsignedByte() << 16 | dat.readUnsignedByte() << 8 | dat.readUnsignedByte();
            int idx = dat.readUnsignedByte();
            if (idx != indexId) break;
            int remaining = size - read2;
            int blockSize = Math.min(remaining, 512);
            dat.readFully(buffer, read2, blockSize);
            read2 += blockSize;
            sector = nextSector;
            ++part;
            if (sector != 0) continue;
            break;
        }
        return buffer;
    }

    private static byte[] tryDecompress(byte[] input) {
        if (input.length < 2) {
            return input;
        }
        if (input[0] == 31 && input[1] == -117) {
            byte[] byArray;
            GZIPInputStream gzin = new GZIPInputStream(new ByteArrayInputStream(input));
            try {
                int len;
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                byte[] buf = new byte[4096];
                while ((len = gzin.read(buf)) > 0) {
                    baos.write(buf, 0, len);
                }
                byArray = baos.toByteArray();
            }
            catch (Throwable throwable) {
                try {
                    try {
                        gzin.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            gzin.close();
            return byArray;
        }
        return input;
    }

    private static String identify(byte[] data2) {
        if (data2 == null || data2.length < 4) {
            return "unknown";
        }
        if (data2[0] == 79 && data2[1] == 103 && data2[2] == 103 && data2[3] == 83) {
            return "ogg";
        }
        for (int i = 0; i < data2.length - 3; ++i) {
            if (data2[i] != 77 || data2[i + 1] != 84 || data2[i + 2] != 104 || data2[i + 3] != 100) continue;
            return "mid";
        }
        if (data2[0] == 82 && data2[1] == 73 && data2[2] == 70 && data2[3] == 70) {
            return "wav";
        }
        return "unknown";
    }
}

