/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.sign;

import com.hazy.Client;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.net.InetAddress;
import java.net.Socket;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Sequence;
import javax.sound.midi.Sequencer;
import javax.sound.midi.Synthesizer;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import net.runelite.client.RuneLite;

public final class SignLink
implements Runnable {
    public static final int clientversion = 317;
    public static int storeid = 32;
    public static RandomAccessFile cache_dat = null;
    public static final RandomAccessFile[] indices = new RandomAccessFile[5];
    public static boolean sunjava;
    private static boolean active;
    private static int threadLiveId;
    private static InetAddress socketAddress;
    private static int socketRequest;
    private static Socket socket;
    private static int threadreqpri;
    private static Runnable threadreq;
    private static String dnsreq;
    public static String dns;
    private static String urlRequest;
    private static DataInputStream urlStream;
    private static int savelen;
    private static String savereq;
    private static byte[] savebuf;
    private static boolean play;
    private static boolean waveplay;
    private static int wavepos;
    private static int midipos;
    public static String midi;
    public static int midiVolume;
    public static int fadeMidi;
    public static int wavevol;
    public static boolean reporterror;
    public static String errorName;
    public static Sequencer music;
    public static Sequence sequence;
    public static Synthesizer synthesizer;

    private SignLink() {
    }

    public static void startpriv(InetAddress inetaddress) {
        threadLiveId = (int)(Math.random() * 9.9999999E7);
        if (active) {
            try {
                Thread.sleep(500L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            active = false;
        }
        socketRequest = 0;
        threadreq = null;
        dnsreq = null;
        savereq = null;
        urlRequest = null;
        socketAddress = inetaddress;
        Thread thread2 = new Thread(new SignLink());
        thread2.setName("EldoriaSignLink");
        thread2.setDaemon(true);
        thread2.start();
        while (!active) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    @Override
    public void run() {
        active = true;
        String directory = SignLink.findCacheDir();
        try {
            cache_dat = new RandomAccessFile(directory + "main_file_cache.dat", "rw");
            for (int index = 0; index < 5; ++index) {
                SignLink.indices[index] = new RandomAccessFile(directory + "main_file_cache.idx" + index, "rw");
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        int currentId = threadLiveId;
        while (threadLiveId == currentId) {
            try {
                this.handleRequests(directory);
                Thread.sleep(50L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void handleRequests(String directory) {
        if (socketRequest != 0) {
            try {
                socket = new Socket(socketAddress, socketRequest);
            }
            catch (Exception ignored) {
                socket = null;
            }
            socketRequest = 0;
        } else if (threadreq != null) {
            Thread thread2 = new Thread(threadreq);
            thread2.setDaemon(true);
            thread2.setPriority(threadreqpri);
            thread2.start();
            threadreq = null;
        } else if (dnsreq != null) {
            try {
                dns = InetAddress.getByName(dnsreq).getHostName();
            }
            catch (Exception ignored) {
                dns = "unknown";
            }
            dnsreq = null;
        } else if (savereq != null) {
            this.handleSaveRequest(directory);
        } else if (urlRequest != null) {
            urlStream = null;
            urlRequest = null;
        }
    }

    private void handleSaveRequest(String directory) {
        if (savebuf != null) {
            try (FileOutputStream out = new FileOutputStream(directory + savereq);){
                out.write(savebuf, 0, savelen);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!Client.instance.toggle_music) {
            return;
        }
        if (waveplay) {
            waveplay = false;
            this.playWave(directory + savereq);
        }
        if (play) {
            play = false;
            midi = directory + savereq;
            this.playMidi(midi);
        }
        savereq = null;
        savebuf = null;
    }

    public static String findCacheDir() {
        return RuneLite.CACHE_DIR.getAbsolutePath() + "/";
    }

    public static String findDataDir() {
        File base = new File(System.getProperty("user.home") + "/.hazy/");
        base.mkdirs();
        File dataDir = new File(base, "data/");
        dataDir.mkdirs();
        return dataDir.getAbsolutePath() + "/";
    }

    public static String getCacheDirectory() {
        return SignLink.findCacheDir();
    }

    private void playMidi(String location) {
        SignLink.stopMidi();
        try {
            File midiFile = new File(location);
            sequence = MidiSystem.getSequence(midiFile);
            music = MidiSystem.getSequencer(false);
            synthesizer = MidiSystem.getSynthesizer();
            synthesizer.open();
            music.open();
            music.getTransmitter().setReceiver(synthesizer.getReceiver());
            music.setSequence(sequence);
            music.setLoopCount(-1);
            SignLink.setVolume(midiVolume);
            music.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void stopMidi() {
        try {
            if (music != null) {
                music.stop();
                music.close();
                music = null;
            }
            if (synthesizer != null) {
                synthesizer.close();
                synthesizer = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void setVolume(int value) {
        midiVolume = Math.max(0, Math.min(127, value));
        if (synthesizer == null) {
            return;
        }
        try {
            MidiChannel[] channels = synthesizer.getChannels();
            if (channels != null) {
                for (MidiChannel ch : channels) {
                    if (ch == null) continue;
                    ch.controlChange(7, midiVolume);
                    ch.controlChange(39, midiVolume);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void playWave(String path) {
        try (AudioInputStream in = AudioSystem.getAudioInputStream(new File(path));){
            AudioFormat format = in.getFormat();
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            try (SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);){
                int bytesRead;
                line.open(format);
                if (line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
                    FloatControl gainControl = (FloatControl)line.getControl(FloatControl.Type.MASTER_GAIN);
                    float range = gainControl.getMaximum() - gainControl.getMinimum();
                    float gainValue = gainControl.getMinimum() + range * ((float)wavevol / 100.0f);
                    gainControl.setValue(gainValue);
                }
                line.start();
                byte[] buffer = new byte[4096];
                while ((bytesRead = in.read(buffer)) != -1) {
                    line.write(buffer, 0, bytesRead);
                }
                line.drain();
                line.stop();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static synchronized boolean saveWave(byte[] data2, int length) {
        if (length > 2000000 || savereq != null) {
            return false;
        }
        wavepos = (wavepos + 1) % 5;
        savelen = length;
        savebuf = data2;
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static synchronized boolean wavesave(byte[] data2, int length) {
        return SignLink.saveWave(data2, length);
    }

    public static synchronized boolean replayWave() {
        if (savereq != null) {
            return false;
        }
        waveplay = true;
        savereq = "sound" + wavepos + ".wav";
        return true;
    }

    public static synchronized boolean wavereplay() {
        return SignLink.replayWave();
    }

    public static synchronized void saveMidi(byte[] data2, int length) {
        if (length > 2000000 || savereq != null) {
            return;
        }
        midipos = (midipos + 1) % 5;
        savelen = length;
        savebuf = data2;
        play = true;
        savereq = "jingle" + midipos + ".mid";
    }

    public static synchronized Socket openSocket(int port) throws IOException {
        socketRequest = port;
        while (socketRequest != 0) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (socket == null) {
            throw new IOException("could not open socket");
        }
        return socket;
    }

    public static synchronized DataInputStream openUrl(String url) throws IOException {
        urlRequest = url;
        while (urlRequest != null) {
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
        if (urlStream == null) {
            throw new IOException("could not open: " + url);
        }
        return urlStream;
    }

    public static synchronized void dnslookup(String s2) {
        dns = s2;
        dnsreq = s2;
    }

    public static synchronized void startthread(Runnable runnable2, int i) {
        threadreqpri = i;
        threadreq = runnable2;
    }

    public static String indexLocation(int cacheIndex, int index) {
        return SignLink.findCacheDir() + "index" + cacheIndex + "/" + (String)(index != -1 ? index + ".gz" : "");
    }

    public static void reporterror(String s2) {
        Client.addReportToServer("Error: " + s2);
    }

    public static void setError(String error) {
        errorName = error;
    }

    static {
        socket = null;
        threadreqpri = 1;
        threadreq = null;
        dnsreq = null;
        dns = null;
        urlRequest = null;
        urlStream = null;
        savereq = null;
        savebuf = null;
        midi = null;
        midiVolume = 100;
        fadeMidi = 0;
        wavevol = 100;
        reporterror = true;
        errorName = "";
        music = null;
        sequence = null;
        synthesizer = null;
    }
}

