/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.sound;

import java.io.InputStream;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;

public class SoundPlayer
implements Runnable {
    private AudioInputStream stream;
    private DataLine.Info info;
    private Clip sound;
    private InputStream soundStream;
    private Thread player;
    private int delay;
    private int soundLevel;
    public static int volume;

    public SoundPlayer(InputStream stream, int level, int delay) {
        if (level == 0 || volume == 0) {
            System.out.println("Sounds are off.");
            return;
        }
        this.soundStream = stream;
        this.soundLevel = level;
        this.delay = delay;
        this.player = new Thread(this);
        this.player.setName("EldoriaClientMusicThread");
        this.player.start();
    }

    @Override
    public void run() {
        try {
            this.stream = AudioSystem.getAudioInputStream(this.soundStream);
            this.info = new DataLine.Info(Clip.class, this.stream.getFormat());
            this.sound = (Clip)AudioSystem.getLine(this.info);
            this.sound.open(this.stream);
            FloatControl volume = (FloatControl)this.sound.getControl(FloatControl.Type.MASTER_GAIN);
            int soundLvl = this.soundLevel - SoundPlayer.getVolume();
            System.out.println("sound level: " + soundLvl);
            volume.setValue(this.getDecibels(soundLvl));
            if (this.delay > 0) {
                Thread.sleep(this.delay);
            }
            this.sound.start();
            while (this.sound.isActive()) {
                Thread.sleep(250L);
            }
            Thread.sleep(10000L);
            this.sound.close();
            this.stream.close();
            this.player.interrupt();
        }
        catch (Exception e) {
            this.player.interrupt();
            e.printStackTrace();
        }
    }

    public static void setVolume(int level) {
        volume = level;
    }

    public static int getVolume() {
        return volume;
    }

    public float getDecibels(int level) {
        switch (level) {
            case 1: {
                return -80.0f;
            }
            case 2: {
                return -70.0f;
            }
            case 3: {
                return -60.0f;
            }
            case 4: {
                return -50.0f;
            }
            case 5: {
                return -40.0f;
            }
            case 6: {
                return -30.0f;
            }
            case 7: {
                return -20.0f;
            }
            case 8: {
                return -10.0f;
            }
            case 9: {
                return -0.0f;
            }
            case 10: {
                return 6.0f;
            }
        }
        return 0.0f;
    }

    public float getNewDecibels(int level) {
        switch (level) {
            case 7: {
                return -30.0f;
            }
            case 6: {
                return -20.0f;
            }
            case 5: {
                return -10.0f;
            }
            case 4: {
                return 0.0f;
            }
        }
        return 40.0f;
    }
}

