/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.sound;

import com.hazy.io.Buffer;
import com.hazy.sound.Envelope;
import com.hazy.sound.Filter;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

final class Synthesizer {
    private Envelope pitch;
    private Envelope volume;
    private Envelope pitchModifier;
    private Envelope pitchModifierAmplitude;
    private Envelope volumeMultiplier;
    private Envelope volumeMultiplierAmplitude;
    private Envelope release;
    private Envelope attack;
    private final int[] oscillatorVolume = new int[5];
    private final int[] anIntArray107 = new int[5];
    private final int[] anIntArray108 = new int[5];
    private int delayTime;
    private int delayDecay = 100;
    private Filter filter;
    private Envelope filterEnvelope;
    int duration = 500;
    int offset;
    private static int[] samples;
    private static int[] NOISE;
    private static int[] SINE;
    private static final int[] phases;
    private static final int[] delays;
    private static final int[] volumeSteps;
    private static final int[] pitchSteps;
    private static final int[] pitchBaseSteps;

    public static void init() {
        NOISE = new int[32768];
        for (int i = 0; i < 32768; ++i) {
            Synthesizer.NOISE[i] = Math.random() > 0.5 ? 1 : -1;
        }
        SINE = new int[32768];
        for (int j = 0; j < 32768; ++j) {
            Synthesizer.SINE[j] = (int)(Math.sin((double)j / 5215.1903) * 16384.0);
        }
        samples = new int[220500];
    }

    public void playSynthesizedSound(int sampleCount) {
        try {
            int[] audioSamples = this.synthesize(sampleCount, this.duration);
            System.out.println("Generated " + audioSamples.length + " samples.");
            AudioFormat format = new AudioFormat(44100.0f, 16, 1, true, false);
            DataLine.Info info = new DataLine.Info(SourceDataLine.class, format);
            SourceDataLine line = (SourceDataLine)AudioSystem.getLine(info);
            line.open(format);
            line.start();
            byte[] audioData = new byte[audioSamples.length * 2];
            for (int i = 0; i < audioSamples.length; ++i) {
                audioData[i * 2] = (byte)(audioSamples[i] & 0xFF);
                audioData[i * 2 + 1] = (byte)(audioSamples[i] >> 8 & 0xFF);
            }
            System.out.println("Writing " + audioData.length + " bytes to the line.");
            line.write(audioData, 0, audioData.length);
            line.drain();
            line.stop();
            line.close();
        }
        catch (LineUnavailableException e) {
            System.err.println("Error initializing audio line: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public int[] synthesize(int sampleCount, int duration) {
        int sample;
        System.out.println("Synthesis started for " + sampleCount + " samples.");
        for (int k = 0; k < sampleCount; ++k) {
            Synthesizer.samples[k] = 0;
        }
        this.playSynthesizedSound(sampleCount);
        if (duration < 10) {
            return samples;
        }
        double d = (double)sampleCount / ((double)duration + 0.0);
        this.pitch.reset();
        this.volume.reset();
        int pitchMultiplierStep = 0;
        int pitchModifierBaseStep = 0;
        int pitchModifierPhase = 0;
        if (this.pitchModifier != null) {
            this.pitchModifier.reset();
            this.pitchModifierAmplitude.reset();
            pitchMultiplierStep = (int)((double)(this.pitchModifier.end - this.pitchModifier.start) * 32.768 / d);
            pitchModifierBaseStep = (int)((double)this.pitchModifier.start * 32.768 / d);
        }
        int volumeMultiplierStep = 0;
        int volumeMultiplierBaseStep = 0;
        int volumeMultiplierPhase = 0;
        if (this.volumeMultiplier != null) {
            this.volumeMultiplier.reset();
            this.volumeMultiplierAmplitude.reset();
            volumeMultiplierStep = (int)((double)(this.volumeMultiplier.end - this.volumeMultiplier.start) * 32.768 / d);
            volumeMultiplierBaseStep = (int)((double)this.volumeMultiplier.start * 32.768 / d);
        }
        for (int index = 0; index < 5; ++index) {
            if (this.oscillatorVolume[index] == 0) continue;
            Synthesizer.phases[index] = 0;
            Synthesizer.delays[index] = (int)((double)this.anIntArray108[index] * d);
            Synthesizer.volumeSteps[index] = (this.oscillatorVolume[index] << 14) / 100;
            Synthesizer.pitchSteps[index] = (int)((double)(this.pitch.end - this.pitch.start) * 32.768 * Math.pow(1.0057929410678534, this.anIntArray107[index]) / d);
            Synthesizer.pitchBaseSteps[index] = (int)((double)this.pitch.start * 32.768 / d);
        }
        for (sample = 0; sample < sampleCount; ++sample) {
            int pitchChange = this.pitch.step(sampleCount);
            int volumeChange = this.volume.step(sampleCount);
            if (this.pitchModifier != null) {
                int modifier = this.pitchModifier.step(sampleCount);
                int ampModifier = this.pitchModifierAmplitude.step(sampleCount);
                pitchChange += this.evaluateWave(ampModifier, pitchModifierPhase, this.pitchModifier.form) >> 1;
                pitchModifierPhase += (modifier * pitchMultiplierStep >> 16) + pitchModifierBaseStep;
            }
            if (this.volumeMultiplier != null) {
                int multiplier = this.volumeMultiplier.step(sampleCount);
                int ampMultiplier = this.volumeMultiplierAmplitude.step(sampleCount);
                volumeChange = volumeChange * ((this.evaluateWave(ampMultiplier, volumeMultiplierPhase, this.volumeMultiplier.form) >> 1) + 32768) >> 15;
                volumeMultiplierPhase += (multiplier * volumeMultiplierStep >> 16) + volumeMultiplierBaseStep;
            }
            for (int delay = 0; delay < 5; ++delay) {
                int id;
                if (this.oscillatorVolume[delay] == 0 || (id = sample + delays[delay]) >= sampleCount) continue;
                int n = id;
                samples[n] = samples[n] + this.evaluateWave(volumeChange * volumeSteps[delay] >> 15, phases[delay], this.pitch.form);
                int n2 = delay;
                phases[n2] = phases[n2] + ((pitchChange * pitchSteps[delay] >> 16) + pitchBaseSteps[delay]);
            }
        }
        if (this.release != null) {
            this.release.reset();
            this.attack.reset();
            int counter = 0;
            boolean muted = true;
            for (int sample2 = 0; sample2 < sampleCount; ++sample2) {
                int on = this.release.step(sampleCount);
                int off = this.attack.step(sampleCount);
                int threshold = muted ? this.release.start + ((this.release.end - this.release.start) * on >> 8) : this.release.start + ((this.release.end - this.release.start) * off >> 8);
                if ((counter += 256) >= threshold) {
                    counter = 0;
                    boolean bl = muted = !muted;
                }
                if (!muted) continue;
                Synthesizer.samples[sample2] = 0;
            }
        }
        if (this.delayTime > 0 && this.delayDecay > 0) {
            int delay;
            for (int index = delay = (int)((double)this.delayTime * d); index < sampleCount; ++index) {
                int n = index;
                samples[n] = samples[n] + samples[index - delay] * this.delayDecay / 100;
            }
        }
        if (this.filter.pairs[0] > 0 || this.filter.pairs[1] > 0) {
            this.filterEnvelope.reset();
            int change = this.filterEnvelope.step(sampleCount + 1);
            int forwardOrder = this.filter.compute(0, (float)change / 65536.0f);
            int backOrder = this.filter.compute(1, (float)change / 65536.0f);
            if (sampleCount >= forwardOrder + backOrder) {
                int c;
                int index = 0;
                int delay = backOrder;
                if (delay > sampleCount - forwardOrder) {
                    delay = sampleCount - forwardOrder;
                }
                while (index < delay) {
                    int sample3 = (int)((long)samples[index + forwardOrder] * (long)Filter.forwardMultiplier >> 16);
                    for (int j8 = 0; j8 < forwardOrder; ++j8) {
                        sample3 += (int)((long)samples[index + forwardOrder - 1 - j8] * (long)Filter.coefficients[0][j8] >> 16);
                    }
                    for (int j9 = 0; j9 < index; ++j9) {
                        sample3 -= (int)((long)samples[index - 1 - j9] * (long)Filter.coefficients[1][j9] >> 16);
                    }
                    Synthesizer.samples[index] = sample3;
                    change = this.filterEnvelope.step(sampleCount + 1);
                    ++index;
                }
                delay = c = 128;
                while (true) {
                    if (delay > sampleCount - forwardOrder) {
                        delay = sampleCount - forwardOrder;
                    }
                    while (index < delay) {
                        int l8 = (int)((long)samples[index + forwardOrder] * (long)Filter.forwardMultiplier >> 16);
                        for (int k9 = 0; k9 < forwardOrder; ++k9) {
                            l8 += (int)((long)samples[index + forwardOrder - 1 - k9] * (long)Filter.coefficients[0][k9] >> 16);
                        }
                        for (int i10 = 0; i10 < backOrder; ++i10) {
                            l8 -= (int)((long)samples[index - 1 - i10] * (long)Filter.coefficients[1][i10] >> 16);
                        }
                        Synthesizer.samples[index] = l8;
                        change = this.filterEnvelope.step(sampleCount + 1);
                        ++index;
                    }
                    if (index >= sampleCount - forwardOrder) break;
                    forwardOrder = this.filter.compute(0, (float)change / 65536.0f);
                    backOrder = this.filter.compute(1, (float)change / 65536.0f);
                    delay += c;
                }
                while (index < sampleCount) {
                    int sample4 = 0;
                    for (int l9 = index + forwardOrder - sampleCount; l9 < forwardOrder; ++l9) {
                        sample4 += (int)((long)samples[index + forwardOrder - 1 - l9] * (long)Filter.coefficients[0][l9] >> 16);
                    }
                    for (int j10 = 0; j10 < backOrder; ++j10) {
                        sample4 -= (int)((long)samples[index - 1 - j10] * (long)Filter.coefficients[1][j10] >> 16);
                    }
                    Synthesizer.samples[index] = sample4;
                    ++index;
                }
            }
        }
        for (sample = 0; sample < sampleCount; ++sample) {
            if (samples[sample] < Short.MIN_VALUE) {
                Synthesizer.samples[sample] = Short.MIN_VALUE;
            }
            if (samples[sample] <= Short.MAX_VALUE) continue;
            Synthesizer.samples[sample] = Short.MAX_VALUE;
        }
        return samples;
    }

    private int evaluateWave(int amplitude, int phase, int table) {
        if (table == 1) {
            if ((phase & Short.MAX_VALUE) < 16384) {
                return amplitude;
            }
            return -amplitude;
        }
        if (table == 2) {
            return SINE[phase & Short.MAX_VALUE] * amplitude >> 14;
        }
        if (table == 3) {
            return ((phase & Short.MAX_VALUE) * amplitude >> 14) - amplitude;
        }
        if (table == 4) {
            return NOISE[phase / 2607 & Short.MAX_VALUE] * amplitude;
        }
        return 0;
    }

    public void decode(Buffer stream) {
        int volume;
        this.pitch = new Envelope();
        this.pitch.decode(stream);
        this.volume = new Envelope();
        this.volume.decode(stream);
        int option = stream.readUnsignedByte();
        if (option != 0) {
            --stream.pos;
            this.pitchModifier = new Envelope();
            this.pitchModifier.decode(stream);
            this.pitchModifierAmplitude = new Envelope();
            this.pitchModifierAmplitude.decode(stream);
        }
        if ((option = stream.readUnsignedByte()) != 0) {
            --stream.pos;
            this.volumeMultiplier = new Envelope();
            this.volumeMultiplier.decode(stream);
            this.volumeMultiplierAmplitude = new Envelope();
            this.volumeMultiplierAmplitude.decode(stream);
        }
        if ((option = stream.readUnsignedByte()) != 0) {
            --stream.pos;
            this.release = new Envelope();
            this.release.decode(stream);
            this.attack = new Envelope();
            this.attack.decode(stream);
        }
        for (int index = 0; index < 10 && (volume = stream.readUSmart()) != 0; ++index) {
            this.oscillatorVolume[index] = volume;
            this.anIntArray107[index] = stream.readSignedSmart();
            this.anIntArray108[index] = stream.readUSmart();
        }
        this.delayTime = stream.readUSmart();
        this.delayDecay = stream.readUSmart();
        this.duration = stream.readUnsignedShort();
        this.offset = stream.readUnsignedShort();
        this.filter = new Filter();
        this.filterEnvelope = new Envelope();
        this.filter.decode(stream, this.filterEnvelope);
    }

    static {
        phases = new int[5];
        delays = new int[5];
        volumeSteps = new int[5];
        pitchSteps = new int[5];
        pitchBaseSteps = new int[5];
    }
}

