/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.sound;

import com.hazy.io.Buffer;
import com.hazy.sound.Synthesizer;
import java.util.Arrays;

public final class Track {
    private static final Track[] tracks = new Track[5000];
    public static final int[] delays = new int[5000];
    private static byte[] output;
    private static Buffer riff;
    private final Synthesizer[] synthesizers = new Synthesizer[10];
    private int loop_start;
    private int loop_end;

    private Track() {
    }

    public static void init(Buffer buffer) {
        System.out.println("[Track] Initializing track...");
        output = new byte[441000];
        riff = new Buffer(output);
        Synthesizer.init();
        int id;
        while ((id = buffer.readUnsignedShort()) != 65535) {
            Track.tracks[id] = new Track();
            tracks[id].decode(buffer);
            Track.delays[id] = tracks[id].calculateDelay();
        }
        return;
    }

    public static Buffer data(int loops, int id) {
        if (tracks[id] != null) {
            Track soundTrack = tracks[id];
            System.out.println("Fetching data for track ID " + id + " with " + loops + " loops.");
            Buffer packedData = soundTrack.pack(loops);
            System.out.println("Packed data size: " + packedData.pos);
            return packedData;
        }
        System.out.println("Track with ID " + id + " not found.");
        return null;
    }

    private void decode(Buffer stream) {
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            int valid = stream.readUnsignedByte();
            if (valid == 0) continue;
            --stream.pos;
            this.synthesizers[synthesizer] = new Synthesizer();
            this.synthesizers[synthesizer].decode(stream);
        }
        this.loop_start = stream.readUnsignedShort();
        this.loop_end = stream.readUnsignedShort();
    }

    private int calculateDelay() {
        int offset = 9999999;
        for (int syntheziser = 0; syntheziser < 10; ++syntheziser) {
            if (this.synthesizers[syntheziser] == null || this.synthesizers[syntheziser].offset / 20 >= offset) continue;
            offset = this.synthesizers[syntheziser].offset / 20;
        }
        if (this.loop_start < this.loop_end && this.loop_start / 20 < offset) {
            offset = this.loop_start / 20;
        }
        if (offset == 9999999 || offset == 0) {
            return 0;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null) continue;
            this.synthesizers[synthesizer].offset -= offset * 20;
        }
        if (this.loop_start < this.loop_end) {
            this.loop_start -= offset * 20;
            this.loop_end -= offset * 20;
        }
        return offset;
    }

    private Buffer pack(int loops) {
        int size = this.mix(loops);
        System.out.println("Mix generated " + size + " bytes of audio data.");
        Track.riff.pos = 0;
        riff.writeInt(1380533830);
        riff.writeLEInt(36 + size);
        riff.writeInt(1463899717);
        riff.writeInt(1718449184);
        riff.writeLEInt(16);
        riff.writeLEShort(1);
        riff.writeLEShort(1);
        riff.writeLEInt(22050);
        riff.writeLEInt(22050);
        riff.writeLEShort(1);
        riff.writeLEShort(8);
        riff.writeInt(1684108385);
        riff.writeLEInt(size);
        Track.riff.pos += size;
        System.out.println("Buffer packed with " + size + " bytes of data.");
        return riff;
    }

    private int mix(int loops) {
        int duration = 0;
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null || this.synthesizers[synthesizer].duration + this.synthesizers[synthesizer].offset <= duration) continue;
            duration = this.synthesizers[synthesizer].duration + this.synthesizers[synthesizer].offset;
        }
        if (duration == 0) {
            return 0;
        }
        int sampleCount = 22050 * duration / 1000;
        int loopStart = 22050 * this.loop_start / 1000;
        int loopEnd = 22050 * this.loop_end / 1000;
        if (loopStart < 0 || loopStart > sampleCount || loopEnd < 0 || loopEnd > sampleCount || loopStart >= loopEnd) {
            loops = 0;
        }
        int size = sampleCount + (loopEnd - loopStart) * (loops - 1);
        for (int offset = 44; offset < size + 44; ++offset) {
            Track.output[offset] = -128;
        }
        for (int synthesizer = 0; synthesizer < 10; ++synthesizer) {
            if (this.synthesizers[synthesizer] == null) continue;
            int synthDuration = this.synthesizers[synthesizer].duration * 22050 / 1000;
            int synthOffset = this.synthesizers[synthesizer].offset * 22050 / 1000;
            System.out.println("Synthesizing audio for synthesizer " + synthesizer);
            int[] samples = this.synthesizers[synthesizer].synthesize(synthDuration, this.synthesizers[synthesizer].duration);
            System.out.println("First 5 samples for synthesizer " + synthesizer + ": " + Arrays.toString(Arrays.copyOf(samples, 5)));
            for (int sample = 0; sample < synthDuration; ++sample) {
                int n = sample + synthOffset + 44;
                output[n] = (byte)(output[n] + (byte)(samples[sample] >> 8));
            }
        }
        if (loops > 1) {
            loopStart += 44;
            loopEnd += 44;
            int k2 = (size += 44) - (sampleCount += 44);
            for (int j3 = sampleCount - 1; j3 >= loopEnd; --j3) {
                Track.output[j3 + k2] = output[j3];
            }
            for (int k3 = 1; k3 < loops; ++k3) {
                int l2 = (loopEnd - loopStart) * k3;
                System.arraycopy(output, loopStart, output, loopStart + l2, loopEnd - loopStart);
            }
            size -= 44;
        }
        return size;
    }
}

