/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.util;

import com.hazy.Client;
import com.hazy.cache.FileStore;
import com.hazy.cache.factory.ItemSpriteFactory;
import com.hazy.cache.graphics.SimpleImage;
import com.hazy.cache.graphics.SpriteCache;
import com.hazy.sign.SignLink;
import com.hazy.util.FileUtils;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.RGBImageFilter;
import java.awt.image.RenderedImage;
import java.io.File;
import javax.imageio.ImageIO;

public final class CacheUtils {
    static int imageAmount = 0;

    public static void repackCacheIndex(Client client, FileStore.Store cacheIndex) {
        System.out.println("Started repacking index " + cacheIndex.getIndex() + ".");
        int indexLength = new File(SignLink.indexLocation(cacheIndex.getIndex(), -1)).listFiles().length;
        File[] file = new File(SignLink.indexLocation(cacheIndex.getIndex(), -1)).listFiles();
        try {
            for (int index = 0; index < indexLength; ++index) {
                int fileIndex = Integer.parseInt(CacheUtils.getFileNameWithoutExtension(file[index].toString()));
                byte[] data2 = FileUtils.fileToByteArray(cacheIndex.getIndex(), fileIndex);
                if (data2 != null && data2.length > 0) {
                    client.indices[cacheIndex.getIndex()].writeFile(data2.length, data2, fileIndex);
                    System.out.println("Repacked cache index " + cacheIndex.getIndex() + " file index " + fileIndex + ".");
                    continue;
                }
                System.err.println("Unable to locate cache index " + cacheIndex.getIndex() + " file index " + fileIndex + ".");
            }
        }
        catch (Exception ex) {
            System.err.println("Error packing cache index " + cacheIndex.getIndex() + ".");
        }
        System.out.println("Finished repacking " + cacheIndex.getIndex() + ".");
    }

    public static String getFileNameWithoutExtension(String fileName) {
        File tmpFile = new File(fileName);
        tmpFile.getName();
        int whereDot = tmpFile.getName().lastIndexOf(46);
        if (0 < whereDot && whereDot <= tmpFile.getName().length() - 2) {
            return tmpFile.getName().substring(0, whereDot);
        }
        return "";
    }

    public static Image makeColorTransparent(BufferedImage im, final Color color) {
        RGBImageFilter filter = new RGBImageFilter(){
            public int markerRGB;
            {
                this.markerRGB = color.getRGB() | 0xFF000000;
            }

            @Override
            public final int filterRGB(int x, int y, int rgb) {
                if ((rgb | 0xFF000000) == this.markerRGB) {
                    return 0xFFFFFF & rgb;
                }
                return rgb;
            }
        };
        FilteredImageSource ip = new FilteredImageSource(im.getSource(), filter);
        return Toolkit.getDefaultToolkit().createImage(ip);
    }

    private static BufferedImage imageToBufferedImage(Image image) {
        BufferedImage bufferedImage = new BufferedImage(image.getWidth(null), image.getHeight(null), 2);
        Graphics2D g2 = bufferedImage.createGraphics();
        g2.drawImage(image, 0, 0, null);
        g2.dispose();
        return bufferedImage;
    }

    public static void dumpImageOld(SimpleImage image, String name) {
        File directory = new File(SignLink.findCacheDir() + "/itemspritesdump/");
        if (!directory.exists()) {
            System.out.println("Creating directory");
            directory.mkdir();
        } else {
            System.out.println("Directory exists.");
        }
        BufferedImage bi = new BufferedImage(image.width, image.height, 1);
        bi.setRGB(0, 0, image.width, image.height, image.myPixels, 0, image.width);
        Image img = CacheUtils.makeColorTransparent(bi, new Color(0, 0, 0));
        BufferedImage trans = CacheUtils.imageToBufferedImage(img);
        File f = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
        boolean duplicate = false;
        if (f.exists() && !f.isDirectory()) {
            ++imageAmount;
            duplicate = true;
        }
        try {
            System.out.println("Dump: " + name);
            if (duplicate) {
                File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
                ImageIO.write((RenderedImage)trans, "png", out);
            } else {
                File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
                ImageIO.write((RenderedImage)trans, "png", out);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            Client.addReportToServer(e.getMessage());
        }
    }

    public static void dumpImage(SimpleImage image, String name, int targetWidth, int targetHeight) {
        File directory = new File(SignLink.findCacheDir() + "/itemspritesdump/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        BufferedImage bi = new BufferedImage(targetWidth, targetHeight, 1);
        bi.setRGB(0, 0, targetWidth, targetHeight, image.myPixels, 0, image.width);
        BufferedImage downscaledImage = CacheUtils.downscaleImage(bi, targetWidth, targetHeight);
        Image img = CacheUtils.makeColorTransparent(downscaledImage, new Color(0, 0, 0));
        BufferedImage trans = CacheUtils.imageToBufferedImage(img);
        try {
            File out = new File(SignLink.findCacheDir() + "/itemspritesdump/" + name + ".png");
            ImageIO.write((RenderedImage)trans, "png", out);
        }
        catch (Exception e) {
            e.printStackTrace();
            Client.addReportToServer(e.getMessage());
        }
    }

    public static BufferedImage downscaleImage(BufferedImage originalImage, int targetWidth, int targetHeight) {
        BufferedImage scaledImage = new BufferedImage(targetWidth, targetHeight, 2);
        Graphics2D g2d = scaledImage.createGraphics();
        g2d.drawImage(originalImage, 0, 0, targetWidth, targetHeight, null);
        g2d.dispose();
        return scaledImage;
    }

    public static void dumpItemImage(int id, int width, int height) {
        SimpleImage image = ItemSpriteFactory.get_sized_item_sprite(id, 1, 0, width, height, true);
        if (image != null) {
            CacheUtils.dumpImage(image, Integer.toString(id), width, height);
        }
    }

    public static void dumpItemImages(int idStart, int idEnd, int width, int height) {
        for (int id = idStart; id < idEnd; ++id) {
            SimpleImage image = ItemSpriteFactory.get_sized_item_sprite(id, 1, 0, width, height, true);
            if (image == null) continue;
            CacheUtils.dumpImage(image, Integer.toString(id), width, height);
        }
    }

    public static void dumpAllSprites(SpriteCache spriteCache) {
        File directory = new File(SignLink.findCacheDir() + "/spritesdump/");
        if (!directory.exists()) {
            directory.mkdir();
        }
        int dumped = 0;
        int total = SpriteCache.cache.length;
        System.out.println("Starting sprite dump... total: " + total);
        for (int id = 0; id < total; ++id) {
            try {
                SimpleImage sprite = spriteCache.get(id);
                if (sprite == null) continue;
                BufferedImage bi = new BufferedImage(sprite.width, sprite.height, 1);
                bi.setRGB(0, 0, sprite.width, sprite.height, sprite.myPixels, 0, sprite.width);
                Image img = CacheUtils.makeColorTransparent(bi, new Color(0, 0, 0));
                BufferedImage trans = CacheUtils.imageToBufferedImage(img);
                File out = new File(directory, id + ".png");
                ImageIO.write((RenderedImage)trans, "png", out);
                ++dumped;
                if (id % 100 != 0) continue;
                System.out.println("Dumped " + dumped + " sprites so far...");
                continue;
            }
            catch (Exception e) {
                System.err.println("Failed to dump sprite " + id + ": " + e.getMessage());
            }
        }
        System.out.println("Finished dumping " + dumped + " sprites to " + directory.getAbsolutePath());
    }

    public static void dumpItemImages(int idStart, int idEnd) {
        for (int id = idStart; id < idEnd; ++id) {
            SimpleImage image = ItemSpriteFactory.get_item_sprite(id, 1, 0);
            if (image == null) continue;
            CacheUtils.dumpImage(image, Integer.toString(id), 5, 5);
        }
    }
}

