/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.util;

import com.hazy.io.Buffer;

public final class ChatMessageCodec {
    private static final char[] VALID_CHARACTERS = new char[]{' ', 'e', 't', 'a', 'o', 'i', 'h', 'n', 's', 'r', 'd', 'l', 'u', 'm', 'w', 'c', 'y', 'f', 'g', 'p', 'b', 'v', 'k', 'x', 'j', 'q', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', ' ', '!', '?', '.', ',', ':', ';', '(', ')', '-', '&', '*', '\\', '\'', '@', '#', '+', '=', '\u00a3', '$', '%', '\"', '[', ']'};
    private static char[] message = new char[100];
    private static Buffer stream = new Buffer(new byte[100]);

    public static String decode(int length, Buffer buffer) {
        int index = 0;
        int next2 = -1;
        for (int count = 0; count < length; ++count) {
            int in = buffer.readUnsignedByte();
            int charIndex = in >> 4 & 0xF;
            if (next2 == -1) {
                if (charIndex < 13) {
                    ChatMessageCodec.message[index++] = VALID_CHARACTERS[charIndex];
                } else {
                    next2 = charIndex;
                }
            } else {
                ChatMessageCodec.message[index++] = VALID_CHARACTERS[(next2 << 4) + charIndex - 195];
                next2 = -1;
            }
            charIndex = in & 0xF;
            if (next2 == -1) {
                if (charIndex < 13) {
                    ChatMessageCodec.message[index++] = VALID_CHARACTERS[charIndex];
                    continue;
                }
                next2 = charIndex;
                continue;
            }
            ChatMessageCodec.message[index++] = VALID_CHARACTERS[(next2 << 4) + charIndex - 195];
            next2 = -1;
        }
        boolean capitaliseNext = true;
        for (int count = 0; count < index; ++count) {
            char character = message[count];
            if (capitaliseNext && character >= 'a' && character <= 'z') {
                int n = count;
                message[n] = (char)(message[n] + 65504);
                capitaliseNext = false;
            }
            if (character != '.' && character != '!' && character != '?') continue;
            capitaliseNext = true;
        }
        return new String(message, 0, index);
    }

    public static void encode(String string2, Buffer buffer) {
        if (string2.length() > 80) {
            string2 = string2.substring(0, 80);
        }
        string2 = string2.toLowerCase();
        int next2 = -1;
        for (int index = 0; index < string2.length(); ++index) {
            char character = string2.charAt(index);
            int charIndex = 0;
            for (int count = 0; count < VALID_CHARACTERS.length; ++count) {
                if (character != VALID_CHARACTERS[count]) continue;
                charIndex = count;
                break;
            }
            if (charIndex > 12) {
                charIndex += 195;
            }
            if (next2 == -1) {
                if (charIndex < 13) {
                    next2 = charIndex;
                    continue;
                }
                buffer.writeByte(charIndex);
                continue;
            }
            if (charIndex < 13) {
                buffer.writeByte((next2 << 4) + charIndex);
                next2 = -1;
                continue;
            }
            buffer.writeByte((next2 << 4) + (charIndex >> 4));
            next2 = charIndex & 0xF;
        }
        if (next2 != -1) {
            buffer.writeByte(next2 << 4);
        }
    }

    public static String processText(String string2) {
        stream.resetPosition();
        ChatMessageCodec.encode(string2, stream);
        int length = ChatMessageCodec.stream.pos;
        stream.resetPosition();
        return ChatMessageCodec.decode(length, stream);
    }
}

