/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.util;

import java.net.InetAddress;
import java.net.NetworkInterface;

public class HardwareAddress {
    private String macAddress;

    public HardwareAddress(InetAddress address) {
        try {
            NetworkInterface network = NetworkInterface.getByInetAddress(address);
            if (network != null) {
                StringBuilder sb = new StringBuilder();
                byte[] mac = network.getHardwareAddress();
                if (mac != null) {
                    for (int i = 0; i < mac.length; ++i) {
                        sb.append(String.format(i == mac.length - 1 ? "%02X" : "%02X-", mac[i]));
                    }
                    this.macAddress = sb.toString();
                } else {
                    this.macAddress = "";
                }
            } else {
                this.macAddress = "";
            }
        }
        catch (Exception e) {
            this.macAddress = "";
        }
    }

    public String toString() {
        if (this.macAddress == null) {
            this.macAddress = "";
        }
        return this.macAddress;
    }
}

