/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.util;

import com.displee.cache.CacheLibrary;
import com.displee.cache.index.Index;
import com.displee.cache.index.ReferenceTable;
import com.displee.cache.index.archive.Archive;
import com.displee.cache.index.archive.file.File;
import com.hazy.util.OsrsAnimPacker;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.util.zip.GZIPOutputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\b\u0002\u0010\u0010\u001a\u00020\u0011J\u0018\u0010\u0012\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0013\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0015\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0018\u0010\u0016\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002J\u0016\u0010\u0017\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/hazy/util/OsrsAnimPacker;", "", "()V", "ANIMATIONS", "", "FRAMES", "FRAME_BASES", "GRAPHICS", "animations", "", "cacheFrom", "Lcom/displee/cache/CacheLibrary;", "cacheTo", "compress", "", "array", "compressionLevel", "", "frameBases", "frames", "graphics", "models", "objects", "pack", "game"})
public final class OsrsAnimPacker {
    @NotNull
    public static final OsrsAnimPacker INSTANCE = new OsrsAnimPacker();
    private static final boolean GRAPHICS = true;
    private static final boolean FRAME_BASES = true;
    private static final boolean FRAMES = true;
    private static final boolean ANIMATIONS = true;

    private OsrsAnimPacker() {
    }

    public final void pack(@NotNull CacheLibrary cacheFrom, @NotNull CacheLibrary cacheTo) {
        Intrinsics.checkNotNullParameter(cacheFrom, "cacheFrom");
        Intrinsics.checkNotNullParameter(cacheTo, "cacheTo");
        this.graphics(cacheFrom, cacheTo);
        this.frameBases(cacheFrom, cacheTo);
        this.frames(cacheFrom, cacheTo);
        this.animations(cacheFrom, cacheTo);
    }

    private final void models(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        Index indexFrom = cacheFrom.index(7);
        indexFrom.cache();
        Index indexTo = cacheTo.index(1);
        indexTo.clear();
        int count = 0;
        for (Archive archive : indexFrom.archives()) {
            if (!archive.containsData()) continue;
            indexTo.remove(archive.getId());
            ReferenceTable.add$default((ReferenceTable)indexTo, archive, 0, null, false, 14, null);
            ++count;
        }
        Index.update$default(indexTo, null, 1, null);
        System.out.println((Object)("models count " + count));
    }

    private final void objects(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        int highestFileId = -1;
        ByteBuf idx = Unpooled.buffer();
        idx.writeShort(0);
        ByteBuf dat = Unpooled.directBuffer();
        Index configIndex = cacheFrom.index(2);
        configIndex.cache();
        Archive archive = ReferenceTable.archive$default((ReferenceTable)configIndex, 6, false, 2, null);
        Intrinsics.checkNotNull(archive);
        Archive fromArchive = archive;
        for (File file : fromArchive.files()) {
            byte[] data2;
            Intrinsics.checkNotNull(file.getData());
            int dataSize = data2.length;
            if (dataSize < 1) {
                idx.writeShort(0);
                throw new IllegalStateException("object skip " + file.getId());
            }
            int fileId = file.getId();
            if (dataSize >= 65535) {
                throw new IllegalStateException("TOO LARGE OBJECT SIZE " + dataSize + " for " + fromArchive.getId() + ":" + fileId);
            }
            idx.writeShort(dataSize);
            dat.writeBytes(data2);
            if (fileId <= highestFileId) continue;
            highestFileId = fileId;
        }
        idx.writeShort(-1);
        idx.setShort(0, highestFileId);
        dat.readerIndex(0);
        byte[] datArray = new byte[dat.readableBytes()];
        dat.readBytes(datArray);
        idx.readerIndex(0);
        byte[] idxArray = new byte[idx.readableBytes()];
        idx.readBytes(idxArray);
        CacheLibrary.put$default(cacheTo, 0, 2, "loc.dat", datArray, null, 16, null);
        CacheLibrary.put$default(cacheTo, 0, 2, "loc.idx", idxArray, null, 16, null);
        Index.update$default(cacheTo.index(0), null, 1, null);
        System.out.println((Object)("object highest " + highestFileId));
    }

    private final void graphics(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        int highestFileId = -1;
        int biggestSize = 0;
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(0);
        Index configIndex = cacheFrom.index(2);
        configIndex.cache();
        Archive archive = ReferenceTable.archive$default((ReferenceTable)configIndex, 13, false, 2, null);
        Intrinsics.checkNotNull(archive);
        Archive fromArchive = archive;
        for (File file : fromArchive.files()) {
            byte[] data2;
            Intrinsics.checkNotNull(file.getData());
            int dataSize = data2.length;
            if (dataSize < 1) {
                System.out.println((Object)("skipped spotanim file " + file.getId() + " (no data)"));
                buf.writeShort(-1);
                continue;
            }
            int fileId = file.getId();
            if (dataSize >= 65535) {
                throw new IllegalStateException("TOO LARGE GRAPHIC! " + fromArchive.getId() + ":" + fileId + " size was " + dataSize);
            }
            buf.writeShort(fileId);
            buf.writeShort(dataSize);
            buf.writeBytes(data2);
            if (fileId > highestFileId) {
                highestFileId = fileId;
            }
            if (dataSize <= biggestSize) continue;
            biggestSize = dataSize;
        }
        buf.writeShort(-1);
        buf.setShort(0, highestFileId);
        buf.readerIndex(0);
        byte[] array = new byte[buf.readableBytes()];
        buf.readBytes(array);
        System.out.println((Object)("spotanim highest " + highestFileId + " and biggest was " + biggestSize + " (total bytes=" + array.length + ")"));
        CacheLibrary.put$default(cacheTo, 0, 2, "spotanim.dat", array, null, 16, null);
        Index.update$default(cacheTo.index(0), null, 1, null);
    }

    private final void frameBases(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        Index indexFrom = cacheFrom.index(1);
        indexFrom.cache();
        ByteBuf buf = Unpooled.buffer();
        int count = 0;
        buf.writeShort(count);
        for (Archive archive : indexFrom.archives()) {
            byte[] data2;
            File file;
            int groupId = archive.getId();
            if (!archive.containsData()) {
                throw new IllegalStateException("MUST HAVE DATA! " + groupId);
            }
            Intrinsics.checkNotNull(archive.file(0));
            Intrinsics.checkNotNull(file.getData());
            int dataSize = data2.length;
            if (dataSize >= 65535) {
                throw new IllegalStateException("TOO LARGE DATA! " + groupId + " size " + dataSize);
            }
            buf.writeShort(groupId);
            buf.writeShort(dataSize);
            buf.writeBytes(data2);
            ++count;
        }
        buf.setShort(0, count);
        buf.readerIndex(0);
        byte[] array = new byte[buf.readableBytes()];
        buf.readBytes(array);
        byte[] compressedArray = OsrsAnimPacker.compress$default(this, array, 0, 2, null);
        CacheLibrary.put$default(cacheTo, 0, 2, "framebases.dat", compressedArray, null, 16, null);
        Index.update$default(cacheTo.index(0), null, 1, null);
        System.out.println((Object)("frame bases count " + count + " and raw size " + array.length + ", compressed size " + compressedArray.length));
    }

    private final void frames(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        Index indexFrom = cacheFrom.index(0);
        indexFrom.cache();
        Index indexTo = cacheTo.index(2);
        indexTo.clear();
        int count = 0;
        for (Archive archive : indexFrom.archives()) {
            if (!archive.containsData()) continue;
            ByteBuf buf = Unpooled.buffer();
            int highestFileId = 0;
            buf.writeShort(highestFileId);
            for (File file : archive.files()) {
                byte[] data2;
                int fileId = file.getId();
                Intrinsics.checkNotNull(file.getData());
                buf.writeShort(fileId);
                buf.writeMedium(data2.length);
                buf.writeBytes(data2);
                if (fileId <= highestFileId) continue;
                highestFileId = fileId;
            }
            buf.setShort(0, highestFileId);
            buf.readerIndex(0);
            byte[] array = new byte[buf.readableBytes()];
            buf.readBytes(array);
            CacheLibrary.put$default(cacheTo, 2, archive.getId(), array, null, 8, null);
            ++count;
        }
        Index.update$default(indexTo, null, 1, null);
        System.out.println((Object)("frames count " + count));
    }

    private final void animations(CacheLibrary cacheFrom, CacheLibrary cacheTo) {
        int highestFileId = -1;
        int biggestSize = 0;
        ByteBuf buf = Unpooled.buffer();
        buf.writeShort(0);
        Index configIndex = cacheFrom.index(2);
        configIndex.cache();
        Archive archive = ReferenceTable.archive$default((ReferenceTable)configIndex, 12, false, 2, null);
        Intrinsics.checkNotNull(archive);
        Archive fromArchive = archive;
        for (File file : fromArchive.files()) {
            byte[] data2;
            Intrinsics.checkNotNull(file.getData());
            int dataSize = data2.length;
            if (dataSize < 1) {
                throw new IllegalStateException("skipped seq file " + file.getId() + " (no data)");
            }
            int fileId = file.getId();
            buf.writeShort(fileId);
            if (dataSize >= 65535) {
                throw new IllegalStateException("TOO LARGE DATA! " + fromArchive.getId() + ":" + fileId + " size " + dataSize);
            }
            buf.writeShort(dataSize);
            buf.writeBytes(data2);
            if (fileId > highestFileId) {
                highestFileId = fileId;
            }
            if (data2.length <= biggestSize) continue;
            biggestSize = data2.length;
        }
        buf.setShort(0, highestFileId);
        buf.readerIndex(0);
        byte[] array = new byte[buf.readableBytes()];
        buf.readBytes(array);
        byte[] compressedArray = OsrsAnimPacker.compress$default(this, array, 0, 2, null);
        System.out.println((Object)("seq highest " + highestFileId + " and biggest was " + biggestSize + " (total bytes=" + array.length + ", compressed bytes=" + compressedArray.length + ")"));
        CacheLibrary.put$default(cacheTo, 0, 2, "seq.dat", compressedArray, null, 16, null);
        Index.update$default(cacheTo.index(0), null, 1, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final byte[] compress(@NotNull byte[] array, int compressionLevel) {
        Intrinsics.checkNotNullParameter(array, "array");
        Closeable closeable = new ByteArrayOutputStream();
        Throwable throwable = null;
        try {
            ByteArrayOutputStream bout = (ByteArrayOutputStream)closeable;
            boolean bl = false;
            Closeable closeable2 = new GZIPOutputStream(compressionLevel, bout){
                {
                    this.def.setLevel($compressionLevel);
                }
            };
            Throwable throwable2 = null;
            try {
                compress.1.1 os = closeable2;
                boolean bl2 = false;
                os.write(array);
                os.finish();
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally(closeable2, throwable2);
            }
            byte[] byArray = bout.toByteArray();
            Intrinsics.checkNotNullExpressionValue(byArray, "toByteArray(...)");
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally(closeable, throwable);
        }
    }

    public static /* synthetic */ byte[] compress$default(OsrsAnimPacker osrsAnimPacker, byte[] byArray, int n, int n2, Object object) {
        if ((n2 & 2) != 0) {
            n = 9;
        }
        return osrsAnimPacker.compress(byArray, n);
    }
}

