/*
 * Decompiled with CFR 0.152.
 */
package com.hazy.util;

import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unzip {
    public static void unZipIt(String zipFile, String outputFolder, boolean deleteAfter) {
        byte[] buffer = new byte[1024];
        try {
            File folder = new File(outputFolder);
            boolean isDirectoryCreated = folder.exists();
            if (!isDirectoryCreated) {
                isDirectoryCreated = folder.mkdir();
            }
            if (isDirectoryCreated) {
                ZipInputStream zis = new ZipInputStream(Files.newInputStream(Paths.get(zipFile, new String[0]), new OpenOption[0]));
                ZipEntry ze = zis.getNextEntry();
                while (ze != null) {
                    String fileName = ze.getName();
                    File newFile = new File(outputFolder + File.separator + fileName);
                    System.out.println("file unzip : " + String.valueOf(newFile.getAbsoluteFile()));
                    new File(newFile.getParent()).mkdirs();
                    if (!ze.isDirectory()) {
                        int len;
                        FileOutputStream fos = new FileOutputStream(newFile);
                        while ((len = zis.read(buffer)) > 0) {
                            fos.write(buffer, 0, len);
                        }
                        fos.close();
                    }
                    ze = zis.getNextEntry();
                }
                zis.closeEntry();
                zis.close();
                if (deleteAfter) {
                    new File(zipFile).delete();
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

