/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.builder.impl;

import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.expression.Add;
import com.thoughtworks.qdox.model.expression.And;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.AnnotationValueList;
import com.thoughtworks.qdox.model.expression.Assignment;
import com.thoughtworks.qdox.model.expression.Cast;
import com.thoughtworks.qdox.model.expression.Constant;
import com.thoughtworks.qdox.model.expression.Divide;
import com.thoughtworks.qdox.model.expression.Equals;
import com.thoughtworks.qdox.model.expression.ExclusiveOr;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;
import com.thoughtworks.qdox.model.expression.FieldRef;
import com.thoughtworks.qdox.model.expression.GreaterEquals;
import com.thoughtworks.qdox.model.expression.GreaterThan;
import com.thoughtworks.qdox.model.expression.Lambda;
import com.thoughtworks.qdox.model.expression.LessEquals;
import com.thoughtworks.qdox.model.expression.LessThan;
import com.thoughtworks.qdox.model.expression.LogicalAnd;
import com.thoughtworks.qdox.model.expression.LogicalNot;
import com.thoughtworks.qdox.model.expression.LogicalOr;
import com.thoughtworks.qdox.model.expression.MethodInvocation;
import com.thoughtworks.qdox.model.expression.MinusSign;
import com.thoughtworks.qdox.model.expression.Multiply;
import com.thoughtworks.qdox.model.expression.Not;
import com.thoughtworks.qdox.model.expression.NotEquals;
import com.thoughtworks.qdox.model.expression.Or;
import com.thoughtworks.qdox.model.expression.ParenExpression;
import com.thoughtworks.qdox.model.expression.PlusSign;
import com.thoughtworks.qdox.model.expression.PostDecrement;
import com.thoughtworks.qdox.model.expression.PostIncrement;
import com.thoughtworks.qdox.model.expression.PreDecrement;
import com.thoughtworks.qdox.model.expression.PreIncrement;
import com.thoughtworks.qdox.model.expression.Query;
import com.thoughtworks.qdox.model.expression.Remainder;
import com.thoughtworks.qdox.model.expression.ShiftLeft;
import com.thoughtworks.qdox.model.expression.ShiftRight;
import com.thoughtworks.qdox.model.expression.Subtract;
import com.thoughtworks.qdox.model.expression.TypeRef;
import com.thoughtworks.qdox.model.expression.UnsignedShiftRight;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class EvaluatingVisitor
implements ExpressionVisitor {
    public Object getValue(JavaAnnotation annotation, String property) {
        Object result2 = null;
        AnnotationValue value = annotation.getProperty(property);
        if (value != null) {
            result2 = value.accept(this);
        }
        return result2;
    }

    public List<?> getListValue(JavaAnnotation annotation, String property) {
        Object value = this.getValue(annotation, property);
        List<Object> list = null;
        if (value != null) {
            list = value instanceof List ? (List<Object>)value : Collections.singletonList(value);
        }
        return list;
    }

    protected static Class<?> resultType(Object left, Object right) {
        Class<Object> type2 = Void.TYPE;
        if (left instanceof String || right instanceof String) {
            type2 = String.class;
        } else if (left instanceof Number && right instanceof Number) {
            type2 = left instanceof Double || right instanceof Double ? Double.class : (left instanceof Float || right instanceof Float ? Float.class : (left instanceof Long || right instanceof Long ? Long.class : Integer.class));
        }
        return type2;
    }

    protected static Class<?> numericResultType(Object left, Object right) {
        Class<Object> type2 = Void.TYPE;
        if (left instanceof Number && right instanceof Number) {
            if (left instanceof Long || right instanceof Long) {
                type2 = Long.class;
            } else if (left instanceof Integer || right instanceof Integer) {
                type2 = Integer.class;
            }
        }
        return type2;
    }

    protected static Class<?> unaryNumericResultType(Object value) {
        Class<Object> type2 = Void.TYPE;
        if (value instanceof Byte || value instanceof Short || value instanceof Character || value instanceof Integer) {
            type2 = Integer.class;
        } else if (value instanceof Long) {
            type2 = Long.class;
        }
        return type2;
    }

    protected static Class<?> unaryResultType(Object value) {
        Class<Object> type2 = EvaluatingVisitor.unaryNumericResultType(value);
        if (type2 == Void.TYPE) {
            if (value instanceof Float) {
                type2 = Float.class;
            } else if (value instanceof Double) {
                type2 = Double.class;
            }
        }
        return type2;
    }

    @Override
    public Object visit(JavaAnnotation annotation) throws UnsupportedOperationException {
        throw new UnsupportedOperationException("Illegal annotation value '" + annotation + "'.");
    }

    @Override
    public Object visit(Add op) {
        Object result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == String.class) {
            result2 = left.toString() + right.toString();
        } else if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() + ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(((Number)left).floatValue() + ((Number)right).floatValue());
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() + ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() + ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(Constant constant) {
        return constant.getValue();
    }

    @Override
    public Object visit(Divide op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() / ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(((Number)left).floatValue() / ((Number)right).floatValue());
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() / ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() / ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(FieldRef fieldRef) {
        JavaField javaField = fieldRef.getField();
        if (javaField == null) {
            throw new IllegalArgumentException("Cannot resolve field reference '" + fieldRef + "'.");
        }
        if (!javaField.isFinal() || !javaField.isStatic()) {
            throw new IllegalArgumentException("Field reference '" + fieldRef + "' must be static and final.");
        }
        return this.getFieldReferenceValue(javaField);
    }

    protected Object getFieldReferenceValue(JavaField javaField) {
        throw new UnsupportedOperationException("getFieldReferenceValue(JavaField) has not been implemented.");
    }

    @Override
    public Object visit(GreaterThan op) {
        boolean result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() > ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = ((Number)left).floatValue() > ((Number)right).floatValue();
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() > ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() > ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(LessThan op) {
        boolean result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() < ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = ((Number)left).floatValue() < ((Number)right).floatValue();
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() < ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() < ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(Multiply op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() * ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(((Number)left).floatValue() * ((Number)right).floatValue());
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() * ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() * ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(ParenExpression parenExpression) {
        return parenExpression.getValue().accept(this);
    }

    @Override
    public Object visit(Subtract op) {
        Number result2;
        Object right;
        Object left = op.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = op.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() - ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(((Number)left).floatValue() - ((Number)right).floatValue());
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() - ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() - ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + op + "'.");
        }
        return result2;
    }

    @Override
    public JavaType visit(TypeRef typeRef) {
        return typeRef.getType();
    }

    @Override
    public List<?> visit(AnnotationValueList valueList) {
        LinkedList<Object> list = new LinkedList<Object>();
        for (AnnotationValue value : valueList.getValueList()) {
            Object v = value.accept(this);
            list.add(v);
        }
        return list;
    }

    @Override
    public Object visit(And and) {
        Number result2;
        Object right;
        Object left = and.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = and.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() & ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() & ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + and + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(GreaterEquals greaterEquals) {
        boolean result2;
        Object right;
        Object left = greaterEquals.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = greaterEquals.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() >= ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = ((Number)left).floatValue() >= ((Number)right).floatValue();
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() >= ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() >= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + greaterEquals + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(LessEquals lessEquals) {
        boolean result2;
        Object right;
        Object left = lessEquals.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = lessEquals.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() <= ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = ((Number)left).floatValue() <= ((Number)right).floatValue();
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() <= ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() <= ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + lessEquals + "'.");
        }
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(LogicalAnd and) {
        Object left = and.getLeft().accept(this);
        Object right = and.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + and + "'.");
        }
        boolean result2 = (Boolean)left != false && (Boolean)right != false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(LogicalNot not) {
        Object value = not.getValue().accept(this);
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + not + "'.");
        }
        boolean result2 = (Boolean)value == false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(LogicalOr or) {
        Object left = or.getLeft().accept(this);
        Object right = or.getRight().accept(this);
        if (!(left instanceof Boolean) || !(right instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        boolean result2 = (Boolean)left != false || (Boolean)right != false;
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(MinusSign sign) {
        Number result2;
        Object value = sign.getValue().accept(this);
        Class<?> type2 = EvaluatingVisitor.unaryResultType(value);
        if (type2 == Integer.class) {
            result2 = -((Integer)value).intValue();
        } else if (type2 == Long.class) {
            result2 = -((Long)value).longValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(-((Float)value).floatValue());
        } else if (type2 == Double.class) {
            result2 = -((Double)value).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + sign + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(Not not) {
        Number result2;
        Object value = not.getValue().accept(this);
        Class<?> type2 = EvaluatingVisitor.unaryNumericResultType(value);
        if (type2 == Long.class) {
            result2 = (Long)value ^ 0xFFFFFFFFFFFFFFFFL;
        } else if (type2 == Integer.class) {
            result2 = ~((Integer)value).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + not + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(Or or) {
        Number result2;
        Object right;
        Object left = or.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = or.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() | ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() | ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + or + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(PlusSign sign) {
        Object value = sign.getValue().accept(this);
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("Cannot evaluate '" + sign + "'.");
        }
        Object result2 = value;
        return result2;
    }

    @Override
    public Object visit(Remainder remainder) {
        Number result2;
        Object right;
        Object left = remainder.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = remainder.getRight().accept(this));
        if (type2 == Double.class) {
            result2 = ((Number)left).doubleValue() % ((Number)right).doubleValue();
        } else if (type2 == Float.class) {
            result2 = Float.valueOf(((Number)left).floatValue() % ((Number)right).floatValue());
        } else if (type2 == Long.class) {
            result2 = ((Number)left).longValue() % ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() % ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + remainder + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(ShiftLeft shiftLeft) {
        Number result2;
        Object right;
        Object left = shiftLeft.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = shiftLeft.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() << (int)((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() << ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftLeft + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(ShiftRight shiftRight) {
        Number result2;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() >> (int)((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() >> ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(UnsignedShiftRight shiftRight) {
        Number result2;
        Object right;
        Object left = shiftRight.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = shiftRight.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() >>> (int)((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() >>> ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + shiftRight + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(Equals annotationEquals) {
        Object right;
        Object left = annotationEquals.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = annotationEquals.getRight().accept(this));
        boolean result2 = type2 == Double.class ? ((Number)left).doubleValue() == ((Number)right).doubleValue() : (type2 == Float.class ? ((Number)left).floatValue() == ((Number)right).floatValue() : (type2 == Long.class ? ((Number)left).longValue() == ((Number)right).longValue() : (type2 == Integer.class ? ((Number)left).intValue() == ((Number)right).intValue() : left == right)));
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(ExclusiveOr annotationExclusiveOr) {
        Number result2;
        Object right;
        Object left = annotationExclusiveOr.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.numericResultType(left, right = annotationExclusiveOr.getRight().accept(this));
        if (type2 == Long.class) {
            result2 = ((Number)left).longValue() ^ ((Number)right).longValue();
        } else if (type2 == Integer.class) {
            result2 = ((Number)left).intValue() ^ ((Number)right).intValue();
        } else {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationExclusiveOr + "'.");
        }
        return result2;
    }

    @Override
    public Object visit(NotEquals annotationNotEquals) {
        Object right;
        Object left = annotationNotEquals.getLeft().accept(this);
        Class<?> type2 = EvaluatingVisitor.resultType(left, right = annotationNotEquals.getRight().accept(this));
        boolean result2 = type2 == Double.class ? ((Number)left).doubleValue() != ((Number)right).doubleValue() : (type2 == Float.class ? ((Number)left).floatValue() != ((Number)right).floatValue() : (type2 == Long.class ? ((Number)left).longValue() != ((Number)right).longValue() : (type2 == Integer.class ? ((Number)left).intValue() != ((Number)right).intValue() : left != right)));
        return result2 ? Boolean.TRUE : Boolean.FALSE;
    }

    @Override
    public Object visit(Query annotationQuery) {
        Object value = annotationQuery.getCondition().accept(this);
        if (!(value instanceof Boolean)) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationQuery + "'.");
        }
        AnnotationValue expression = (Boolean)value != false ? annotationQuery.getTrueExpression() : annotationQuery.getFalseExpression();
        return expression.accept(this);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Object visit(Cast annotationCast) {
        void var4_16;
        Object value = annotationCast.getValue().accept(this);
        JavaType type2 = annotationCast.getType();
        if (type2 instanceof JavaClass && ((JavaClass)type2).isPrimitive() && value instanceof Number) {
            Number n = (Number)value;
            String typeName = type2.getFullyQualifiedName();
            if (typeName.equals("byte")) {
                Byte by = n.byteValue();
                return var4_16;
            } else if (typeName.equals("char")) {
                Character c = Character.valueOf((char)n.intValue());
                return var4_16;
            } else if (typeName.equals("short")) {
                Short s2 = n.shortValue();
                return var4_16;
            } else if (typeName.equals("int")) {
                Integer n2 = n.intValue();
                return var4_16;
            } else if (typeName.equals("long")) {
                Long l = n.longValue();
                return var4_16;
            } else if (typeName.equals("float")) {
                Float f = Float.valueOf(n.floatValue());
                return var4_16;
            } else {
                if (!typeName.equals("double")) throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
                Double d = n.doubleValue();
            }
            return var4_16;
        }
        try {
            Object obj2 = Class.forName(type2.getFullyQualifiedName()).cast(value);
            return var4_16;
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Cannot evaluate '" + annotationCast + "'.");
        }
    }

    @Override
    public Object visit(PreDecrement preDecrement) {
        throw new IllegalArgumentException("Cannot evaluate '" + preDecrement + "'.");
    }

    @Override
    public Object visit(PreIncrement preIncrement) {
        throw new IllegalArgumentException("Cannot evaluate '" + preIncrement + "'.");
    }

    @Override
    public Object visit(PostDecrement postDecrement) {
        throw new IllegalArgumentException("Cannot evaluate '" + postDecrement + "'.");
    }

    @Override
    public Object visit(PostIncrement postIncrement) {
        throw new IllegalArgumentException("Cannot evaluate '" + postIncrement + "'.");
    }

    @Override
    public Object visit(Assignment assignment) {
        throw new IllegalArgumentException("Cannot evaluate '" + assignment + "'.");
    }

    @Override
    public Object visit(MethodInvocation methodInvocation) {
        throw new IllegalArgumentException("Cannot evaluate '" + methodInvocation + "'.");
    }

    @Override
    public Object visit(Lambda lambda2) {
        throw new IllegalArgumentException("Cannot evaluate '" + lambda2 + "'.");
    }
}

