/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.directorywalker;

import com.thoughtworks.qdox.directorywalker.FileVisitor;
import com.thoughtworks.qdox.directorywalker.Filter;
import java.io.File;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class DirectoryScanner {
    private File file;
    private Collection<Filter> filters = new HashSet<Filter>();

    public DirectoryScanner(File file) {
        this.file = file;
    }

    public void addFilter(Filter filter) {
        this.filters.add(filter);
    }

    public List<File> scan() {
        final LinkedList<File> result2 = new LinkedList<File>();
        this.walk(new FileVisitor(){

            @Override
            public void visitFile(File file) {
                result2.add(file);
            }
        }, this.file);
        return result2;
    }

    public void scan(FileVisitor fileVisitor) {
        this.walk(fileVisitor, this.file);
    }

    private void walk(FileVisitor visitor2, File current) {
        if (current.isDirectory()) {
            File[] currentFiles = current.listFiles();
            for (int i = 0; i < currentFiles.length; ++i) {
                this.walk(visitor2, currentFiles[i]);
            }
        } else {
            for (Filter filter : this.filters) {
                if (filter.filter(current)) continue;
                return;
            }
            visitor2.visitFile(current);
        }
    }
}

