/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.builder.ModelBuilderFactory;
import com.thoughtworks.qdox.builder.impl.ModelBuilder;
import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.library.JavaClassContext;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModule;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.impl.DefaultDocletTagFactory;
import com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.thoughtworks.qdox.parser.structs.ClassDef;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;

public abstract class AbstractClassLibrary
implements ClassLibrary {
    private AbstractClassLibrary parentClassLibrary;
    private ModelBuilderFactory modelBuilderFactory;
    private ModelWriterFactory modelWriterFactory;
    private JavaClassContext context = new JavaClassContext();

    public AbstractClassLibrary() {
    }

    public AbstractClassLibrary(AbstractClassLibrary parent) {
        this.parentClassLibrary = parent;
    }

    @Override
    public Collection<JavaModule> getJavaModules() {
        Collection<JavaModule> modules = null;
        if (this.parentClassLibrary != null) {
            modules = this.parentClassLibrary.getJavaModules();
        }
        return modules;
    }

    @Override
    public final JavaClass getJavaClass(String name) {
        return this.getJavaClass(name, false);
    }

    @Override
    public final JavaClass getJavaClass(String name, boolean createStub) {
        JavaClass result2 = this.context.getClassByName(name);
        if (result2 == null && (result2 = this.resolveJavaClass(name)) != null) {
            this.context.add(result2);
            this.context.add(result2.getSource());
            JavaPackage contextPackage = this.context.getPackageByName(result2.getPackageName());
            if (contextPackage == null) {
                DefaultJavaPackage newContextPackage = new DefaultJavaPackage(result2.getPackageName());
                newContextPackage.setClassLibrary(this);
                this.context.add(newContextPackage);
                contextPackage = newContextPackage;
            }
            contextPackage.getClasses().addAll(result2.getNestedClasses());
        }
        if (result2 == null && this.parentClassLibrary != null) {
            result2 = this.parentClassLibrary.getJavaClass(name);
        }
        if (result2 == null && createStub) {
            result2 = this.createStub(name);
        }
        return result2;
    }

    private JavaClass createStub(String name) {
        Builder unknownBuilder = this.getModelBuilder();
        unknownBuilder.beginClass(new ClassDef(name));
        unknownBuilder.endClass();
        JavaSource unknownSource = unknownBuilder.getSource();
        return unknownSource.getClasses().get(0);
    }

    protected abstract JavaClass resolveJavaClass(String var1);

    @Override
    public Collection<JavaSource> getJavaSources() {
        return this.context.getSources();
    }

    protected final Collection<JavaSource> getJavaSources(ClassLibraryFilter filter) {
        LinkedList<JavaSource> result2 = new LinkedList<JavaSource>();
        if (filter.accept(this)) {
            result2.addAll(this.context.getSources());
        }
        if (this.parentClassLibrary != null) {
            result2.addAll(this.parentClassLibrary.getJavaSources(filter));
        }
        return Collections.unmodifiableList(result2);
    }

    @Override
    public Collection<JavaClass> getJavaClasses() {
        return this.context.getClasses();
    }

    protected final Collection<JavaClass> getJavaClasses(ClassLibraryFilter filter) {
        LinkedList<JavaClass> result2 = new LinkedList<JavaClass>();
        if (filter.accept(this)) {
            result2.addAll(this.context.getClasses());
        }
        if (this.parentClassLibrary != null) {
            result2.addAll(this.parentClassLibrary.getJavaClasses(filter));
        }
        return Collections.unmodifiableList(result2);
    }

    @Override
    public Collection<JavaPackage> getJavaPackages() {
        return this.context.getPackages();
    }

    @Override
    public final JavaPackage getJavaPackage(String name) {
        JavaPackage result2 = this.context.getPackageByName(name);
        if (result2 == null && (result2 = this.resolveJavaPackage(name)) != null) {
            this.context.add(result2);
        }
        if (result2 == null && this.parentClassLibrary != null) {
            result2 = this.parentClassLibrary.getJavaPackage(name);
        }
        return result2;
    }

    protected abstract JavaPackage resolveJavaPackage(String var1);

    protected final Collection<JavaPackage> getJavaPackages(ClassLibraryFilter filter) {
        LinkedList<JavaPackage> result2 = new LinkedList<JavaPackage>();
        if (filter.accept(this)) {
            result2.addAll(this.context.getPackages());
        }
        if (this.parentClassLibrary != null) {
            result2.addAll(this.parentClassLibrary.getJavaPackages(filter));
        }
        return Collections.unmodifiableList(result2);
    }

    @Override
    public boolean hasClassReference(String name) {
        boolean result2;
        boolean bl = result2 = this.context.getClassByName(name) != null;
        if (!result2) {
            result2 = this.containsClassReference(name);
        }
        if (!result2 && this.parentClassLibrary != null) {
            result2 = this.parentClassLibrary.hasClassReference(name);
        }
        return result2;
    }

    protected abstract boolean containsClassReference(String var1);

    public final void setModelBuilderFactory(ModelBuilderFactory factory2) {
        this.modelBuilderFactory = factory2;
    }

    public final void setModelWriterFactory(ModelWriterFactory factory2) {
        this.modelWriterFactory = factory2;
    }

    protected final ModelWriterFactory getModelWriterFactory() {
        return this.modelWriterFactory;
    }

    protected final ModelBuilderFactory getModelBuilderFactory() {
        return this.modelBuilderFactory;
    }

    protected Builder getModelBuilder() {
        ModelBuilder result2 = this.modelBuilderFactory != null ? this.modelBuilderFactory.newInstance(this) : new ModelBuilder(this, new DefaultDocletTagFactory());
        result2.setModelWriterFactory(this.modelWriterFactory);
        return result2;
    }

    protected Builder getModelBuilder(URL url) {
        Builder result2 = this.getModelBuilder();
        result2.setUrl(url);
        return result2;
    }

    static interface ClassLibraryFilter {
        public boolean accept(AbstractClassLibrary var1);
    }
}

