/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.ErrorHandler;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.thoughtworks.qdox.parser.ParseException;
import com.thoughtworks.qdox.parser.impl.BinaryClassParser;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class ClassLoaderLibrary
extends AbstractClassLibrary {
    private transient List<ClassLoader> classLoaders = new LinkedList<ClassLoader>();
    private boolean defaultClassLoadersAdded = false;
    private boolean debugLexer;
    private boolean debugParser;
    private ErrorHandler errorHandler;

    public ClassLoaderLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public ClassLoaderLibrary(AbstractClassLibrary parent, ClassLoader classLoader) {
        super(parent);
        this.classLoaders.add(classLoader);
    }

    public void addClassLoader(ClassLoader classLoader) {
        this.classLoaders.add(classLoader);
    }

    public void addDefaultLoader() {
        if (!this.defaultClassLoadersAdded) {
            this.classLoaders.add(this.getClass().getClassLoader());
            this.classLoaders.add(Thread.currentThread().getContextClassLoader());
        }
        this.defaultClassLoadersAdded = true;
    }

    @Override
    protected JavaClass resolveJavaClass(String name) {
        JavaClass result2 = null;
        for (ClassLoader classLoader : this.classLoaders) {
            Object parser;
            InputStream sourceStream;
            String resource = name;
            if (resource.indexOf(36) > 0) {
                resource = resource.split("$")[0];
            }
            if ((sourceStream = classLoader.getResourceAsStream(resource = resource.replace('.', '/') + ".java")) != null) {
                Builder builder = this.getModelBuilder();
                JFlexLexer lexer = new JFlexLexer(sourceStream);
                parser = new Parser(lexer, builder);
                ((Parser)parser).setDebugLexer(this.debugLexer);
                ((Parser)parser).setDebugParser(this.debugParser);
                try {
                    if (((Parser)parser).parse()) {
                        result2 = builder.getSource().getClassByName(name);
                        break;
                    }
                }
                catch (ParseException pe) {
                    pe.setSourceInfo(resource);
                    if (this.errorHandler != null) {
                        this.errorHandler.handle(pe);
                    }
                    throw pe;
                }
            }
            if (result2 != null) continue;
            try {
                Builder builder;
                Class<?> clazz = classLoader.loadClass(name);
                if (clazz.getDeclaringClass() != null) {
                    clazz = clazz.getDeclaringClass();
                }
                if (!((BinaryClassParser)(parser = new BinaryClassParser(clazz, builder = this.getModelBuilder()))).parse()) continue;
                result2 = builder.getSource().getClassByName(name);
                break;
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
        }
        return result2;
    }

    @Override
    protected JavaPackage resolveJavaPackage(String name) {
        DefaultJavaPackage result2 = null;
        Package pckg = Package.getPackage(name);
        if (pckg != null) {
            result2 = new DefaultJavaPackage(name);
            result2.setClassLibrary(this);
        }
        return result2;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.classLoaders = new LinkedList<ClassLoader>();
        if (this.defaultClassLoadersAdded) {
            this.defaultClassLoadersAdded = false;
            this.addDefaultLoader();
        }
    }

    @Override
    protected boolean containsClassReference(String name) {
        boolean result2 = false;
        Iterator<ClassLoader> iter = this.classLoaders.iterator();
        while (!result2 && iter.hasNext()) {
            ClassLoader classLoader = iter.next();
            try {
                Class<?> clazz = classLoader.loadClass(name);
                result2 = clazz != null;
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return result2;
    }

    public void setDebugLexer(boolean debugLexer) {
        this.debugLexer = debugLexer;
    }

    public void setDebugParser(boolean debugParser) {
        this.debugParser = debugParser;
    }

    public void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }
}

