/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.library;

import com.thoughtworks.qdox.builder.Builder;
import com.thoughtworks.qdox.library.AbstractClassLibrary;
import com.thoughtworks.qdox.library.ErrorHandler;
import com.thoughtworks.qdox.library.JavaClassContext;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.model.impl.DefaultJavaPackage;
import com.thoughtworks.qdox.parser.JavaLexer;
import com.thoughtworks.qdox.parser.ParseException;
import com.thoughtworks.qdox.parser.impl.JFlexLexer;
import com.thoughtworks.qdox.parser.impl.Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public class SourceLibrary
extends AbstractClassLibrary {
    private JavaClassContext context = new JavaClassContext();
    private boolean debugLexer;
    private boolean debugParser;
    private static final String DEFAULT_ENCODING = System.getProperty("file.encoding");
    private String encoding;
    private ErrorHandler errorHandler;

    public SourceLibrary(AbstractClassLibrary parent) {
        super(parent);
    }

    public JavaSource addSource(Reader reader) throws ParseException {
        return this.addSource(reader, null);
    }

    private JavaSource addSource(Reader reader, URL url) {
        Builder builder = this.parse(reader, url);
        JavaSource source2 = null;
        if (builder != null) {
            source2 = builder.getSource();
            this.registerJavaSource(source2);
        }
        return source2;
    }

    public JavaSource addSource(InputStream stream) throws ParseException, IOException {
        Builder builder = this.parse(stream, null);
        JavaSource source2 = null;
        if (builder != null) {
            source2 = builder.getSource();
            this.registerJavaSource(source2);
        }
        return source2;
    }

    public JavaSource addSource(URL url) throws ParseException, IOException {
        return this.addSource(new InputStreamReader(url.openStream(), this.encoding), url);
    }

    public JavaSource addSource(File file) throws ParseException, IOException {
        JavaSource result2 = null;
        if (!"package-info.java".equals(file.getName())) {
            if ("module-info.java".equals(file.getName())) {
                return result2;
            }
            Builder builder = this.parse(new FileInputStream(file), file.toURI().toURL());
            if (builder != null) {
                result2 = builder.getSource();
            }
            if (result2 != null) {
                File packageInfo;
                if (this.getJavaPackage(result2.getPackageName()) == null && (packageInfo = new File(file.getParentFile(), "package-info.java")).exists()) {
                    JavaPackage pckg = this.parse(new FileInputStream(packageInfo), packageInfo.toURI().toURL()).getSource().getPackage();
                    this.context.add(pckg);
                }
                this.registerJavaSource(result2);
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Builder parse(Reader reader, URL url) throws ParseException {
        try {
            Builder builder = this.parse(new JFlexLexer(reader), url);
            return builder;
        }
        finally {
            try {
                reader.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Builder parse(InputStream stream, URL url) throws ParseException, UnsupportedEncodingException {
        try {
            Builder builder = this.parse(new JFlexLexer(new InputStreamReader(stream, this.getEncoding())), url);
            return builder;
        }
        finally {
            try {
                stream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private Builder parse(JavaLexer lexer, URL url) throws ParseException {
        Builder builder = this.getModelBuilder();
        builder.setUrl(url);
        Parser parser = new Parser(lexer, builder);
        parser.setDebugLexer(this.debugLexer);
        parser.setDebugParser(this.debugParser);
        try {
            if (parser.parse()) {
                return builder;
            }
        }
        catch (ParseException pe) {
            if (url != null) {
                pe.setSourceInfo(url.toExternalForm());
            }
            if (this.errorHandler != null) {
                this.errorHandler.handle(pe);
            }
            throw pe;
        }
        return null;
    }

    @Override
    protected JavaClass resolveJavaClass(String name) {
        return this.context.removeClassByName(name);
    }

    @Override
    protected JavaPackage resolveJavaPackage(String name) {
        return this.context.removePackageByName(name);
    }

    protected final void registerJavaSource(JavaSource source2) {
        if (source2 != null) {
            this.context.add(source2);
            this.registerJavaPackage(source2.getPackage());
            for (JavaClass cls : source2.getClasses()) {
                this.registerJavaClass(cls);
            }
        }
    }

    private void registerJavaPackage(JavaPackage pckg) {
        String pckgName;
        String string2 = pckgName = pckg == null || pckg.getName() == null ? "" : pckg.getName();
        if (this.getJavaPackage(pckgName) == null) {
            DefaultJavaPackage packageInfo = new DefaultJavaPackage(pckgName);
            packageInfo.setClassLibrary(this);
            this.context.add(packageInfo);
        }
    }

    private void registerJavaClass(JavaClass cls) {
        if (cls != null) {
            this.context.add(cls);
            this.getJavaPackage(cls.getPackageName()).getClasses().add(cls);
        }
        for (JavaClass innerCls : cls.getNestedClasses()) {
            this.registerJavaClass(innerCls);
        }
    }

    public final void setDebugLexer(boolean debugLexer) {
        this.debugLexer = debugLexer;
    }

    public final boolean isDebugLexer() {
        return this.debugLexer;
    }

    public final void setDebugParser(boolean debugParser) {
        this.debugParser = debugParser;
    }

    public final boolean isDebugParser() {
        return this.debugParser;
    }

    public final void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public final String getEncoding() {
        return this.encoding == null ? DEFAULT_ENCODING : this.encoding;
    }

    public final void setErrorHandler(ErrorHandler errorHandler) {
        this.errorHandler = errorHandler;
    }

    public final ErrorHandler getErrorHandler() {
        return this.errorHandler;
    }

    @Override
    public Collection<JavaClass> getJavaClasses() {
        LinkedList<JavaClass> result2 = new LinkedList<JavaClass>();
        List<JavaClass> unusedClasses = this.context.getClasses();
        Collection<JavaClass> usedClasses = this.getJavaClasses(new AbstractClassLibrary.ClassLibraryFilter(){

            @Override
            public boolean accept(AbstractClassLibrary classLibrary) {
                return classLibrary instanceof SourceLibrary;
            }
        });
        result2.addAll(usedClasses);
        result2.addAll(unusedClasses);
        return Collections.unmodifiableList(result2);
    }

    @Override
    public Collection<JavaPackage> getJavaPackages() {
        LinkedList<JavaPackage> result2 = new LinkedList<JavaPackage>();
        List<JavaPackage> unusedPackages = this.context.getPackages();
        Collection<JavaPackage> usedPackages = this.getJavaPackages(new AbstractClassLibrary.ClassLibraryFilter(){

            @Override
            public boolean accept(AbstractClassLibrary classLibrary) {
                return classLibrary instanceof SourceLibrary;
            }
        });
        result2.addAll(usedPackages);
        result2.addAll(unusedPackages);
        return Collections.unmodifiableList(result2);
    }

    @Override
    public Collection<JavaSource> getJavaSources() {
        LinkedList<JavaSource> result2 = new LinkedList<JavaSource>();
        List<JavaSource> unusedSources = this.context.getSources();
        Collection<JavaSource> usedSources = this.getJavaSources(new AbstractClassLibrary.ClassLibraryFilter(){

            @Override
            public boolean accept(AbstractClassLibrary classLibrary) {
                return classLibrary instanceof SourceLibrary;
            }
        });
        result2.addAll(usedSources);
        result2.addAll(unusedSources);
        return Collections.unmodifiableList(result2);
    }

    @Override
    protected boolean containsClassReference(String name) {
        return this.context.getClassByName(name) != null;
    }
}

