/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaAnnotation;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.expression.AnnotationValue;
import com.thoughtworks.qdox.model.expression.ExpressionVisitor;
import com.thoughtworks.qdox.model.impl.AbstractJavaModel;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultJavaAnnotation
extends AbstractJavaModel
implements AnnotationValue,
Serializable,
JavaAnnotation {
    private final JavaClass type;
    private final Map<String, AnnotationValue> properties = new LinkedHashMap<String, AnnotationValue>();
    private final Map<String, Object> namedParameters = new LinkedHashMap<String, Object>();

    public DefaultJavaAnnotation(JavaClass type2, Map<String, Object> namedParameters) {
        this.type = type2;
        if (this.properties != null) {
            for (Map.Entry<String, AnnotationValue> entry : this.properties.entrySet()) {
                String name = entry.getKey();
                AnnotationValue value = entry.getValue();
                this.setProperty(name, value);
            }
        }
    }

    public DefaultJavaAnnotation(JavaClass type2) {
        this(type2, null);
    }

    public final void setProperty(String name, AnnotationValue value) {
        this.properties.put(name, value);
        this.namedParameters.put(name, value.getParameterValue());
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public Object getNamedParameter(String key) {
        return this.namedParameters.get(key);
    }

    @Override
    public Map<String, Object> getNamedParameterMap() {
        return this.namedParameters;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeAnnotation(this).toString();
    }

    @Override
    public Object accept(ExpressionVisitor visitor2) {
        return visitor2.visit(this);
    }

    @Override
    public DefaultJavaAnnotation getParameterValue() {
        return this;
    }

    @Override
    public Map<String, AnnotationValue> getPropertyMap() {
        return this.properties;
    }

    @Override
    public AnnotationValue getProperty(String name) {
        return this.properties.get(name);
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        result2.append('@');
        result2.append(this.type.getFullyQualifiedName());
        result2.append('(');
        if (!this.namedParameters.isEmpty()) {
            Iterator<Map.Entry<String, Object>> i = this.namedParameters.entrySet().iterator();
            while (i.hasNext()) {
                result2.append(i.next());
                if (!i.hasNext()) continue;
                result2.append(',');
            }
        }
        result2.append(')');
        return result2.toString();
    }
}

