/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaConstructor;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaConstructor
extends DefaultJavaExecutable
implements JavaConstructor {
    private List<JavaTypeVariable<JavaConstructor>> typeParameters = Collections.emptyList();

    public void setTypeParameters(List<JavaTypeVariable<JavaConstructor>> typeParameters2) {
        this.typeParameters = typeParameters2;
    }

    public List<JavaTypeVariable<JavaConstructor>> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public boolean signatureMatches(List<JavaType> parameterTypes) {
        return this.signatureMatches(parameterTypes, false);
    }

    @Override
    public boolean signatureMatches(List<JavaType> parameterTypes, boolean varArgs) {
        return super.signatureMatches(parameterTypes, varArgs);
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeConstructor(this).toString();
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.isPrivate()) {
            result2.append("private ");
        } else if (this.isProtected()) {
            result2.append("protected ");
        } else if (this.isPublic()) {
            result2.append("public ");
        }
        if (this.getDeclaringClass() != null) {
            result2.append(this.getDeclaringClass().getFullyQualifiedName());
        }
        result2.append("(");
        Iterator<JavaParameter> paramIter = this.getParameters().iterator();
        while (paramIter.hasNext()) {
            String typeValue = DefaultJavaType.getResolvedValue(paramIter.next().getType(), this.getTypeParameters());
            result2.append(typeValue);
            if (!paramIter.hasNext()) continue;
            result2.append(",");
        }
        result2.append(")");
        if (this.getExceptions().size() > 0) {
            result2.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result2.append(excIter.next().getValue());
                if (!excIter.hasNext()) continue;
                result2.append(",");
            }
        }
        return result2.toString();
    }

    public int hashCode() {
        int hashCode2 = 3 + this.getName().hashCode();
        return hashCode2 *= 31 + this.getParameters().hashCode();
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!(obj2 instanceof JavaConstructor)) {
            return false;
        }
        JavaConstructor c = (JavaConstructor)obj2;
        if (c.getDeclaringClass() != null ? !c.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (!c.getName().equals(this.getName())) {
            return false;
        }
        List<JavaParameter> myParams = this.getParameters();
        List<JavaParameter> otherParams = c.getParameters();
        if (otherParams.size() != myParams.size()) {
            return false;
        }
        for (int i = 0; i < myParams.size(); ++i) {
            if (otherParams.get(i).equals(myParams.get(i))) continue;
            return false;
        }
        return this.isVarArgs() == c.isVarArgs();
    }
}

