/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaField;
import com.thoughtworks.qdox.model.expression.Expression;
import com.thoughtworks.qdox.model.impl.AbstractJavaEntity;
import java.util.List;

public class DefaultJavaField
extends AbstractJavaEntity
implements JavaField {
    private JavaClass type;
    private String initializationExpression;
    private boolean enumConstant;
    private JavaClass enumConstantClass;
    private List<Expression> enumConstantArguments;

    public DefaultJavaField(String name) {
        this.setName(name);
    }

    public DefaultJavaField(JavaClass type2, String name) {
        this(name);
        this.type = type2;
    }

    @Override
    public JavaClass getType() {
        return this.type;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeField(this).toString();
    }

    public void setType(JavaClass type2) {
        this.type = type2;
    }

    @Override
    public String getInitializationExpression() {
        return this.initializationExpression;
    }

    public void setInitializationExpression(String initializationExpression) {
        this.initializationExpression = initializationExpression;
    }

    @Override
    public boolean isEnumConstant() {
        return this.enumConstant;
    }

    public void setEnumConstant(boolean enumConstant) {
        this.enumConstant = enumConstant;
    }

    @Override
    public List<Expression> getEnumConstantArguments() {
        return this.enumConstantArguments;
    }

    public void setEnumConstantArguments(List<Expression> enumConstantArguments) {
        this.enumConstantArguments = enumConstantArguments;
    }

    @Override
    public JavaClass getEnumConstantClass() {
        return this.enumConstantClass;
    }

    public void setEnumConstantClass(JavaClass enumConstantClass) {
        this.enumConstantClass = enumConstantClass;
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.isPrivate()) {
            result2.append("private ");
        } else if (this.isProtected()) {
            result2.append("protected ");
        } else if (this.isPublic()) {
            result2.append("public ");
        }
        if (this.isStatic()) {
            result2.append("static ");
        }
        if (this.isFinal()) {
            result2.append("final ");
        }
        if (this.isTransient()) {
            result2.append("transient ");
        }
        if (this.isVolatile()) {
            result2.append("volatile ");
        }
        result2.append(this.type.getValue()).append(' ');
        result2.append(this.getDeclaringClass().getFullyQualifiedName()).append('.').append(this.getName());
        return result2.toString();
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!(obj2 instanceof JavaField)) {
            return false;
        }
        JavaField fld = (JavaField)obj2;
        if (!fld.getDeclaringClass().equals(this.getDeclaringClass())) {
            return false;
        }
        if (!fld.isEnumConstant() == this.isEnumConstant()) {
            return false;
        }
        return fld.getName().equals(this.getName());
    }

    public int hashCode() {
        int hashCode2 = 5;
        if (this.getDeclaringClass() != null) {
            hashCode2 *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            hashCode2 *= 37 + this.getName().hashCode();
        }
        return hashCode2;
    }
}

