/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaMethod;
import com.thoughtworks.qdox.model.JavaParameter;
import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaTypeVariable;
import com.thoughtworks.qdox.model.impl.DefaultJavaExecutable;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.beans.Introspector;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class DefaultJavaMethod
extends DefaultJavaExecutable
implements JavaMethod {
    private boolean defaultMethod;
    private JavaClass returns;
    private List<JavaTypeVariable<JavaMethod>> typeParameters = Collections.emptyList();

    public DefaultJavaMethod() {
    }

    public DefaultJavaMethod(String name) {
        this.setName(name);
    }

    public DefaultJavaMethod(JavaClass returns, String name) {
        this.returns = returns;
        this.setName(name);
    }

    @Override
    public boolean isDefault() {
        return this.defaultMethod;
    }

    public void setDefault(boolean defaultMethod) {
        this.defaultMethod = defaultMethod;
    }

    @Override
    public JavaClass getReturns() {
        return this.returns;
    }

    public void setTypeParameters(List<JavaTypeVariable<JavaMethod>> typeParameters2) {
        this.typeParameters = typeParameters2;
    }

    public List<JavaTypeVariable<JavaMethod>> getTypeParameters() {
        return this.typeParameters;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeMethod(this).toString();
    }

    @Override
    public String getDeclarationSignature(boolean withModifiers) {
        return this.getSignature(withModifiers, true);
    }

    public void setReturns(JavaClass returns) {
        this.returns = returns;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!(obj2 instanceof JavaMethod)) {
            return false;
        }
        JavaMethod other = (JavaMethod)obj2;
        if (other.getDeclaringClass() != null ? !other.getDeclaringClass().equals(this.getDeclaringClass()) : this.getDeclaringClass() != null) {
            return false;
        }
        if (other.getName() != null ? !other.getName().equals(this.getName()) : this.getName() != null) {
            return false;
        }
        if (other.getReturnType() != null ? !other.getReturnType().equals(this.getReturns()) : this.getReturns() != null) {
            return false;
        }
        List<JavaParameter> thisParams = this.getParameters();
        List<JavaParameter> otherParams = other.getParameters();
        if (otherParams.size() != thisParams.size()) {
            return false;
        }
        for (int i = 0; i < thisParams.size(); ++i) {
            if (otherParams.get(i).equals(thisParams.get(i))) continue;
            return false;
        }
        return this.isVarArgs() == other.isVarArgs();
    }

    public int hashCode() {
        int hashCode2 = 7;
        if (this.getDeclaringClass() != null) {
            hashCode2 *= 31 + this.getDeclaringClass().hashCode();
        }
        if (this.getName() != null) {
            hashCode2 *= 37 + this.getName().hashCode();
        }
        hashCode2 *= 41 + this.getParameters().hashCode();
        if (this.returns != null) {
            hashCode2 *= 43 + this.returns.hashCode();
        }
        return hashCode2;
    }

    @Override
    public boolean isPropertyAccessor() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().size() != 0) {
            return false;
        }
        if (this.getName().startsWith("is")) {
            return this.getName().length() > 2 && Character.isUpperCase(this.getName().charAt(2));
        }
        if (this.getName().startsWith("get")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    @Override
    public boolean isPropertyMutator() {
        if (this.isStatic()) {
            return false;
        }
        if (this.getParameters().size() != 1) {
            return false;
        }
        if (this.getName().startsWith("set")) {
            return this.getName().length() > 3 && Character.isUpperCase(this.getName().charAt(3));
        }
        return false;
    }

    @Override
    public JavaType getPropertyType() {
        if (this.isPropertyAccessor()) {
            return this.getReturns();
        }
        if (this.isPropertyMutator()) {
            return this.getParameters().get(0).getType();
        }
        return null;
    }

    @Override
    public String getPropertyName() {
        int start = -1;
        if (this.getName().startsWith("get") || this.getName().startsWith("set")) {
            start = 3;
        } else if (this.getName().startsWith("is")) {
            start = 2;
        } else {
            return null;
        }
        return Introspector.decapitalize(this.getName().substring(start));
    }

    public String toString() {
        StringBuilder result2 = new StringBuilder();
        if (this.isPrivate()) {
            result2.append("private ");
        } else if (this.isProtected()) {
            result2.append("protected ");
        } else if (this.isPublic()) {
            result2.append("public ");
        }
        if (this.isAbstract()) {
            result2.append("abstract ");
        }
        if (this.isStatic()) {
            result2.append("static ");
        }
        if (this.isFinal()) {
            result2.append("final ");
        }
        if (this.isSynchronized()) {
            result2.append("synchronized ");
        }
        if (this.isNative()) {
            result2.append("native ");
        }
        result2.append(this.getReturns().getFullyQualifiedName()).append(' ');
        if (this.getDeclaringClass() != null) {
            result2.append(this.getDeclaringClass().getBinaryName());
            result2.append(".");
        }
        result2.append(this.getName());
        result2.append("(");
        for (int paramIndex = 0; paramIndex < this.getParameters().size(); ++paramIndex) {
            JavaType originalType;
            JavaTypeVariable typeVariable;
            if (paramIndex > 0) {
                result2.append(",");
            }
            result2.append((typeVariable = DefaultJavaType.resolve(originalType = this.getParameters().get(paramIndex).getType(), this.getTypeParameters())) == null ? originalType.getFullyQualifiedName() : typeVariable.getBounds().get(0).getFullyQualifiedName());
        }
        result2.append(")");
        if (this.getExceptions().size() > 0) {
            result2.append(" throws ");
            Iterator<JavaClass> excIter = this.getExceptions().iterator();
            while (excIter.hasNext()) {
                result2.append(excIter.next().getFullyQualifiedName());
                if (!excIter.hasNext()) continue;
                result2.append(",");
            }
        }
        return result2.toString();
    }

    @Override
    public JavaType getReturnType() {
        return this.getReturnType(false);
    }

    @Override
    public JavaType getReturnType(boolean resolve2) {
        return this.returns;
    }

    @Override
    public boolean signatureMatches(String name, List<JavaType> parameterTypes) {
        return this.signatureMatches(name, parameterTypes, false);
    }

    @Override
    public boolean signatureMatches(String name, List<JavaType> parameterTypes, boolean varArg) {
        if (!name.equals(this.getName())) {
            return false;
        }
        return this.signatureMatches(parameterTypes, varArg);
    }
}

