/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModelUtils;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.impl.AbstractBaseJavaEntity;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public class DefaultJavaPackage
extends AbstractBaseJavaEntity
implements JavaPackage {
    private ClassLibrary classLibrary;
    private String name;
    private List<JavaClass> classes = new LinkedList<JavaClass>();

    public DefaultJavaPackage(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writePackage(this).toString();
    }

    public void setClassLibrary(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    @Override
    public ClassLibrary getJavaClassLibrary() {
        return this.classLibrary;
    }

    public void addClass(JavaClass clazz) {
        this.classes.add(clazz);
    }

    @Override
    public Collection<JavaClass> getClasses() {
        if (this == this.classLibrary.getJavaPackage(this.name)) {
            return this.classes;
        }
        return this.classLibrary.getJavaPackage(this.name).getClasses();
    }

    @Override
    public JavaClass getClassByName(String name) {
        JavaClass result2 = null;
        for (JavaClass candidateCls : this.classes) {
            result2 = JavaModelUtils.getClassByName(candidateCls, name);
            if (result2 == null) continue;
            result2 = candidateCls;
            break;
        }
        return result2;
    }

    @Override
    public JavaPackage getParentPackage() {
        String parentName = this.name.substring(0, this.name.lastIndexOf(46));
        return this.classLibrary.getJavaPackage(parentName);
    }

    public List<JavaPackage> getSubPackages() {
        String expected = this.name + ".";
        Collection<JavaPackage> jPackages = this.classLibrary.getJavaPackages();
        LinkedList<JavaPackage> retList = new LinkedList<JavaPackage>();
        for (JavaPackage jPackage : jPackages) {
            String pName = jPackage.getName();
            if (!pName.startsWith(expected) || pName.substring(expected.length()).indexOf(".") > -1) continue;
            retList.add(this.classLibrary.getJavaPackage(pName));
        }
        return retList;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof JavaPackage)) {
            return false;
        }
        JavaPackage that = (JavaPackage)o;
        return this.name.equals(that.getName());
    }

    public int hashCode() {
        return 11 + this.name.hashCode();
    }

    @Override
    public String toString() {
        return "package " + this.name;
    }
}

