/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.library.ClassLibrary;
import com.thoughtworks.qdox.model.JavaClass;
import com.thoughtworks.qdox.model.JavaModelUtils;
import com.thoughtworks.qdox.model.JavaPackage;
import com.thoughtworks.qdox.model.JavaSource;
import com.thoughtworks.qdox.writer.ModelWriter;
import com.thoughtworks.qdox.writer.ModelWriterFactory;
import com.thoughtworks.qdox.writer.impl.DefaultModelWriter;
import java.io.Serializable;
import java.net.URL;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;

public class DefaultJavaSource
implements JavaSource,
Serializable {
    private final ClassLibrary classLibrary;
    private ModelWriterFactory modelWriterFactory;
    private JavaPackage pkg;
    private final List<String> imports = new LinkedList<String>();
    private List<JavaClass> classes = new LinkedList<JavaClass>();
    private URL url;

    public DefaultJavaSource(ClassLibrary classLibrary) {
        this.classLibrary = classLibrary;
    }

    public void setURL(URL url) {
        this.url = url;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public JavaPackage getPackage() {
        return this.pkg;
    }

    public void setPackage(JavaPackage pkg) {
        this.pkg = pkg;
    }

    public void addImport(String imp) {
        this.imports.add(imp);
    }

    @Override
    public List<String> getImports() {
        return this.imports;
    }

    public void addClass(JavaClass cls) {
        this.classes.add(cls);
    }

    @Override
    public List<JavaClass> getClasses() {
        return Collections.unmodifiableList(this.classes);
    }

    @Override
    public String getCodeBlock() {
        return this.getModelWriter().writeSource(this).toString();
    }

    public String toString() {
        return this.getCodeBlock();
    }

    @Override
    public String getClassNamePrefix() {
        return this.pkg == null ? "" : this.pkg.getName() + '.';
    }

    @Override
    public JavaClass getNestedClassByName(String name) {
        JavaClass result2 = null;
        for (JavaClass candidateCls : this.classes) {
            if (!candidateCls.getName().equals(name)) continue;
            result2 = candidateCls;
            break;
        }
        return result2;
    }

    @Override
    public JavaClass getClassByName(String name) {
        JavaClass candidateCls;
        JavaClass result2 = null;
        Iterator<JavaClass> iterator2 = this.classes.iterator();
        while (iterator2.hasNext() && (result2 = JavaModelUtils.getClassByName(candidateCls = iterator2.next(), name)) == null) {
        }
        return result2;
    }

    @Override
    public ClassLibrary getJavaClassLibrary() {
        return this.classLibrary;
    }

    @Override
    public String getPackageName() {
        return this.pkg == null ? "" : this.pkg.getName();
    }

    public void setModelWriterFactory(ModelWriterFactory modelWriterFactory) {
        this.modelWriterFactory = modelWriterFactory;
    }

    private ModelWriter getModelWriter() {
        ModelWriter result2 = this.modelWriterFactory != null ? this.modelWriterFactory.newInstance() : new DefaultModelWriter();
        return result2;
    }
}

