/*
 * Decompiled with CFR 0.152.
 */
package com.thoughtworks.qdox.model.impl;

import com.thoughtworks.qdox.model.JavaType;
import com.thoughtworks.qdox.model.JavaWildcardType;
import com.thoughtworks.qdox.model.impl.DefaultJavaType;
import java.util.Collections;
import java.util.List;

public class DefaultJavaWildcardType
extends DefaultJavaType
implements JavaWildcardType {
    private BoundType boundType;
    private List<JavaType> bounds = Collections.emptyList();

    public DefaultJavaWildcardType() {
        super("?");
    }

    public DefaultJavaWildcardType(JavaType type2, BoundType boundType) {
        this();
        this.bounds = Collections.singletonList(type2);
        this.boundType = boundType;
    }

    @Override
    public String getFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getFullyQualifiedName());
        }
        return builder.toString();
    }

    @Override
    public String getGenericValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getGenericValue());
        }
        return builder.toString();
    }

    @Override
    public String getGenericFullyQualifiedName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getGenericFullyQualifiedName());
        }
        return builder.toString();
    }

    @Override
    public String getCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getCanonicalName());
        }
        return builder.toString();
    }

    @Override
    public String getGenericCanonicalName() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getGenericCanonicalName());
        }
        return builder.toString();
    }

    @Override
    public String getValue() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.getValue());
        }
        return builder.toString();
    }

    @Override
    public String toGenericString() {
        StringBuilder builder = this.getPreparedStringBuilder();
        for (JavaType type2 : this.bounds) {
            builder.append(type2.toGenericString());
        }
        return builder.toString();
    }

    private StringBuilder getPreparedStringBuilder() {
        StringBuilder builder = new StringBuilder("?");
        if (BoundType.EXTENDS.equals((Object)this.boundType)) {
            builder.append(" extends ");
        } else if (BoundType.SUPER.equals((Object)this.boundType)) {
            builder.append(" super ");
        }
        return builder;
    }

    public static enum BoundType {
        EXTENDS,
        SUPER;

    }
}

