/*
 * Decompiled with CFR 0.152.
 */
package io.netty.handler.codec.dns;

import io.netty.handler.codec.dns.DnsMessageUtil;
import io.netty.handler.codec.dns.DnsRecord;
import io.netty.handler.codec.dns.DnsRecordType;
import io.netty.util.internal.ObjectUtil;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.StringUtil;
import java.net.IDN;

public abstract class AbstractDnsRecord
implements DnsRecord {
    private final String name;
    private final DnsRecordType type;
    private final short dnsClass;
    private final long timeToLive;
    private int hashCode;

    protected AbstractDnsRecord(String name, DnsRecordType type2, long timeToLive) {
        this(name, type2, 1, timeToLive);
    }

    protected AbstractDnsRecord(String name, DnsRecordType type2, int dnsClass, long timeToLive) {
        ObjectUtil.checkPositiveOrZero(timeToLive, "timeToLive");
        this.name = AbstractDnsRecord.appendTrailingDot(AbstractDnsRecord.IDNtoASCII(name));
        this.type = ObjectUtil.checkNotNull(type2, "type");
        this.dnsClass = (short)dnsClass;
        this.timeToLive = timeToLive;
    }

    private static String IDNtoASCII(String name) {
        ObjectUtil.checkNotNull(name, "name");
        if (PlatformDependent.isAndroid() && ".".equals(name)) {
            return name;
        }
        return IDN.toASCII(name);
    }

    private static String appendTrailingDot(String name) {
        if (name.length() > 0 && name.charAt(name.length() - 1) != '.') {
            return name + '.';
        }
        return name;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public DnsRecordType type() {
        return this.type;
    }

    @Override
    public int dnsClass() {
        return this.dnsClass & 0xFFFF;
    }

    @Override
    public long timeToLive() {
        return this.timeToLive;
    }

    public boolean equals(Object obj2) {
        if (this == obj2) {
            return true;
        }
        if (!(obj2 instanceof DnsRecord)) {
            return false;
        }
        DnsRecord that = (DnsRecord)obj2;
        int hashCode2 = this.hashCode;
        if (hashCode2 != 0 && hashCode2 != that.hashCode()) {
            return false;
        }
        return this.type().intValue() == that.type().intValue() && this.dnsClass() == that.dnsClass() && this.name().equals(that.name());
    }

    public int hashCode() {
        int hashCode2 = this.hashCode;
        if (hashCode2 != 0) {
            return hashCode2;
        }
        this.hashCode = this.name.hashCode() * 31 + this.type().intValue() * 31 + this.dnsClass();
        return this.hashCode;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(64);
        buf.append(StringUtil.simpleClassName(this)).append('(').append(this.name()).append(' ').append(this.timeToLive()).append(' ');
        DnsMessageUtil.appendRecordClass(buf, this.dnsClass()).append(' ').append(this.type().name()).append(')');
        return buf.toString();
    }
}

