/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.jdk8;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.Observable;
import io.reactivex.rxjava3.core.Observer;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.EmptyDisposable;
import io.reactivex.rxjava3.internal.observers.DeferredScalarDisposable;
import io.reactivex.rxjava3.plugins.RxJavaPlugins;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collector;

public final class ObservableCollectWithCollector<T, A, R>
extends Observable<R> {
    final Observable<T> source;
    final Collector<? super T, A, R> collector;

    public ObservableCollectWithCollector(Observable<T> source2, Collector<? super T, A, R> collector) {
        this.source = source2;
        this.collector = collector;
    }

    @Override
    protected void subscribeActual(@NonNull Observer<? super R> observer) {
        Function<A, R> finisher;
        BiConsumer<A, ? super T> accumulator;
        A container;
        try {
            container = this.collector.supplier().get();
            accumulator = this.collector.accumulator();
            finisher = this.collector.finisher();
        }
        catch (Throwable ex) {
            Exceptions.throwIfFatal(ex);
            EmptyDisposable.error(ex, observer);
            return;
        }
        this.source.subscribe(new CollectorObserver<T, A, R>(observer, container, accumulator, finisher));
    }

    static final class CollectorObserver<T, A, R>
    extends DeferredScalarDisposable<R>
    implements Observer<T> {
        private static final long serialVersionUID = -229544830565448758L;
        final BiConsumer<A, T> accumulator;
        final Function<A, R> finisher;
        Disposable upstream;
        boolean done;
        A container;

        CollectorObserver(Observer<? super R> downstream, A container, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(downstream);
            this.container = container;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onSubscribe(@NonNull Disposable d) {
            if (DisposableHelper.validate(this.upstream, d)) {
                this.upstream = d;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            if (this.done) {
                return;
            }
            try {
                this.accumulator.accept(this.container, t2);
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.upstream.dispose();
                this.onError(ex);
            }
        }

        @Override
        public void onError(Throwable t2) {
            if (this.done) {
                RxJavaPlugins.onError(t2);
            } else {
                this.done = true;
                this.upstream = DisposableHelper.DISPOSED;
                this.container = null;
                this.downstream.onError(t2);
            }
        }

        @Override
        public void onComplete() {
            R result2;
            if (this.done) {
                return;
            }
            this.done = true;
            this.upstream = DisposableHelper.DISPOSED;
            A container = this.container;
            this.container = null;
            try {
                result2 = Objects.requireNonNull(this.finisher.apply(container), "The finisher returned a null value");
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                this.downstream.onError(ex);
                return;
            }
            this.complete(result2);
        }

        @Override
        public void dispose() {
            super.dispose();
            this.upstream.dispose();
        }
    }
}

