/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.observers;

import io.reactivex.rxjava3.annotations.NonNull;
import io.reactivex.rxjava3.core.CompletableObserver;
import io.reactivex.rxjava3.core.MaybeObserver;
import io.reactivex.rxjava3.core.SingleObserver;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import io.reactivex.rxjava3.internal.util.BlockingHelper;
import java.util.concurrent.CountDownLatch;

public final class BlockingDisposableMultiObserver<T>
extends CountDownLatch
implements MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver,
Disposable {
    T value;
    Throwable error;
    final SequentialDisposable upstream = new SequentialDisposable();

    public BlockingDisposableMultiObserver() {
        super(1);
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
        this.countDown();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        DisposableHelper.setOnce(this.upstream, d);
    }

    @Override
    public void onSuccess(@NonNull T t2) {
        this.value = t2;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onError(@NonNull Throwable e) {
        this.error = e;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    public void blockingConsume(CompletableObserver observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            observer.onComplete();
        }
    }

    public void blockingConsume(SingleObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            observer.onSuccess(this.value);
        }
    }

    public void blockingConsume(MaybeObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            T v = this.value;
            if (v == null) {
                observer.onComplete();
            } else {
                observer.onSuccess(v);
            }
        }
    }
}

