/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.disposables.Disposable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.queue.MpscLinkedQueue;
import io.reactivex.rxjava3.internal.subscribers.QueueDrainSubscriber;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.QueueDrainHelper;
import io.reactivex.rxjava3.subscribers.DisposableSubscriber;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.Collection;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableBufferExactBoundary<T, U extends Collection<? super T>, B>
extends AbstractFlowableWithUpstream<T, U> {
    final Publisher<B> boundary;
    final Supplier<U> bufferSupplier;

    public FlowableBufferExactBoundary(Flowable<T> source2, Publisher<B> boundary, Supplier<U> bufferSupplier) {
        super(source2);
        this.boundary = boundary;
        this.bufferSupplier = bufferSupplier;
    }

    @Override
    protected void subscribeActual(Subscriber<? super U> s2) {
        this.source.subscribe(new BufferExactBoundarySubscriber(new SerializedSubscriber<U>(s2), this.bufferSupplier, this.boundary));
    }

    static final class BufferBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends DisposableSubscriber<B> {
        final BufferExactBoundarySubscriber<T, U, B> parent;

        BufferBoundarySubscriber(BufferExactBoundarySubscriber<T, U, B> parent) {
            this.parent = parent;
        }

        @Override
        public void onNext(B t2) {
            this.parent.next();
        }

        @Override
        public void onError(Throwable t2) {
            this.parent.onError(t2);
        }

        @Override
        public void onComplete() {
            this.parent.onComplete();
        }
    }

    static final class BufferExactBoundarySubscriber<T, U extends Collection<? super T>, B>
    extends QueueDrainSubscriber<T, U, U>
    implements FlowableSubscriber<T>,
    Subscription,
    Disposable {
        final Supplier<U> bufferSupplier;
        final Publisher<B> boundary;
        Subscription upstream;
        Disposable other;
        U buffer;

        BufferExactBoundarySubscriber(Subscriber<? super U> actual, Supplier<U> bufferSupplier, Publisher<B> boundary) {
            super(actual, new MpscLinkedQueue());
            this.bufferSupplier = bufferSupplier;
            this.boundary = boundary;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            BufferBoundarySubscriber bs;
            Collection b;
            if (!SubscriptionHelper.validate(this.upstream, s2)) {
                return;
            }
            this.upstream = s2;
            try {
                b = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancelled = true;
                s2.cancel();
                EmptySubscription.error(e, this.downstream);
                return;
            }
            this.buffer = b;
            this.other = bs = new BufferBoundarySubscriber(this);
            this.downstream.onSubscribe(this);
            if (!this.cancelled) {
                s2.request(Long.MAX_VALUE);
                this.boundary.subscribe(bs);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onNext(T t2) {
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                U b = this.buffer;
                if (b == null) {
                    return;
                }
                b.add(t2);
            }
        }

        @Override
        public void onError(Throwable t2) {
            this.cancel();
            this.downstream.onError(t2);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void onComplete() {
            U b;
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = null;
            }
            this.queue.offer(b);
            this.done = true;
            if (this.enter()) {
                QueueDrainHelper.drainMaxLoop(this.queue, this.downstream, false, this, this);
            }
        }

        @Override
        public void request(long n) {
            this.requested(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.other.dispose();
                this.upstream.cancel();
                if (this.enter()) {
                    this.queue.clear();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void next() {
            U b;
            Collection next2;
            try {
                next2 = (Collection)Objects.requireNonNull(this.bufferSupplier.get(), "The buffer supplied is null");
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                this.cancel();
                this.downstream.onError(e);
                return;
            }
            BufferExactBoundarySubscriber bufferExactBoundarySubscriber = this;
            synchronized (bufferExactBoundarySubscriber) {
                b = this.buffer;
                if (b == null) {
                    return;
                }
                this.buffer = next2;
            }
            this.fastPathEmitMax(b, false, this);
        }

        @Override
        public void dispose() {
            this.cancel();
        }

        @Override
        public boolean isDisposed() {
            return this.cancelled;
        }

        @Override
        public boolean accept(Subscriber<? super U> a, U v) {
            this.downstream.onNext(v);
            return true;
        }
    }
}

