/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Function;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.operators.flowable.FlowableConcatMap;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.internal.util.AtomicThrowable;
import io.reactivex.rxjava3.internal.util.ErrorMode;
import io.reactivex.rxjava3.operators.QueueSubscription;
import io.reactivex.rxjava3.operators.SimpleQueue;
import io.reactivex.rxjava3.operators.SpscArrayQueue;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableConcatMapScheduler<T, R>
extends AbstractFlowableWithUpstream<T, R> {
    final Function<? super T, ? extends Publisher<? extends R>> mapper;
    final int prefetch;
    final ErrorMode errorMode;
    final Scheduler scheduler;

    public FlowableConcatMapScheduler(Flowable<T> source2, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, ErrorMode errorMode, Scheduler scheduler) {
        super(source2);
        this.mapper = mapper;
        this.prefetch = prefetch;
        this.errorMode = errorMode;
        this.scheduler = scheduler;
    }

    @Override
    protected void subscribeActual(Subscriber<? super R> s2) {
        switch (this.errorMode) {
            case BOUNDARY: {
                this.source.subscribe(new ConcatMapDelayed<T, R>(s2, this.mapper, this.prefetch, false, this.scheduler.createWorker()));
                break;
            }
            case END: {
                this.source.subscribe(new ConcatMapDelayed<T, R>(s2, this.mapper, this.prefetch, true, this.scheduler.createWorker()));
                break;
            }
            default: {
                this.source.subscribe(new ConcatMapImmediate<T, R>(s2, this.mapper, this.prefetch, this.scheduler.createWorker()));
            }
        }
    }

    static final class ConcatMapDelayed<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = -2945777694260521066L;
        final Subscriber<? super R> downstream;
        final boolean veryEnd;

        ConcatMapDelayed(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, boolean veryEnd, Scheduler.Worker worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.veryEnd = veryEnd;
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.done = true;
                this.schedule();
            }
        }

        @Override
        public void innerNext(R value) {
            this.downstream.onNext(value);
        }

        @Override
        public void innerError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                if (!this.veryEnd) {
                    this.upstream.cancel();
                    this.done = true;
                }
                this.active = false;
                this.schedule();
            }
        }

        @Override
        public void request(long n) {
            this.inner.request(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v;
                    Throwable ex;
                    boolean d = this.done;
                    if (d && !this.veryEnd && (ex = (Throwable)this.errors.get()) != null) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    try {
                        v = this.queue.poll();
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        Publisher p;
                        try {
                            p = (Publisher)Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c = this.consumed + 1;
                            if (c == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c);
                            } else {
                                this.consumed = c;
                            }
                        }
                        if (p instanceof Supplier) {
                            Object vr;
                            Supplier supplier = (Supplier)((Object)p);
                            try {
                                vr = supplier.get();
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal(e);
                                this.errors.tryAddThrowableOrReport(e);
                                if (!this.veryEnd) {
                                    this.upstream.cancel();
                                    this.errors.tryTerminateConsumer(this.downstream);
                                    this.worker.dispose();
                                    return;
                                }
                                vr = null;
                            }
                            if (vr == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                this.downstream.onNext(vr);
                                continue;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr, this.inner));
                        } else {
                            this.active = true;
                            p.subscribe(this.inner);
                        }
                    }
                }
                if (this.decrementAndGet() == 0) break;
            }
        }
    }

    static final class ConcatMapImmediate<T, R>
    extends BaseConcatMapSubscriber<T, R> {
        private static final long serialVersionUID = 7898995095634264146L;
        final Subscriber<? super R> downstream;
        final AtomicInteger wip;

        ConcatMapImmediate(Subscriber<? super R> actual, Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, Scheduler.Worker worker) {
            super(mapper, prefetch, worker);
            this.downstream = actual;
            this.wip = new AtomicInteger();
        }

        @Override
        void subscribeActual() {
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onError(Throwable t2) {
            if (this.errors.tryAddThrowableOrReport(t2)) {
                this.inner.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        boolean tryEnter() {
            return this.get() == 0 && this.compareAndSet(0, 1);
        }

        @Override
        public void innerNext(R value) {
            if (this.tryEnter()) {
                this.downstream.onNext(value);
                if (this.compareAndSet(1, 0)) {
                    return;
                }
                this.errors.tryTerminateConsumer(this.downstream);
                this.worker.dispose();
            }
        }

        @Override
        public void innerError(Throwable e) {
            if (this.errors.tryAddThrowableOrReport(e)) {
                this.upstream.cancel();
                if (this.getAndIncrement() == 0) {
                    this.errors.tryTerminateConsumer(this.downstream);
                    this.worker.dispose();
                }
            }
        }

        @Override
        public void request(long n) {
            this.inner.request(n);
        }

        @Override
        public void cancel() {
            if (!this.cancelled) {
                this.cancelled = true;
                this.inner.cancel();
                this.upstream.cancel();
                this.worker.dispose();
                this.errors.tryTerminateAndReport();
            }
        }

        @Override
        void schedule() {
            if (this.wip.getAndIncrement() == 0) {
                this.worker.schedule(this);
            }
        }

        @Override
        public void run() {
            while (true) {
                if (this.cancelled) {
                    return;
                }
                if (!this.active) {
                    boolean empty;
                    Object v;
                    boolean d = this.done;
                    try {
                        v = this.queue.poll();
                    }
                    catch (Throwable e) {
                        Exceptions.throwIfFatal(e);
                        this.upstream.cancel();
                        this.errors.tryAddThrowableOrReport(e);
                        this.errors.tryTerminateConsumer(this.downstream);
                        this.worker.dispose();
                        return;
                    }
                    boolean bl = empty = v == null;
                    if (d && empty) {
                        this.downstream.onComplete();
                        this.worker.dispose();
                        return;
                    }
                    if (!empty) {
                        Publisher p;
                        try {
                            p = (Publisher)Objects.requireNonNull(this.mapper.apply(v), "The mapper returned a null Publisher");
                        }
                        catch (Throwable e) {
                            Exceptions.throwIfFatal(e);
                            this.upstream.cancel();
                            this.errors.tryAddThrowableOrReport(e);
                            this.errors.tryTerminateConsumer(this.downstream);
                            this.worker.dispose();
                            return;
                        }
                        if (this.sourceMode != 1) {
                            int c = this.consumed + 1;
                            if (c == this.limit) {
                                this.consumed = 0;
                                this.upstream.request(c);
                            } else {
                                this.consumed = c;
                            }
                        }
                        if (p instanceof Supplier) {
                            Object vr;
                            Supplier supplier = (Supplier)((Object)p);
                            try {
                                vr = supplier.get();
                            }
                            catch (Throwable e) {
                                Exceptions.throwIfFatal(e);
                                this.upstream.cancel();
                                this.errors.tryAddThrowableOrReport(e);
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            if (vr == null || this.cancelled) continue;
                            if (this.inner.isUnbounded()) {
                                if (!this.tryEnter()) continue;
                                this.downstream.onNext(vr);
                                if (this.compareAndSet(1, 0)) continue;
                                this.errors.tryTerminateConsumer(this.downstream);
                                this.worker.dispose();
                                return;
                            }
                            this.active = true;
                            this.inner.setSubscription(new FlowableConcatMap.SimpleScalarSubscription(vr, this.inner));
                        } else {
                            this.active = true;
                            p.subscribe(this.inner);
                        }
                    }
                }
                if (this.wip.decrementAndGet() == 0) break;
            }
        }
    }

    static abstract class BaseConcatMapSubscriber<T, R>
    extends AtomicInteger
    implements FlowableSubscriber<T>,
    FlowableConcatMap.ConcatMapSupport<R>,
    Subscription,
    Runnable {
        private static final long serialVersionUID = -3511336836796789179L;
        final FlowableConcatMap.ConcatMapInner<R> inner;
        final Function<? super T, ? extends Publisher<? extends R>> mapper;
        final int prefetch;
        final int limit;
        final Scheduler.Worker worker;
        Subscription upstream;
        int consumed;
        SimpleQueue<T> queue;
        volatile boolean done;
        volatile boolean cancelled;
        final AtomicThrowable errors;
        volatile boolean active;
        int sourceMode;

        BaseConcatMapSubscriber(Function<? super T, ? extends Publisher<? extends R>> mapper, int prefetch, Scheduler.Worker worker) {
            this.mapper = mapper;
            this.prefetch = prefetch;
            this.limit = prefetch - (prefetch >> 2);
            this.inner = new FlowableConcatMap.ConcatMapInner(this);
            this.errors = new AtomicThrowable();
            this.worker = worker;
        }

        @Override
        public final void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                if (s2 instanceof QueueSubscription) {
                    QueueSubscription f = (QueueSubscription)s2;
                    int m4 = f.requestFusion(7);
                    if (m4 == 1) {
                        this.sourceMode = m4;
                        this.queue = f;
                        this.done = true;
                        this.subscribeActual();
                        this.schedule();
                        return;
                    }
                    if (m4 == 2) {
                        this.sourceMode = m4;
                        this.queue = f;
                        this.subscribeActual();
                        s2.request(this.prefetch);
                        return;
                    }
                }
                this.queue = new SpscArrayQueue<T>(this.prefetch);
                this.subscribeActual();
                s2.request(this.prefetch);
            }
        }

        abstract void schedule();

        abstract void subscribeActual();

        @Override
        public final void onNext(T t2) {
            if (this.sourceMode != 2 && !this.queue.offer(t2)) {
                this.upstream.cancel();
                this.onError(new IllegalStateException("Queue full?!"));
                return;
            }
            this.schedule();
        }

        @Override
        public final void onComplete() {
            this.done = true;
            this.schedule();
        }

        @Override
        public final void innerComplete() {
            this.active = false;
            this.schedule();
        }
    }
}

