/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.exceptions.Exceptions;
import io.reactivex.rxjava3.functions.Supplier;
import io.reactivex.rxjava3.internal.subscriptions.EmptySubscription;
import java.util.Objects;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;

public final class FlowableDefer<T>
extends Flowable<T> {
    final Supplier<? extends Publisher<? extends T>> supplier;

    public FlowableDefer(Supplier<? extends Publisher<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribeActual(Subscriber<? super T> s2) {
        Publisher<? super T> pub;
        try {
            pub = Objects.requireNonNull(this.supplier.get(), "The publisher supplied is null");
        }
        catch (Throwable t2) {
            Exceptions.throwIfFatal(t2);
            EmptySubscription.error(t2, s2);
            return;
        }
        pub.subscribe(s2);
    }
}

