/*
 * Decompiled with CFR 0.152.
 */
package io.reactivex.rxjava3.internal.operators.flowable;

import io.reactivex.rxjava3.core.Flowable;
import io.reactivex.rxjava3.core.FlowableSubscriber;
import io.reactivex.rxjava3.core.Scheduler;
import io.reactivex.rxjava3.internal.operators.flowable.AbstractFlowableWithUpstream;
import io.reactivex.rxjava3.internal.subscriptions.SubscriptionHelper;
import io.reactivex.rxjava3.subscribers.SerializedSubscriber;
import java.util.concurrent.TimeUnit;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public final class FlowableDelay<T>
extends AbstractFlowableWithUpstream<T, T> {
    final long delay;
    final TimeUnit unit;
    final Scheduler scheduler;
    final boolean delayError;

    public FlowableDelay(Flowable<T> source2, long delay, TimeUnit unit, Scheduler scheduler, boolean delayError) {
        super(source2);
        this.delay = delay;
        this.unit = unit;
        this.scheduler = scheduler;
        this.delayError = delayError;
    }

    @Override
    protected void subscribeActual(Subscriber<? super T> t2) {
        Subscriber<? super T> downstream = this.delayError ? t2 : new SerializedSubscriber<T>(t2);
        Scheduler.Worker w = this.scheduler.createWorker();
        this.source.subscribe(new DelaySubscriber<T>(downstream, this.delay, this.unit, w, this.delayError));
    }

    static final class DelaySubscriber<T>
    implements FlowableSubscriber<T>,
    Subscription {
        final Subscriber<? super T> downstream;
        final long delay;
        final TimeUnit unit;
        final Scheduler.Worker w;
        final boolean delayError;
        Subscription upstream;

        DelaySubscriber(Subscriber<? super T> actual, long delay, TimeUnit unit, Scheduler.Worker w, boolean delayError) {
            this.downstream = actual;
            this.delay = delay;
            this.unit = unit;
            this.w = w;
            this.delayError = delayError;
        }

        @Override
        public void onSubscribe(Subscription s2) {
            if (SubscriptionHelper.validate(this.upstream, s2)) {
                this.upstream = s2;
                this.downstream.onSubscribe(this);
            }
        }

        @Override
        public void onNext(T t2) {
            this.w.schedule(new OnNext(t2), this.delay, this.unit);
        }

        @Override
        public void onError(Throwable t2) {
            this.w.schedule(new OnError(t2), this.delayError ? this.delay : 0L, this.unit);
        }

        @Override
        public void onComplete() {
            this.w.schedule(new OnComplete(), this.delay, this.unit);
        }

        @Override
        public void request(long n) {
            this.upstream.request(n);
        }

        @Override
        public void cancel() {
            this.upstream.cancel();
            this.w.dispose();
        }

        final class OnComplete
        implements Runnable {
            OnComplete() {
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.downstream.onComplete();
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnError
        implements Runnable {
            private final Throwable t;

            OnError(Throwable t2) {
                this.t = t2;
            }

            @Override
            public void run() {
                try {
                    DelaySubscriber.this.downstream.onError(this.t);
                }
                finally {
                    DelaySubscriber.this.w.dispose();
                }
            }
        }

        final class OnNext
        implements Runnable {
            private final T t;

            OnNext(T t2) {
                this.t = t2;
            }

            @Override
            public void run() {
                DelaySubscriber.this.downstream.onNext(this.t);
            }
        }
    }
}

